/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.fakes.BlockPredicateInterface;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.utils.BlockInfo;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_11;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2096;
import net.minecraft.class_2265;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2520;
import net.minecraft.class_266;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_274;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_4115;
import net.minecraft.class_4142;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_9;
import net.minecraft.server.MinecraftServer;

public class ValueConversions {
    private static final Int2ObjectMap<SlotParam> slotIdsToSlotParams = new Int2ObjectOpenHashMap<SlotParam>(){
        {
            int n;
            for (n = 0; n < 54; ++n) {
                this.put(n, new SlotParam(null, n));
            }
            for (n = 0; n < 27; ++n) {
                this.put(200 + n, new SlotParam("enderchest", n));
            }
            for (n = 0; n < 8; ++n) {
                this.put(300 + n, new SlotParam(null, n));
            }
            for (n = 0; n < 15; ++n) {
                this.put(500 + n, new SlotParam(null, n + 2));
            }
            this.put(98, new SlotParam("equipment", 0));
            this.put(99, new SlotParam("equipment", 5));
            for (n = 0; n < 4; ++n) {
                this.put(100 + n, new SlotParam("equipment", n + 1));
            }
            this.put(400, new SlotParam(null, 0));
            this.put(401, new SlotParam(null, 1));
        }
    };

    public static Value of(class_2338 pos) {
        return ListValue.of(new NumericValue(pos.method_10263()), new NumericValue(pos.method_10264()), new NumericValue(pos.method_10260()));
    }

    public static Value of(class_243 vec) {
        return ListValue.of(new NumericValue(vec.field_1352), new NumericValue(vec.field_1351), new NumericValue(vec.field_1350));
    }

    public static Value of(class_2265 cpos) {
        return ListValue.of(new NumericValue(cpos.comp_638()), new NumericValue(cpos.comp_639()));
    }

    public static Value of(class_3218 world) {
        return ValueConversions.of(world.method_27983().method_29177());
    }

    public static Value of(class_3620 color) {
        return ListValue.of(StringValue.of(BlockInfo.mapColourName.get(color)), ValueConversions.ofRGB(color.field_16011));
    }

    public static <T extends Number> Value of(class_2096<T> range) {
        return ListValue.of(NumericValue.of(range.method_9038()), NumericValue.of(range.method_9042()));
    }

    public static Value of(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return Value.NULL;
        }
        return ListValue.of(ValueConversions.of(class_2378.field_11142.method_10221((Object)stack.method_7909())), new NumericValue(stack.method_7947()), NBTSerializableValue.fromStack(stack));
    }

    public static Value of(class_266 objective) {
        return ListValue.of(StringValue.of(objective.method_1113()), StringValue.of(objective.method_1116().method_1225()));
    }

    public static Value of(class_274 criteria) {
        return ListValue.of(StringValue.of(criteria.method_1225()), BooleanValue.of(criteria.method_1226()));
    }

    public static Value of(class_2394 particle) {
        String repr = particle.method_10293();
        if (repr.startsWith("minecraft:")) {
            return StringValue.of(repr.substring(10));
        }
        return StringValue.of(repr);
    }

    public static Value ofRGB(int value) {
        return new NumericValue(value * 256 + 255);
    }

    public static class_1937 dimFromValue(Value dimensionValue, MinecraftServer server) {
        String dimString;
        if (dimensionValue instanceof EntityValue) {
            return ((EntityValue)dimensionValue).getEntity().method_5770();
        }
        if (dimensionValue instanceof BlockValue) {
            BlockValue bv = (BlockValue)dimensionValue;
            if (bv.getWorld() != null) {
                return bv.getWorld();
            }
            throw new InternalExpressionException("dimension argument accepts only world-localized block arguments");
        }
        switch (dimString = dimensionValue.getString().toLowerCase(Locale.ROOT)) {
            case "nether": 
            case "the_nether": {
                return server.method_3847(class_1937.field_25180);
            }
            case "end": 
            case "the_end": {
                return server.method_3847(class_1937.field_25181);
            }
            case "overworld": 
            case "over_world": {
                return server.method_3847(class_1937.field_25179);
            }
        }
        class_5321 dim = null;
        class_2960 id = new class_2960(dimString);
        for (class_5321 world : server.method_29435()) {
            if (!id.equals((Object)world.method_29177())) continue;
            dim = world;
            break;
        }
        if (dim == null) {
            throw new ThrowStatement(dimString, Throwables.UNKNOWN_DIMENSION);
        }
        return server.method_3847(dim);
    }

    public static Value of(class_5321<?> dim) {
        return ValueConversions.of(dim.method_29177());
    }

    public static Value of(class_6862<?> tagKey) {
        return ValueConversions.of(tagKey.comp_327());
    }

    public static Value of(class_2960 id) {
        if (id == null) {
            return Value.NULL;
        }
        if (id.method_12836().equals("minecraft")) {
            return new StringValue(id.method_12832());
        }
        return new StringValue(id.toString());
    }

    public static String simplify(class_2960 id) {
        if (id == null) {
            return "";
        }
        if (id.method_12836().equals("minecraft")) {
            return id.method_12832();
        }
        return id.toString();
    }

    public static Value of(class_4208 pos) {
        return ListValue.of(ValueConversions.of(pos.method_19442()), ValueConversions.of(pos.method_19446()));
    }

    public static Value fromPath(class_3218 world, class_11 path) {
        ArrayList<Value> nodes = new ArrayList<Value>();
        int len = path.method_38();
        for (int i = 0; i < len; ++i) {
            class_9 node = path.method_40(i);
            nodes.add(ListValue.of(new BlockValue(null, world, node.method_22879()), new StringValue(node.field_41.name().toLowerCase(Locale.ROOT)), new NumericValue(node.field_43), BooleanValue.of(node.field_42)));
        }
        return ListValue.wrap(nodes);
    }

    public static Value fromTimedMemory(class_1297 e, long expiry, Object v) {
        Value ret = ValueConversions.fromEntityMemory(e, v);
        if (ret.isNull() || expiry == Long.MAX_VALUE) {
            return ret;
        }
        return ListValue.of(ret, new NumericValue(expiry));
    }

    private static Value fromEntityMemory(class_1297 e, Object v) {
        if (v instanceof class_4208) {
            class_4208 pos = (class_4208)v;
            return ValueConversions.of(pos);
        }
        if (v instanceof class_1297) {
            return new EntityValue((class_1297)v);
        }
        if (v instanceof class_2338) {
            return new BlockValue(null, (class_3218)e.method_5770(), (class_2338)v);
        }
        if (v instanceof Number) {
            return new NumericValue(((Number)((Object)v)).doubleValue());
        }
        if (v instanceof Boolean) {
            return BooleanValue.of((Boolean)((Object)v));
        }
        if (v instanceof UUID) {
            return ValueConversions.ofUUID((class_3218)e.method_5770(), (UUID)((Object)v));
        }
        if (v instanceof class_1282) {
            class_1282 source = (class_1282)v;
            return ListValue.of(new StringValue(source.method_5525()), source.method_5529() == null ? Value.NULL : new EntityValue(source.method_5529()));
        }
        if (v instanceof class_11) {
            return ValueConversions.fromPath((class_3218)e.method_5770(), (class_11)v);
        }
        if (v instanceof class_4115) {
            return new BlockValue(null, (class_3218)e.method_5770(), ((class_4115)v).method_18989());
        }
        if (v instanceof class_4142) {
            return ListValue.of(new BlockValue(null, (class_3218)e.method_5770(), ((class_4142)v).method_19094().method_18989()), new NumericValue(((class_4142)v).method_19095()), new NumericValue(((class_4142)v).method_19096()));
        }
        if (v instanceof Set) {
            v = new ArrayList((Set)((Object)v));
        }
        if (v instanceof List) {
            List l = v;
            if (l.isEmpty()) {
                return ListValue.of(new Value[0]);
            }
            Object el = l.get(0);
            if (el instanceof class_1297) {
                return ListValue.wrap(l.stream().map(o -> new EntityValue((class_1297)o)).collect(Collectors.toList()));
            }
            if (el instanceof class_4208) {
                return ListValue.wrap(l.stream().map(o -> ValueConversions.of((class_4208)o)).collect(Collectors.toList()));
            }
        }
        return Value.NULL;
    }

    private static Value ofUUID(class_3218 entityWorld, UUID uuid) {
        class_1297 current = entityWorld.method_14190(uuid);
        return ListValue.of(current == null ? Value.NULL : new EntityValue(current), new StringValue(uuid.toString()));
    }

    public static Value of(class_238 box) {
        return ListValue.of(ListValue.fromTriple(box.field_1323, box.field_1322, box.field_1321), ListValue.fromTriple(box.field_1320, box.field_1325, box.field_1324));
    }

    public static Value of(class_3341 box) {
        return ListValue.of(ListValue.fromTriple(box.method_35415(), box.method_35416(), box.method_35417()), ListValue.fromTriple(box.method_35418(), box.method_35419(), box.method_35420()));
    }

    public static Value of(class_3449 structure) {
        if (structure == null || structure == class_3449.field_16713) {
            return Value.NULL;
        }
        class_3341 boundingBox = structure.method_14969();
        if (boundingBox.method_35418() < boundingBox.method_35415() || boundingBox.method_35419() < boundingBox.method_35416() || boundingBox.method_35420() < boundingBox.method_35417()) {
            return Value.NULL;
        }
        HashMap<Value, Value> ret = new HashMap<Value, Value>();
        ret.put(new StringValue("box"), ValueConversions.of(boundingBox));
        ArrayList<Value> pieces = new ArrayList<Value>();
        for (class_3443 piece : structure.method_14963()) {
            class_3341 box = piece.method_14935();
            if (box.method_35418() < box.method_35415() || box.method_35419() < box.method_35416() || box.method_35420() < box.method_35417()) continue;
            pieces.add(ListValue.of(new StringValue(NBTSerializableValue.nameFromRegistryId(class_2378.field_16645.method_10221((Object)piece.method_16653()))), piece.method_14934() == null ? Value.NULL : new StringValue(piece.method_14934().method_10151()), ListValue.fromTriple(box.method_35415(), box.method_35416(), box.method_35417()), ListValue.fromTriple(box.method_35418(), box.method_35419(), box.method_35420())));
        }
        ret.put(new StringValue("pieces"), ListValue.wrap(pieces));
        return MapValue.wrap(ret);
    }

    public static Value fromProperty(class_2680 state, class_2769<?> p) {
        Comparable object = state.method_11654(p);
        if (object instanceof Boolean || object instanceof Number) {
            return StringValue.of(object.toString());
        }
        if (object instanceof class_3542) {
            return StringValue.of(((class_3542)object).method_15434());
        }
        throw new InternalExpressionException("Unknown property type: " + p.method_11899());
    }

    public static Value ofVanillaSlotResult(int itemSlot) {
        SlotParam ret = (SlotParam)slotIdsToSlotParams.get(itemSlot);
        if (ret == null) {
            return ListValue.of(Value.NULL, new NumericValue(itemSlot));
        }
        return ret.build();
    }

    public static Value ofBlockPredicate(class_5455 registryAccess, Predicate<class_2694> blockPredicate) {
        BlockPredicateInterface predicateData = (BlockPredicateInterface)((Object)blockPredicate);
        return ListValue.of(predicateData.getCMBlockState() == null ? Value.NULL : ValueConversions.of(class_2378.field_11146.method_10221((Object)predicateData.getCMBlockState().method_26204())), predicateData.getCMBlockTagKey() == null ? Value.NULL : ValueConversions.of(((class_6885.class_6888)registryAccess.method_30530(class_2378.field_25105).method_40266(predicateData.getCMBlockTagKey()).get()).method_40251()), MapValue.wrap(predicateData.getCMProperties()), predicateData.getCMDataTag() == null ? Value.NULL : new NBTSerializableValue((class_2520)predicateData.getCMDataTag()));
    }

    public static Value guess(class_3218 serverWorld, Object o) {
        if (o == null) {
            return Value.NULL;
        }
        if (o instanceof List) {
            return ListValue.wrap(((List)o).stream().map(oo -> ValueConversions.guess(serverWorld, oo)).collect(Collectors.toList()));
        }
        if (o instanceof class_2338) {
            return new BlockValue(null, serverWorld, (class_2338)o);
        }
        if (o instanceof class_1297) {
            return EntityValue.of((class_1297)o);
        }
        if (o instanceof class_243) {
            return ValueConversions.of((class_243)o);
        }
        if (o instanceof class_2382) {
            return ValueConversions.of(new class_2338((class_2382)o));
        }
        if (o instanceof class_238) {
            return ValueConversions.of((class_238)o);
        }
        if (o instanceof class_3341) {
            return ValueConversions.of((class_3341)o);
        }
        if (o instanceof class_1799) {
            return ValueConversions.of((class_1799)o);
        }
        if (o instanceof Boolean) {
            return BooleanValue.of((Boolean)o);
        }
        if (o instanceof Number) {
            return NumericValue.of((Number)o);
        }
        if (o instanceof class_2960) {
            return ValueConversions.of((class_2960)o);
        }
        return StringValue.of(o.toString());
    }

    record SlotParam(String type, int id) {
        public ListValue build() {
            return ListValue.of(StringValue.of(this.type), new NumericValue(this.id));
        }
    }
}

