/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.language;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.exception.ExitStatement;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ProcessedThrowStatement;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.language.Operators;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.util.Map;
import java.util.stream.Collectors;

public class ControlFlow {
    public static void apply(Expression expression) {
        expression.addLazyBinaryOperator(";", Operators.precedence.get("nextop;"), true, true, t -> Context.Type.VOID, (c, t, lv1, lv2) -> {
            lv1.evalValue((Context)c, Context.VOID);
            Value v2 = lv2.evalValue((Context)c, (Context.Type)((Object)t));
            return (cc, tt) -> v2;
        });
        expression.addPureLazyFunction("then", -1, t -> Context.Type.VOID, (c, t, lv) -> {
            int imax = lv.size() - 1;
            for (int i = 0; i < imax; ++i) {
                ((LazyValue)lv.get(i)).evalValue((Context)c, Context.VOID);
            }
            Value v = ((LazyValue)lv.get(imax)).evalValue((Context)c, (Context.Type)((Object)t));
            return (cc, tt) -> v;
        });
        expression.addFunctionalEquivalence(";", "then");
        expression.addLazyFunction("if", (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'if' statement needs to have at least one condition and one case");
            }
            for (int i = 0; i < lv.size() - 1; i += 2) {
                if (!((LazyValue)lv.get(i)).evalValue((Context)c, Context.BOOLEAN).getBoolean()) continue;
                Value ret = ((LazyValue)lv.get(i + 1)).evalValue((Context)c, (Context.Type)((Object)t));
                return (cc, tt) -> ret;
            }
            if (lv.size() % 2 == 1) {
                Value ret = ((LazyValue)lv.get(lv.size() - 1)).evalValue((Context)c, (Context.Type)((Object)t));
                return (cc, tt) -> ret;
            }
            return (cc, tt) -> Value.NULL;
        });
        expression.addImpureFunction("exit", lv -> {
            throw new ExitStatement(lv.size() == 0 ? Value.NULL : (Value)lv.get(0));
        });
        expression.addImpureFunction("throw", lv -> {
            switch (lv.size()) {
                case 0: {
                    throw new ThrowStatement(Value.NULL, Throwables.USER_DEFINED);
                }
                case 1: {
                    throw new ThrowStatement((Value)lv.get(0), Throwables.USER_DEFINED);
                }
                case 2: {
                    throw new ThrowStatement((Value)lv.get(1), Throwables.getTypeForException(((Value)lv.get(0)).getString()));
                }
                case 3: {
                    throw new ThrowStatement((Value)lv.get(2), Throwables.getTypeForException(((Value)lv.get(1)).getString()), ((Value)lv.get(0)).getString());
                }
            }
            throw new InternalExpressionException("throw() can't accept more than 3 parameters");
        });
        expression.addLazyFunction("try", (c, t, lv) -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("'try' needs at least an expression block, and either a catch_epr, or a number of pairs of filters and catch_expr");
            }
            try {
                Value retval = ((LazyValue)lv.get(0)).evalValue((Context)c, (Context.Type)((Object)t));
                return (c_, t_) -> retval;
            }
            catch (ProcessedThrowStatement ret) {
                LazyValue _trace;
                LazyValue __;
                Value val;
                block11: {
                    block10: {
                        if (lv.size() == 1) {
                            if (!ret.thrownExceptionType.isUserException()) {
                                throw ret;
                            }
                            return (c_, t_) -> Value.NULL;
                        }
                        if (lv.size() > 3 && lv.size() % 2 == 0) {
                            throw new InternalExpressionException("Try-catch block needs the code to run, and either a catch expression for user thrown exceptions, or a number of pairs of filters and catch expressions");
                        }
                        val = null;
                        __ = c.getVariable("_");
                        c.setVariable("_", (__c, __t) -> ret.data.reboundedTo("_"));
                        _trace = c.getVariable("_trace");
                        c.setVariable("_trace", (__c, __t) -> MapValue.wrap(Map.of(StringValue.of("stack"), ListValue.wrap(ret.stack.stream().map(f -> ListValue.of(StringValue.of(f.getModule().name()), StringValue.of(f.getString()), NumericValue.of(f.getToken().lineno + 1), NumericValue.of(f.getToken().linepos + 1))).collect(Collectors.toList())), StringValue.of("locals"), MapValue.wrap(ret.context.variables.entrySet().stream().filter(e -> !((String)e.getKey()).equals("_trace")).collect(Collectors.toMap(e -> StringValue.of((String)e.getKey()), e -> ((LazyValue)e.getValue()).evalValue(ret.context)))), StringValue.of("token"), ListValue.of(StringValue.of(ret.token.surface), NumericValue.of(ret.token.lineno + 1), NumericValue.of(ret.token.linepos + 1)))));
                        if (lv.size() != 2) break block10;
                        if (!ret.thrownExceptionType.isUserException()) break block11;
                        val = ((LazyValue)lv.get(1)).evalValue((Context)c, (Context.Type)((Object)t));
                        break block11;
                    }
                    for (int pointer = 1; pointer < lv.size() - 1; pointer += 2) {
                        if (!ret.thrownExceptionType.isRelevantFor(((LazyValue)lv.get(pointer)).evalValue((Context)c).getString())) continue;
                        val = ((LazyValue)lv.get(pointer + 1)).evalValue((Context)c, (Context.Type)((Object)t));
                        break;
                    }
                }
                c.setVariable("_", __);
                if (_trace != null) {
                    c.setVariable("_trace", _trace);
                } else {
                    c.delVariable("_trace");
                }
                if (val == null) {
                    throw ret;
                }
                Value retval = val;
                return (c_, t_) -> retval;
            }
        });
    }
}

