/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.command;

import carpet.script.CarpetScriptHost;
import carpet.script.command.CommandArgument;
import carpet.script.value.FunctionValue;
import com.google.common.collect.Lists;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class CommandToken
implements Comparable<CommandToken> {
    public String surface;
    public boolean isArgument;
    public CommandArgument type;

    private CommandToken(String surface, CommandArgument type) {
        this.surface = surface;
        this.type = type;
        this.isArgument = type != null;
    }

    public static CommandToken getToken(String source, CarpetScriptHost host) {
        if (!source.startsWith("<")) {
            if (!source.matches("[_a-zA-Z]+")) {
                return null;
            }
            return new CommandToken(source, null);
        }
        if (!(source = source.substring(1, source.length() - 1)).matches("[_a-zA-Z]+")) {
            return null;
        }
        CommandArgument arg = CommandArgument.getTypeForArgument(source, host);
        return new CommandToken(source, arg);
    }

    public static List<CommandToken> parseSpec(String spec, CarpetScriptHost host) throws CommandSyntaxException {
        if ((spec = spec.trim()).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CommandToken> elements = new ArrayList<CommandToken>();
        HashSet<String> seenArgs = new HashSet<String>();
        for (String el : spec.split("\\s+")) {
            CommandToken tok = CommandToken.getToken(el, host);
            if (tok == null) {
                throw CommandArgument.error("Unrecognized command token: " + el);
            }
            if (tok.isArgument) {
                if (seenArgs.contains(tok.surface)) {
                    throw CommandArgument.error("Repeated command argument: " + tok.surface + ", for '" + spec + "'. Argument names have to be unique");
                }
                seenArgs.add(tok.surface);
            }
            elements.add(tok);
        }
        return elements;
    }

    public static String specFromSignature(FunctionValue function) {
        ArrayList tokens = Lists.newArrayList((Object[])new String[]{function.getString()});
        for (String arg : function.getArguments()) {
            tokens.add("<" + arg + ">");
        }
        return String.join((CharSequence)" ", tokens);
    }

    public ArgumentBuilder<class_2168, ?> getCommandNode(CarpetScriptHost host) throws CommandSyntaxException {
        if (this.isArgument) {
            return CommandArgument.argumentNode(this.surface, host);
        }
        return class_2170.method_9247((String)this.surface);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandToken that = (CommandToken)o;
        return this.surface.equals(that.surface) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.surface, this.type);
    }

    @Override
    public int compareTo(CommandToken o) {
        if (this.isArgument && !o.isArgument) {
            return 1;
        }
        if (!this.isArgument && o.isArgument) {
            return -1;
        }
        return this.surface.compareTo(o.surface);
    }
}

