/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.ThreadedAnvilChunkStorageInterface;
import carpet.helpers.TickSpeed;
import carpet.utils.CarpetProfiler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3898;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3215.class})
public abstract class ServerChunkCache_tickMixin {
    @Shadow
    @Final
    class_3218 field_13945;
    @Shadow
    @Final
    public class_3898 field_17254;
    CarpetProfiler.ProfilerToken currentSection;

    @Inject(method={"tickChunks"}, at={@At(value="HEAD")})
    private void startSpawningSection(CallbackInfo ci) {
        this.currentSection = CarpetProfiler.start_section((class_1937)this.field_13945, "Spawning", CarpetProfiler.TYPE.GENERAL);
    }

    @Inject(method={"tickChunks"}, at={@At(value="FIELD", target="net/minecraft/server/level/ServerChunkCache.level:Lnet/minecraft/server/level/ServerLevel;", ordinal=10)})
    private void skipChunkTicking(CallbackInfo ci) {
        if (this.currentSection != null) {
            CarpetProfiler.end_current_section(this.currentSection);
        }
    }

    @Inject(method={"tickChunks"}, at={@At(value="INVOKE", target="net/minecraft/server/level/ServerLevel.tickChunk(Lnet/minecraft/world/level/chunk/LevelChunk;I)V", shift=At.Shift.AFTER)})
    private void resumeSpawningSection(CallbackInfo ci) {
        this.currentSection = CarpetProfiler.start_section((class_1937)this.field_13945, "Spawning", CarpetProfiler.TYPE.GENERAL);
    }

    @Inject(method={"tickChunks"}, at={@At(value="RETURN")})
    private void stopSpawningSection(CallbackInfo ci) {
        if (this.currentSection != null) {
            CarpetProfiler.end_current_section(this.currentSection);
        }
    }

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isDebug()Z"))
    private boolean skipChunkTicking(class_3218 serverWorld) {
        boolean debug = serverWorld.method_27982();
        if (!TickSpeed.process_entities) {
            if (!debug) {
                ArrayList holders = Lists.newArrayList(((ThreadedAnvilChunkStorageInterface)this.field_17254).getChunksCM());
                Collections.shuffle(holders);
                for (class_3193 holder : holders) {
                    Optional optional = holder.method_16145().getNow(class_3193.field_16427).left();
                    if (!optional.isPresent()) continue;
                    holder.method_14006((class_2818)optional.get());
                }
            }
            return true;
        }
        return debug;
    }
}

