/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.CarpetSettings;
import carpet.logging.logHelpers.ExplosionLogHelper;
import carpet.mixins.ExplosionAccessor;
import carpet.script.CarpetEventServer;
import carpet.utils.Messenger;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1900;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3614;
import net.minecraft.class_47;
import net.minecraft.class_5819;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class OptimizedExplosion {
    private static List<class_1297> entitylist;
    private static class_243 vec3dmem;
    private static long tickmem;
    public static int explosionSound;
    private static Object2DoubleOpenHashMap<Pair<class_243, class_238>> densityCache;
    private static MutablePair<class_243, class_238> pairMutable;
    private static Object2ObjectOpenHashMap<class_2338, class_2680> stateCache;
    private static Object2ObjectOpenHashMap<class_2338, class_3610> fluidCache;
    private static class_2338.class_2339 posMutable;
    private static ObjectOpenHashSet<class_2338> affectedBlockPositionsSet;
    private static boolean firstRay;
    private static boolean rayCalcDone;
    private static ArrayList<Float> chances;
    private static class_2338 blastChanceLocation;
    private static List<class_1297> entityList;

    public static void doExplosionA(class_1927 e, ExplosionLogHelper eLogger) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        entityList.clear();
        boolean eventNeeded = CarpetEventServer.Event.EXPLOSION_OUTCOME.isNeeded() && !eAccess.getLevel().method_8608();
        OptimizedExplosion.blastCalc(e);
        if (!CarpetSettings.explosionNoBlockDamage) {
            rayCalcDone = false;
            firstRay = true;
            OptimizedExplosion.getAffectedPositionsOnPlaneY(e, 0, 0, 15, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneY(e, 15, 0, 15, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneX(e, 0, 1, 14, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneX(e, 15, 1, 14, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneZ(e, 0, 1, 14, 1, 14);
            OptimizedExplosion.getAffectedPositionsOnPlaneZ(e, 15, 1, 14, 1, 14);
            stateCache.clear();
            fluidCache.clear();
            e.method_8346().addAll(affectedBlockPositionsSet);
            affectedBlockPositionsSet.clear();
        }
        float f3 = eAccess.getRadius() * 2.0f;
        int k1 = class_3532.method_15357((double)(eAccess.getX() - (double)f3 - 1.0));
        int l1 = class_3532.method_15357((double)(eAccess.getX() + (double)f3 + 1.0));
        int i2 = class_3532.method_15357((double)(eAccess.getY() - (double)f3 - 1.0));
        int i1 = class_3532.method_15357((double)(eAccess.getY() + (double)f3 + 1.0));
        int j2 = class_3532.method_15357((double)(eAccess.getZ() - (double)f3 - 1.0));
        int j1 = class_3532.method_15357((double)(eAccess.getZ() + (double)f3 + 1.0));
        class_243 vec3d = new class_243(eAccess.getX(), eAccess.getY(), eAccess.getZ());
        if (vec3dmem == null || !vec3dmem.equals((Object)vec3d) || tickmem != eAccess.getLevel().method_8510()) {
            vec3dmem = vec3d;
            tickmem = eAccess.getLevel().method_8510();
            entitylist = eAccess.getLevel().method_8335(null, new class_238((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
            explosionSound = 0;
        }
        ++explosionSound;
        class_1297 explodingEntity = eAccess.getSource();
        for (int k2 = 0; k2 < entitylist.size(); ++k2) {
            class_1657 player;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            class_1297 entity = entitylist.get(k2);
            if (entity == explodingEntity) {
                OptimizedExplosion.removeFast(entitylist, k2);
                --k2;
                continue;
            }
            if (entity instanceof class_1541 && explodingEntity != null && entity.method_23317() == explodingEntity.method_23317() && entity.method_23318() == explodingEntity.method_23318() && entity.method_23321() == explodingEntity.method_23321()) {
                if (eLogger == null) continue;
                eLogger.onEntityImpacted(entity, new class_243(0.0, -0.9923437498509884, 0.0));
                continue;
            }
            if (entity.method_5659() || !((d12 = Math.sqrt(entity.method_5649(eAccess.getX(), eAccess.getY(), eAccess.getZ())) / (double)f3) <= 1.0) || (d13 = Math.sqrt((d5 = entity.method_23317() - eAccess.getX()) * d5 + (d7 = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - eAccess.getY()) * d7 + (d9 = entity.method_23321() - eAccess.getZ()) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            pairMutable.setLeft((Object)vec3d);
            pairMutable.setRight((Object)entity.method_5829());
            double density = densityCache.getOrDefault(pairMutable, Double.MAX_VALUE);
            if (density == Double.MAX_VALUE) {
                Pair pair = Pair.of((Object)vec3d, (Object)entity.method_5829());
                density = class_1927.method_17752((class_243)vec3d, (class_1297)entity);
                densityCache.put((Object)pair, density);
            }
            if (eventNeeded) {
                entityList.add(entity);
            }
            double d10 = (1.0 - d12) * density;
            entity.method_5643(e.method_8349(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)));
            double d11 = d10;
            if (entity instanceof class_1309) {
                d11 = class_1900.method_8237((class_1309)((class_1309)entity), (double)d10);
            }
            if (eLogger != null) {
                eLogger.onEntityImpacted(entity, new class_243(d5 * d11, d7 * d11, d9 * d11));
            }
            entity.method_18799(entity.method_18798().method_1031(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof class_1657) || (player = (class_1657)entity).method_7325() || player.method_7337() && player.method_31549().field_7479) continue;
            e.method_8351().put(player, new class_243(d5 * d10, d7 * d10, d9 * d10));
        }
        densityCache.clear();
    }

    public static void doExplosionB(class_1927 e, boolean spawnParticles) {
        boolean damagesTerrain;
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        class_1937 world = eAccess.getLevel();
        double posX = eAccess.getX();
        double posY = eAccess.getY();
        double posZ = eAccess.getZ();
        if (CarpetEventServer.Event.EXPLOSION_OUTCOME.isNeeded() && !world.method_8608()) {
            CarpetEventServer.Event.EXPLOSION_OUTCOME.onExplosion((class_3218)world, eAccess.getSource(), () -> ((class_1927)e).method_8347(), eAccess.getX(), eAccess.getY(), eAccess.getZ(), eAccess.getRadius(), eAccess.isFire(), e.method_8346(), entityList, eAccess.getBlockInteraction());
        }
        boolean bl = damagesTerrain = eAccess.getBlockInteraction() != class_1927.class_4179.field_18685;
        if (explosionSound < 100 || explosionSound % 100 == 0) {
            world.method_43128(null, posX, posY, posZ, class_3417.field_15152, class_3419.field_15245, 4.0f, (1.0f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.2f) * 0.7f);
            if (spawnParticles) {
                if (eAccess.getRadius() >= 2.0f && damagesTerrain) {
                    world.method_8406((class_2394)class_2398.field_11221, posX, posY, posZ, 1.0, 0.0, 0.0);
                } else {
                    world.method_8406((class_2394)class_2398.field_11236, posX, posY, posZ, 1.0, 0.0, 0.0);
                }
            }
        }
        if (damagesTerrain) {
            ObjectArrayList objectArrayList = new ObjectArrayList();
            class_156.method_43028((ObjectArrayList)((ObjectArrayList)e.method_8346()), (class_5819)world.field_9229);
            boolean dropFromExplosions = CarpetSettings.xpFromExplosions || e.method_8347() instanceof class_1657;
            for (class_2338 blockpos : e.method_8346()) {
                class_2680 state = world.method_8320(blockpos);
                class_2248 block = state.method_26204();
                if (state.method_26207() == class_3614.field_15959) continue;
                if (block.method_9533(e) && world instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)world;
                    class_2586 blockEntity = state.method_31709() ? world.method_8321(blockpos) : null;
                    class_47.class_48 lootBuilder = new class_47.class_48((class_3218)eAccess.getLevel()).method_311(eAccess.getLevel().field_9229).method_312(class_181.field_24424, (Object)class_243.method_24953((class_2382)blockpos)).method_312(class_181.field_1229, (Object)class_1799.field_8037).method_306(class_181.field_1228, (Object)blockEntity).method_306(class_181.field_1226, (Object)eAccess.getSource());
                    if (eAccess.getBlockInteraction() == class_1927.class_4179.field_18687) {
                        lootBuilder.method_312(class_181.field_1225, (Object)Float.valueOf(eAccess.getRadius()));
                    }
                    state.method_26180(serverLevel, blockpos, class_1799.field_8037, dropFromExplosions);
                    state.method_26189(lootBuilder).forEach(itemStackx -> OptimizedExplosion.method_24023((ObjectArrayList<Pair<class_1799, class_2338>>)objectArrayList, itemStackx, blockpos.method_10062()));
                }
                world.method_8652(blockpos, class_2246.field_10124.method_9564(), 3);
                block.method_9586(world, blockpos, e);
            }
            objectArrayList.forEach(p -> class_2248.method_9577((class_1937)world, (class_2338)((class_2338)p.getRight()), (class_1799)((class_1799)p.getLeft())));
        }
        if (eAccess.isFire()) {
            for (class_2338 blockpos1 : e.method_8346()) {
                class_2818 chunk = world.method_8497(blockpos1.method_10263() >> 4, blockpos1.method_10260() >> 4);
                class_2338 down = blockpos1.method_10087(1);
                if (eAccess.getRandom().method_43048(3) != 0 || chunk.method_8320(blockpos1).method_26207() != class_3614.field_15959 || !chunk.method_8320(down).method_26216((class_1922)world, down)) continue;
                world.method_8501(blockpos1, class_2246.field_10036.method_9564());
            }
        }
    }

    private static void method_24023(ObjectArrayList<Pair<class_1799, class_2338>> objectArrayList, class_1799 itemStack, class_2338 blockPos) {
        int i = objectArrayList.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)objectArrayList.get(j);
            class_1799 itemStack2 = (class_1799)pair.getLeft();
            if (!class_1542.method_24017((class_1799)itemStack2, (class_1799)itemStack)) continue;
            class_1799 itemStack3 = class_1542.method_24018((class_1799)itemStack2, (class_1799)itemStack, (int)16);
            objectArrayList.set(j, (Object)Pair.of((Object)itemStack3, (Object)((class_2338)pair.getRight())));
            if (!itemStack.method_7960()) continue;
            return;
        }
        objectArrayList.add((Object)Pair.of((Object)itemStack, (Object)blockPos));
    }

    private static void removeFast(List<class_1297> lst, int index) {
        if (index < lst.size() - 1) {
            lst.set(index, lst.get(lst.size() - 1));
        }
        lst.remove(lst.size() - 1);
    }

    private static void rayCalcs(class_1927 e) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        boolean first = true;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    float rand = eAccess.getLevel().field_9229.method_43057();
                    if (CarpetSettings.tntRandomRange >= 0.0) {
                        rand = (float)CarpetSettings.tntRandomRange;
                    }
                    double d4 = eAccess.getX();
                    double d6 = eAccess.getY();
                    double d8 = eAccess.getZ();
                    float f1 = 0.3f;
                    for (float f = eAccess.getRadius() * (0.7f + rand * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        class_2338 blockpos = new class_2338(d4, d6, d8);
                        class_2680 state = eAccess.getLevel().method_8320(blockpos);
                        class_3610 fluidState = eAccess.getLevel().method_8316(blockpos);
                        if (state.method_26207() != class_3614.field_15959) {
                            float f2 = Math.max(state.method_26204().method_9520(), fluidState.method_15760());
                            if (eAccess.getSource() != null) {
                                f2 = eAccess.getSource().method_5774(e, (class_1922)eAccess.getLevel(), blockpos, state, fluidState, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (eAccess.getSource() == null || eAccess.getSource().method_5853(e, (class_1922)eAccess.getLevel(), blockpos, state, f))) {
                            affectedBlockPositionsSet.add((Object)blockpos);
                        } else if (first) {
                            return;
                        }
                        first = false;
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
    }

    private static void getAffectedPositionsOnPlaneX(class_1927 e, int x, int yStart, int yEnd, int zStart, int zEnd) {
        if (!rayCalcDone) {
            double xRel = (double)x / 15.0 * 2.0 - 1.0;
            for (int z = zStart; z <= zEnd; ++z) {
                double zRel = (double)z / 15.0 * 2.0 - 1.0;
                for (int y = yStart; y <= yEnd; ++y) {
                    double yRel = (double)y / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static void getAffectedPositionsOnPlaneY(class_1927 e, int y, int xStart, int xEnd, int zStart, int zEnd) {
        if (!rayCalcDone) {
            double yRel = (double)y / 15.0 * 2.0 - 1.0;
            for (int z = zStart; z <= zEnd; ++z) {
                double zRel = (double)z / 15.0 * 2.0 - 1.0;
                for (int x = xStart; x <= xEnd; ++x) {
                    double xRel = (double)x / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static void getAffectedPositionsOnPlaneZ(class_1927 e, int z, int xStart, int xEnd, int yStart, int yEnd) {
        if (!rayCalcDone) {
            double zRel = (double)z / 15.0 * 2.0 - 1.0;
            for (int x = xStart; x <= xEnd; ++x) {
                double xRel = (double)x / 15.0 * 2.0 - 1.0;
                for (int y = yStart; y <= yEnd; ++y) {
                    double yRel = (double)y / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static boolean checkAffectedPosition(class_1927 e, double xRel, double yRel, double zRel) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        double len = Math.sqrt(xRel * xRel + yRel * yRel + zRel * zRel);
        double xInc = xRel / len * 0.3;
        double yInc = yRel / len * 0.3;
        double zInc = zRel / len * 0.3;
        float rand = eAccess.getLevel().field_9229.method_43057();
        float sizeRand = CarpetSettings.tntRandomRange >= 0.0 ? (float)CarpetSettings.tntRandomRange : rand;
        double posX = eAccess.getX();
        double posY = eAccess.getY();
        double posZ = eAccess.getZ();
        float f1 = 0.3f;
        for (float size = eAccess.getRadius() * (0.7f + sizeRand * 0.6f); size > 0.0f; size -= 0.22500001f) {
            posMutable.method_10102(posX, posY, posZ);
            class_2680 state = (class_2680)stateCache.get((Object)posMutable);
            class_3610 fluid = (class_3610)fluidCache.get((Object)posMutable);
            class_2338 posImmutable = null;
            if (state == null) {
                posImmutable = posMutable.method_10062();
                state = eAccess.getLevel().method_8320(posImmutable);
                stateCache.put((Object)posImmutable, (Object)state);
                fluid = eAccess.getLevel().method_8316(posImmutable);
                fluidCache.put((Object)posImmutable, (Object)fluid);
            }
            if (state.method_26207() != class_3614.field_15959) {
                float resistance = Math.max(state.method_26204().method_9520(), fluid.method_15760());
                if (eAccess.getSource() != null) {
                    resistance = eAccess.getSource().method_5774(e, (class_1922)eAccess.getLevel(), (class_2338)posMutable, state, fluid, resistance);
                }
                size -= (resistance + 0.3f) * 0.3f;
            }
            if (size > 0.0f) {
                if (eAccess.getSource() == null || eAccess.getSource().method_5853(e, (class_1922)eAccess.getLevel(), (class_2338)posMutable, state, size)) {
                    affectedBlockPositionsSet.add((Object)(posImmutable != null ? posImmutable : posMutable.method_10062()));
                }
            } else if (firstRay) {
                rayCalcDone = true;
                return true;
            }
            firstRay = false;
            posX += xInc;
            posY += yInc;
            posZ += zInc;
        }
        return false;
    }

    public static void setBlastChanceLocation(class_2338 p) {
        blastChanceLocation = p;
    }

    private static void blastCalc(class_1927 e) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        if (blastChanceLocation == null || blastChanceLocation.method_40081(eAccess.getX(), eAccess.getY(), eAccess.getZ()) > 200.0) {
            return;
        }
        chances.clear();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = eAccess.getX();
                    double d6 = eAccess.getY();
                    double d8 = eAccess.getZ();
                    boolean found = false;
                    float f1 = 0.3f;
                    for (float f = eAccess.getRadius() * 1.3f; f > 0.0f; f -= 0.22500001f) {
                        class_2338 blockpos = new class_2338(d4, d6, d8);
                        class_2680 state = eAccess.getLevel().method_8320(blockpos);
                        class_3610 fluidState = eAccess.getLevel().method_8316(blockpos);
                        if (state.method_26207() != class_3614.field_15959) {
                            float f2 = Math.max(state.method_26204().method_9520(), fluidState.method_15760());
                            if (eAccess.getSource() != null) {
                                f2 = eAccess.getSource().method_5774(e, (class_1922)eAccess.getLevel(), blockpos, state, fluidState, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (eAccess.getSource() == null || eAccess.getSource().method_5853(e, (class_1922)eAccess.getLevel(), blockpos, state, f)) && !found && blockpos.equals((Object)blastChanceLocation)) {
                            chances.add(Float.valueOf(f));
                            found = true;
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
    }

    private static void showTNTblastChance(class_1927 e) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        double randMax = 0.6f * eAccess.getRadius();
        double total = 0.0;
        boolean fullyBlownUp = false;
        boolean first = true;
        int rays = 0;
        for (float f3 : chances) {
            ++rays;
            double calc = (double)f3 - randMax;
            if (calc > 0.0) {
                fullyBlownUp = true;
            }
            double chancePerRay = Math.abs(calc) / randMax;
            if (fullyBlownUp) continue;
            if (first) {
                first = false;
                total = chancePerRay;
                continue;
            }
            total *= chancePerRay;
        }
        if (fullyBlownUp) {
            total = 0.0;
        }
        double chance = 1.0 - total;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setRoundingMode(RoundingMode.DOWN);
        nf.setMaximumFractionDigits(2);
        for (class_1657 player : eAccess.getLevel().method_18456()) {
            Messenger.m(player, "w Pop: ", "c " + nf.format(chance) + " ", "^w Chance for the block to be destroyed by the blast: " + chance, "?" + chance, "w Remain: ", String.format("c %.2f ", total), "^w Chance the block survives the blast: " + total, "?" + total, "w Rays: ", String.format("c %d ", rays), "^w TNT blast rays going through the block", "?" + rays, "w Size: ", String.format("c %.1f ", Float.valueOf(eAccess.getRadius())), "^w TNT blast size", "?" + eAccess.getRadius(), "w @: ", String.format("c [%.1f %.1f %.1f] ", eAccess.getX(), eAccess.getY(), eAccess.getZ()), "^w TNT blast location X:" + eAccess.getX() + " Y:" + eAccess.getY() + " Z:" + eAccess.getZ(), "?" + eAccess.getX() + " " + eAccess.getY() + " " + eAccess.getZ());
        }
    }

    static {
        explosionSound = 0;
        densityCache = new Object2DoubleOpenHashMap();
        pairMutable = new MutablePair();
        stateCache = new Object2ObjectOpenHashMap();
        fluidCache = new Object2ObjectOpenHashMap();
        posMutable = new class_2338.class_2339(0, 0, 0);
        affectedBlockPositionsSet = new ObjectOpenHashSet();
        chances = new ArrayList();
        entityList = new ArrayList<class_1297>();
    }
}

