/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.fakes.SpawnGroupInterface;
import carpet.helpers.HopperCounter;
import carpet.helpers.TickSpeed;
import carpet.settings.SettingsManager;
import carpet.utils.Messenger;
import carpet.utils.SpawnReporter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1311;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class SpawnCommand {
    private static final Map<String, class_1311> MOB_CATEGORY_MAP = Arrays.stream(class_1311.values()).collect(Collectors.toMap(class_1311::method_6133, Function.identity()));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").requires(player -> SettingsManager.canUseCommand(player, CarpetSettings.commandSpawn));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalargumentbuilder.then(class_2170.method_9247((String)"list").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(c -> SpawnCommand.listSpawns((class_2168)c.getSource(), class_2262.method_9697((CommandContext)c, (String)"pos")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tracking").executes(c -> SpawnCommand.printTrackingReport((class_2168)c.getSource()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"start").executes(c -> SpawnCommand.startTracking((class_2168)c.getSource(), null, null))).then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(c -> SpawnCommand.startTracking((class_2168)c.getSource(), class_2262.method_9697((CommandContext)c, (String)"from"), class_2262.method_9697((CommandContext)c, (String)"to"))))))).then(class_2170.method_9247((String)"stop").executes(c -> SpawnCommand.stopTracking((class_2168)c.getSource())))).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9264(Arrays.stream(class_1311.values()).map(class_1311::method_6133), (SuggestionsBuilder)b)).executes(c -> SpawnCommand.recentSpawnsForType((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"type")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"test").executes(c -> SpawnCommand.runTest((class_2168)c.getSource(), 72000, null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)10)).executes(c -> SpawnCommand.runTest((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"), null))).then(class_2170.method_9244((String)"counter", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9264(Arrays.stream(class_1767.values()).map(class_1767::toString), (SuggestionsBuilder)b)).executes(c -> SpawnCommand.runTest((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"), StringArgumentType.getString((CommandContext)c, (String)"counter"))))))).then(class_2170.method_9247((String)"mocking").then(class_2170.method_9244((String)"to do or not to do?", (ArgumentType)BoolArgumentType.bool()).executes(c -> SpawnCommand.toggleMocking((class_2168)c.getSource(), BoolArgumentType.getBool((CommandContext)c, (String)"to do or not to do?")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rates").executes(c -> SpawnCommand.generalMobcaps((class_2168)c.getSource()))).then(class_2170.method_9247((String)"reset").executes(c -> SpawnCommand.resetSpawnRates((class_2168)c.getSource())))).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9264(Arrays.stream(class_1311.values()).map(class_1311::method_6133), (SuggestionsBuilder)b)).then(class_2170.method_9244((String)"rounds", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests((c, b) -> class_2172.method_9253((String[])new String[]{"1"}, (SuggestionsBuilder)b)).executes(c -> SpawnCommand.setSpawnRates((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"type"), IntegerArgumentType.getInteger((CommandContext)c, (String)"rounds"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mobcaps").executes(c -> SpawnCommand.generalMobcaps((class_2168)c.getSource()))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"cap (hostile)", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1400)).executes(c -> SpawnCommand.setMobcaps((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"cap (hostile)")))))).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(c -> SpawnCommand.mobcapsForDimension((class_2168)c.getSource(), class_2181.method_9289((CommandContext)c, (String)"dimension")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"entities").executes(c -> SpawnCommand.generalMobcaps((class_2168)c.getSource()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> class_2172.method_9264(Arrays.stream(class_1311.values()).map(class_1311::method_6133), (SuggestionsBuilder)b)).executes(c -> SpawnCommand.listEntitiesOfType((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"type"), false))).then(class_2170.method_9247((String)"all").executes(c -> SpawnCommand.listEntitiesOfType((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"type"), true)))));
        dispatcher.register(literalargumentbuilder);
    }

    private static class_1311 getCategory(String string) throws CommandSyntaxException {
        if (!Arrays.stream(class_1311.values()).map(class_1311::method_6133).collect(Collectors.toSet()).contains(string)) {
            throw new SimpleCommandExceptionType((Message)Messenger.c("r Wrong mob type: " + string + " should be " + Arrays.stream(class_1311.values()).map(class_1311::method_6133).collect(Collectors.joining(", ")))).create();
        }
        return MOB_CATEGORY_MAP.get(string.toLowerCase(Locale.ROOT));
    }

    private static int listSpawns(class_2168 source, class_2338 pos) {
        Messenger.send(source, SpawnReporter.report(pos, source.method_9225()));
        return 1;
    }

    private static int printTrackingReport(class_2168 source) {
        Messenger.send(source, SpawnReporter.tracking_report((class_1937)source.method_9225()));
        return 1;
    }

    private static int startTracking(class_2168 source, class_2338 a, class_2338 b) {
        if (SpawnReporter.track_spawns != 0L) {
            Messenger.m(source, "r You are already tracking spawning.");
            return 0;
        }
        class_2338 lsl = null;
        class_2338 usl = null;
        if (a != null && b != null) {
            lsl = new class_2338(Math.min(a.method_10263(), b.method_10263()), Math.min(a.method_10264(), b.method_10264()), Math.min(a.method_10260(), b.method_10260()));
            usl = new class_2338(Math.max(a.method_10263(), b.method_10263()), Math.max(a.method_10264(), b.method_10264()), Math.max(a.method_10260(), b.method_10260()));
        }
        SpawnReporter.reset_spawn_stats(source.method_9211(), false);
        SpawnReporter.track_spawns = source.method_9211().method_3780();
        SpawnReporter.lower_spawning_limit = lsl;
        SpawnReporter.upper_spawning_limit = usl;
        Messenger.m(source, "gi Spawning tracking started.");
        return 1;
    }

    private static int stopTracking(class_2168 source) {
        Messenger.send(source, SpawnReporter.tracking_report((class_1937)source.method_9225()));
        SpawnReporter.reset_spawn_stats(source.method_9211(), false);
        SpawnReporter.track_spawns = 0L;
        SpawnReporter.lower_spawning_limit = null;
        SpawnReporter.upper_spawning_limit = null;
        Messenger.m(source, "gi Spawning tracking stopped.");
        return 1;
    }

    private static int recentSpawnsForType(class_2168 source, String mob_type) throws CommandSyntaxException {
        class_1311 cat = SpawnCommand.getCategory(mob_type);
        Messenger.send(source, SpawnReporter.recent_spawns((class_1937)source.method_9225(), cat));
        return 1;
    }

    private static int runTest(class_2168 source, int ticks, String counter) {
        SpawnReporter.reset_spawn_stats(source.method_9211(), false);
        SpawnReporter.track_spawns = source.method_9211().method_3780();
        if (counter == null) {
            HopperCounter.resetAll(source.method_9211(), false);
        } else {
            HopperCounter hCounter = HopperCounter.getCounter(counter);
            if (hCounter != null) {
                hCounter.reset(source.method_9211());
            }
        }
        TickSpeed.tickrate_advance(null, 0, null, null);
        class_2168 csource = null;
        class_3222 player = null;
        try {
            player = source.method_9207();
            csource = source;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        TickSpeed.tickrate_advance(player, ticks, null, csource);
        Messenger.m(source, String.format("gi Started spawn test for %d ticks", ticks));
        return 1;
    }

    private static int toggleMocking(class_2168 source, boolean domock) {
        if (domock) {
            SpawnReporter.initialize_mocking();
            Messenger.m(source, "gi Mob spawns will now be mocked.");
        } else {
            SpawnReporter.stop_mocking();
            Messenger.m(source, "gi Normal mob spawning.");
        }
        return 1;
    }

    private static int generalMobcaps(class_2168 source) {
        Messenger.send(source, SpawnReporter.printMobcapsForDimension(source.method_9225(), true));
        return 1;
    }

    private static int resetSpawnRates(class_2168 source) {
        for (class_1311 s : SpawnReporter.spawn_tries.keySet()) {
            SpawnReporter.spawn_tries.put(s, 1);
        }
        Messenger.m(source, "gi Spawn rates brought to 1 round per tick for all groups.");
        return 1;
    }

    private static int setSpawnRates(class_2168 source, String mobtype, int rounds) throws CommandSyntaxException {
        class_1311 cat = SpawnCommand.getCategory(mobtype);
        SpawnReporter.spawn_tries.put(cat, rounds);
        Messenger.m(source, "gi " + mobtype + " mobs will now spawn " + rounds + " times per tick");
        return 1;
    }

    private static int setMobcaps(class_2168 source, int hostile_cap) {
        double desired_ratio = (double)hostile_cap / (double)((SpawnGroupInterface)class_1311.field_6302).getInitialSpawnCap();
        SpawnReporter.mobcap_exponent = 4.0 * Math.log(desired_ratio) / Math.log(2.0);
        Messenger.m(source, String.format("gi Mobcaps for hostile mobs changed to %d, other groups will follow", hostile_cap));
        return 1;
    }

    private static int mobcapsForDimension(class_2168 source, class_3218 world) {
        Messenger.send(source, SpawnReporter.printMobcapsForDimension(world, true));
        return 1;
    }

    private static int listEntitiesOfType(class_2168 source, String mobtype, boolean all) throws CommandSyntaxException {
        class_1311 cat = SpawnCommand.getCategory(mobtype);
        Messenger.send(source, SpawnReporter.printEntitiesByType(cat, (class_1937)source.method_9225(), all));
        return 1;
    }
}

