/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.fakes.ServerPlayerEntityInterface;
import carpet.helpers.EntityPlayerActionPack;
import carpet.patches.EntityPlayerMPFake;
import carpet.settings.SettingsManager;
import carpet.utils.Messenger;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2270;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class PlayerCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        String[] gamemodeStrings = (String[])Arrays.stream(class_1934.values()).map(class_1934::method_8381).toArray(String[]::new);
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"player").requires(player -> SettingsManager.canUseCommand(player, CarpetSettings.commandPlayer))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9265(PlayerCommand.getPlayers((class_2168)c.getSource()), (SuggestionsBuilder)b)).then(class_2170.method_9247((String)"stop").executes(PlayerCommand::stop))).then(PlayerCommand.makeActionCommand("use", EntityPlayerActionPack.ActionType.USE))).then(PlayerCommand.makeActionCommand("jump", EntityPlayerActionPack.ActionType.JUMP))).then(PlayerCommand.makeActionCommand("attack", EntityPlayerActionPack.ActionType.ATTACK))).then(PlayerCommand.makeActionCommand("drop", EntityPlayerActionPack.ActionType.DROP_ITEM))).then(PlayerCommand.makeDropCommand("drop", false))).then(PlayerCommand.makeActionCommand("dropStack", EntityPlayerActionPack.ActionType.DROP_STACK))).then(PlayerCommand.makeDropCommand("dropStack", true))).then(PlayerCommand.makeActionCommand("swapHands", EntityPlayerActionPack.ActionType.SWAP_HANDS))).then(class_2170.method_9247((String)"hotbar").then(class_2170.method_9244((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)9)).executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.setSlot(IntegerArgumentType.getInteger((CommandContext)c, (String)"slot"))))))).then(class_2170.method_9247((String)"kill").executes(PlayerCommand::kill))).then(class_2170.method_9247((String)"shadow").executes(PlayerCommand::shadow))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"mount").executes(PlayerCommand.manipulation(ap -> ap.mount(true)))).then(class_2170.method_9247((String)"anything").executes(PlayerCommand.manipulation(ap -> ap.mount(false)))))).then(class_2170.method_9247((String)"dismount").executes(PlayerCommand.manipulation(EntityPlayerActionPack::dismount)))).then(class_2170.method_9247((String)"sneak").executes(PlayerCommand.manipulation(ap -> ap.setSneaking(true))))).then(class_2170.method_9247((String)"unsneak").executes(PlayerCommand.manipulation(ap -> ap.setSneaking(false))))).then(class_2170.method_9247((String)"sprint").executes(PlayerCommand.manipulation(ap -> ap.setSprinting(true))))).then(class_2170.method_9247((String)"unsprint").executes(PlayerCommand.manipulation(ap -> ap.setSprinting(false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"look").then(class_2170.method_9247((String)"north").executes(PlayerCommand.manipulation(ap -> ap.look(class_2350.field_11043))))).then(class_2170.method_9247((String)"south").executes(PlayerCommand.manipulation(ap -> ap.look(class_2350.field_11035))))).then(class_2170.method_9247((String)"east").executes(PlayerCommand.manipulation(ap -> ap.look(class_2350.field_11034))))).then(class_2170.method_9247((String)"west").executes(PlayerCommand.manipulation(ap -> ap.look(class_2350.field_11039))))).then(class_2170.method_9247((String)"up").executes(PlayerCommand.manipulation(ap -> ap.look(class_2350.field_11036))))).then(class_2170.method_9247((String)"down").executes(PlayerCommand.manipulation(ap -> ap.look(class_2350.field_11033))))).then(class_2170.method_9247((String)"at").then(class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9737()).executes(PlayerCommand::lookAt)))).then(class_2170.method_9244((String)"direction", (ArgumentType)class_2270.method_9717()).executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.look(class_2270.method_9716((CommandContext)c, (String)"direction").method_9709((class_2168)c.getSource()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"turn").then(class_2170.method_9247((String)"left").executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.turn(-90.0f, 0.0f))))).then(class_2170.method_9247((String)"right").executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.turn(90.0f, 0.0f))))).then(class_2170.method_9247((String)"back").executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.turn(180.0f, 0.0f))))).then(class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.turn(class_2270.method_9716((CommandContext)c, (String)"rotation").method_9709((class_2168)c.getSource()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"move").executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, EntityPlayerActionPack::stopMovement))).then(class_2170.method_9247((String)"forward").executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.setForward(1.0f))))).then(class_2170.method_9247((String)"backward").executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.setForward(-1.0f))))).then(class_2170.method_9247((String)"left").executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.setStrafing(1.0f))))).then(class_2170.method_9247((String)"right").executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.setStrafing(-1.0f)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").executes(PlayerCommand::spawn)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"in").requires(player -> player.method_9259(2))).then(class_2170.method_9244((String)"gamemode", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9253((String[])gamemodeStrings, (SuggestionsBuilder)b)).executes(PlayerCommand::spawn)))).then(class_2170.method_9247((String)"at").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9737()).executes(PlayerCommand::spawn)).then(class_2170.method_9247((String)"facing").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"direction", (ArgumentType)class_2270.method_9717()).executes(PlayerCommand::spawn)).then(class_2170.method_9247((String)"in").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(PlayerCommand::spawn)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"in").requires(player -> player.method_9259(2))).then(class_2170.method_9244((String)"gamemode", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9253((String[])gamemodeStrings, (SuggestionsBuilder)b)).executes(PlayerCommand::spawn)))))))))));
        dispatcher.register(literalargumentbuilder);
    }

    private static LiteralArgumentBuilder<class_2168> makeActionCommand(String actionName, EntityPlayerActionPack.ActionType type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)actionName).executes(c -> PlayerCommand.action((CommandContext<class_2168>)c, type, EntityPlayerActionPack.Action.once()))).then(class_2170.method_9247((String)"once").executes(c -> PlayerCommand.action((CommandContext<class_2168>)c, type, EntityPlayerActionPack.Action.once())))).then(class_2170.method_9247((String)"continuous").executes(c -> PlayerCommand.action((CommandContext<class_2168>)c, type, EntityPlayerActionPack.Action.continuous())))).then(class_2170.method_9247((String)"interval").then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> PlayerCommand.action((CommandContext<class_2168>)c, type, EntityPlayerActionPack.Action.interval(IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"))))));
    }

    private static LiteralArgumentBuilder<class_2168> makeDropCommand(String actionName, boolean dropAll) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)actionName).then(class_2170.method_9247((String)"all").executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.drop(-2, dropAll))))).then(class_2170.method_9247((String)"mainhand").executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.drop(-1, dropAll))))).then(class_2170.method_9247((String)"offhand").executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.drop(40, dropAll))))).then(class_2170.method_9244((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)0, (int)40)).executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.drop(IntegerArgumentType.getInteger((CommandContext)c, (String)"slot"), dropAll))));
    }

    private static Collection<String> getPlayers(class_2168 source) {
        LinkedHashSet<String> players = new LinkedHashSet<String>(List.of("Steve", "Alex"));
        players.addAll(source.method_9262());
        return players;
    }

    private static class_3222 getPlayer(CommandContext<class_2168> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        return server.method_3760().method_14566(playerName);
    }

    private static boolean cantManipulate(CommandContext<class_2168> context) {
        class_3222 sendingPlayer;
        class_3222 player = PlayerCommand.getPlayer(context);
        if (player == null) {
            Messenger.m((class_2168)context.getSource(), "r Can only manipulate existing players");
            return true;
        }
        try {
            sendingPlayer = ((class_2168)context.getSource()).method_9207();
        }
        catch (CommandSyntaxException e) {
            return false;
        }
        if (!((class_2168)context.getSource()).method_9211().method_3760().method_14569(sendingPlayer.method_7334()) && sendingPlayer != player && !(player instanceof EntityPlayerMPFake)) {
            Messenger.m((class_2168)context.getSource(), "r Non OP players can't control other real players");
            return true;
        }
        return false;
    }

    private static boolean cantReMove(CommandContext<class_2168> context) {
        if (PlayerCommand.cantManipulate(context)) {
            return true;
        }
        class_3222 player = PlayerCommand.getPlayer(context);
        if (player instanceof EntityPlayerMPFake) {
            return false;
        }
        Messenger.m((class_2168)context.getSource(), "r Only fake players can be moved or killed");
        return true;
    }

    private static boolean cantSpawn(CommandContext<class_2168> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_3324 manager = server.method_3760();
        class_3222 player = manager.method_14566(playerName);
        if (player != null) {
            Messenger.m((class_2168)context.getSource(), "r Player ", "rb " + playerName, "r  is already logged on");
            return true;
        }
        GameProfile profile = server.method_3793().method_14515(playerName).orElse(null);
        if (profile == null) {
            if (!CarpetSettings.allowSpawningOfflinePlayers) {
                Messenger.m((class_2168)context.getSource(), "r Player " + playerName + " is either banned by Mojang, or auth servers are down. Banned players can only be summoned in Singleplayer and in servers in off-line mode.");
                return true;
            }
            profile = new GameProfile(class_4844.method_43344((String)playerName), playerName);
        }
        if (manager.method_14563().method_14650(profile)) {
            Messenger.m((class_2168)context.getSource(), "r Player ", "rb " + playerName, "r  is banned on this server");
            return true;
        }
        if (manager.method_14614() && manager.method_14587(profile) && !((class_2168)context.getSource()).method_9259(2)) {
            Messenger.m((class_2168)context.getSource(), "r Whitelisted players can only be spawned by operators");
            return true;
        }
        return false;
    }

    private static int kill(CommandContext<class_2168> context) {
        if (PlayerCommand.cantReMove(context)) {
            return 0;
        }
        PlayerCommand.getPlayer(context).method_5768();
        return 1;
    }

    private static int lookAt(CommandContext<class_2168> context) {
        return PlayerCommand.manipulate(context, ap -> ap.lookAt(class_2277.method_9736((CommandContext)context, (String)"position")));
    }

    private static <T> T tryGetArg(SupplierWithCommandSyntaxException<T> a, SupplierWithCommandSyntaxException<T> b) throws CommandSyntaxException {
        try {
            return a.get();
        }
        catch (IllegalArgumentException e) {
            return b.get();
        }
    }

    private static int spawn(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (PlayerCommand.cantSpawn(context)) {
            return 0;
        }
        class_2168 source = (class_2168)context.getSource();
        class_243 pos = PlayerCommand.tryGetArg(() -> class_2277.method_9736((CommandContext)context, (String)"position"), () -> ((class_2168)source).method_9222());
        class_241 facing = PlayerCommand.tryGetArg(() -> class_2270.method_9716((CommandContext)context, (String)"direction").method_9709((class_2168)context.getSource()), () -> ((class_2168)source).method_9210());
        class_5321 dimType = PlayerCommand.tryGetArg(() -> class_2181.method_9289((CommandContext)context, (String)"dimension").method_27983(), () -> source.method_9225().method_27983());
        class_1934 mode = class_1934.field_9220;
        boolean flying = false;
        try {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            mode = player.field_13974.method_14257();
            flying = player.method_31549().field_7479;
        }
        catch (CommandSyntaxException player) {
            // empty catch block
        }
        try {
            String opGameMode = StringArgumentType.getString(context, (String)"gamemode");
            mode = class_1934.method_8378((String)opGameMode, null);
            if (mode == null) {
                Messenger.m((class_2168)context.getSource(), "rb Invalid game mode: " + opGameMode + ".");
                return 0;
            }
        }
        catch (IllegalArgumentException opGameMode) {
            // empty catch block
        }
        if (mode == class_1934.field_9219) {
            flying = true;
        } else if (mode.method_8388()) {
            flying = false;
        }
        String playerName = StringArgumentType.getString(context, (String)"player");
        if (playerName.length() > PlayerCommand.maxPlayerLength(source.method_9211())) {
            Messenger.m((class_2168)context.getSource(), "rb Player name: " + playerName + " is too long");
            return 0;
        }
        MinecraftServer server = source.method_9211();
        if (!class_1937.method_25953((class_2338)new class_2338(pos.field_1352, pos.field_1351, pos.field_1350))) {
            Messenger.m((class_2168)context.getSource(), "rb Player " + playerName + " cannot be placed outside of the world");
            return 0;
        }
        EntityPlayerMPFake player = EntityPlayerMPFake.createFake(playerName, server, pos.field_1352, pos.field_1351, pos.field_1350, facing.field_1342, facing.field_1343, (class_5321<class_1937>)dimType, mode, flying);
        if (player == null) {
            Messenger.m((class_2168)context.getSource(), "rb Player " + StringArgumentType.getString(context, (String)"player") + " doesn't exist and cannot spawn in online mode. Turn the server offline to spawn non-existing players");
            return 0;
        }
        return 1;
    }

    private static int maxPlayerLength(MinecraftServer server) {
        return server.method_3756() >= 0 ? 16 : 40;
    }

    private static int stop(CommandContext<class_2168> context) {
        if (PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        class_3222 player = PlayerCommand.getPlayer(context);
        ((ServerPlayerEntityInterface)player).getActionPack().stopAll();
        return 1;
    }

    private static int manipulate(CommandContext<class_2168> context, Consumer<EntityPlayerActionPack> action) {
        if (PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        class_3222 player = PlayerCommand.getPlayer(context);
        action.accept(((ServerPlayerEntityInterface)player).getActionPack());
        return 1;
    }

    private static Command<class_2168> manipulation(Consumer<EntityPlayerActionPack> action) {
        return c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, action);
    }

    private static int action(CommandContext<class_2168> context, EntityPlayerActionPack.ActionType type, EntityPlayerActionPack.Action action) {
        return PlayerCommand.manipulate(context, ap -> ap.start(type, action));
    }

    private static int shadow(CommandContext<class_2168> context) {
        class_3222 player = PlayerCommand.getPlayer(context);
        if (player instanceof EntityPlayerMPFake) {
            Messenger.m((class_2168)context.getSource(), "r Cannot shadow fake players");
            return 0;
        }
        class_3222 sendingPlayer = null;
        try {
            sendingPlayer = ((class_2168)context.getSource()).method_9207();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (sendingPlayer != player && PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        EntityPlayerMPFake.createShadow(player.field_13995, player);
        return 1;
    }

    @FunctionalInterface
    static interface SupplierWithCommandSyntaxException<T> {
        public T get() throws CommandSyntaxException;
    }
}

