/*
 * Decompiled with CFR 0.152.
 */
package carpet;

import carpet.CarpetExtension;
import carpet.CarpetSettings;
import carpet.commands.CounterCommand;
import carpet.commands.DistanceCommand;
import carpet.commands.DrawCommand;
import carpet.commands.InfoCommand;
import carpet.commands.LogCommand;
import carpet.commands.MobAICommand;
import carpet.commands.PerimeterInfoCommand;
import carpet.commands.PlayerCommand;
import carpet.commands.ProfileCommand;
import carpet.commands.ScriptCommand;
import carpet.commands.SpawnCommand;
import carpet.commands.TestCommand;
import carpet.commands.TickCommand;
import carpet.helpers.HopperCounter;
import carpet.helpers.TickSpeed;
import carpet.logging.HUDController;
import carpet.logging.LoggerRegistry;
import carpet.network.ServerNetworkHandler;
import carpet.script.CarpetScriptServer;
import carpet.settings.SettingsManager;
import carpet.utils.FabricAPIHooks;
import carpet.utils.MobAI;
import carpet.utils.SpawnReporter;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.class_6413;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class CarpetServer {
    public static final Random rand = new Random();
    public static MinecraftServer minecraft_server;
    private static CommandDispatcher<class_2168> currentCommandDispatcher;
    public static CarpetScriptServer scriptServer;
    public static SettingsManager settingsManager;
    public static final List<CarpetExtension> extensions;

    public static void manageExtension(CarpetExtension extension) {
        extensions.add(extension);
        if (StackWalker.getInstance().walk(stream -> stream.anyMatch(el -> el.getClassName() == CarpetServer.class.getName() && !el.getMethodName().equals("manageExtension"))).booleanValue()) {
            CarpetSettings.LOG.warn("Extension '%s' is registering itself using a mixin into Carpet instead of a regular ModInitializer!\nThis is stupid and will crash the game in future versions!".formatted(extension.getClass().getSimpleName()));
        }
        if (currentCommandDispatcher != null) {
            throw new IllegalStateException("Extension %s tried to register too late!".formatted(extension.getClass().getSimpleName()));
        }
    }

    public static void onGameStarted() {
        settingsManager = new SettingsManager("1.4.79+v220607", "carpet", "Carpet Mod");
        settingsManager.parseSettingsClass(CarpetSettings.class);
        extensions.forEach(CarpetExtension::onGameStarted);
        FabricAPIHooks.initialize();
        CarpetScriptServer.parseFunctionClasses();
    }

    public static void onServerLoaded(MinecraftServer server) {
        minecraft_server = server;
        SpawnReporter.reset_spawn_stats(server, true);
        settingsManager.attachServer(server);
        extensions.forEach(e -> {
            SettingsManager sm = e.customSettingsManager();
            if (sm != null) {
                sm.attachServer(server);
            }
            e.onServerLoaded(server);
        });
        scriptServer = new CarpetScriptServer(server);
        MobAI.resetTrackers();
        LoggerRegistry.initLoggers();
    }

    public static void onServerLoadedWorlds(MinecraftServer minecraftServer) {
        HopperCounter.resetAll(minecraftServer, true);
        extensions.forEach(e -> e.onServerLoadedWorlds(minecraftServer));
        scriptServer.initializeForWorld();
    }

    public static void tick(MinecraftServer server) {
        TickSpeed.tick();
        HUDController.update_hud(server, null);
        if (scriptServer != null) {
            scriptServer.tick();
        }
        CarpetSettings.impendingFillSkipUpdates.set(false);
        extensions.forEach(e -> e.onTick(server));
    }

    public static void registerCarpetCommands(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment, class_7157 commandBuildContext) {
        if (settingsManager == null) {
            return;
        }
        settingsManager.registerCommand(dispatcher, commandBuildContext);
        extensions.forEach(e -> {
            SettingsManager sm = e.customSettingsManager();
            if (sm != null) {
                sm.registerCommand(dispatcher, commandBuildContext);
            }
        });
        TickCommand.register(dispatcher, commandBuildContext);
        ProfileCommand.register(dispatcher, commandBuildContext);
        CounterCommand.register(dispatcher, commandBuildContext);
        LogCommand.register(dispatcher, commandBuildContext);
        SpawnCommand.register(dispatcher, commandBuildContext);
        PlayerCommand.register(dispatcher, commandBuildContext);
        InfoCommand.register(dispatcher, commandBuildContext);
        DistanceCommand.register(dispatcher, commandBuildContext);
        PerimeterInfoCommand.register(dispatcher, commandBuildContext);
        DrawCommand.register(dispatcher, commandBuildContext);
        ScriptCommand.register(dispatcher, commandBuildContext);
        MobAICommand.register(dispatcher, commandBuildContext);
        extensions.forEach(e -> e.registerCommands(dispatcher, commandBuildContext));
        currentCommandDispatcher = dispatcher;
        if (environment != class_2170.class_5364.field_25420) {
            class_6413.method_37331(dispatcher);
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            TestCommand.register(dispatcher);
        }
    }

    public static void onPlayerLoggedIn(class_3222 player) {
        ServerNetworkHandler.onPlayerJoin(player);
        LoggerRegistry.playerConnected((class_1657)player);
        scriptServer.onPlayerJoin(player);
        extensions.forEach(e -> e.onPlayerLoggedIn(player));
    }

    public static void onPlayerLoggedOut(class_3222 player) {
        ServerNetworkHandler.onPlayerLoggedOut(player);
        LoggerRegistry.playerDisconnected((class_1657)player);
        extensions.forEach(e -> e.onPlayerLoggedOut(player));
    }

    public static void clientPreClosing() {
        if (scriptServer != null) {
            scriptServer.onClose();
        }
        scriptServer = null;
    }

    public static void onServerClosed(MinecraftServer server) {
        if (minecraft_server != null) {
            if (scriptServer != null) {
                scriptServer.onClose();
            }
            scriptServer = null;
            ServerNetworkHandler.close();
            currentCommandDispatcher = null;
            LoggerRegistry.stopLoggers();
            HUDController.resetScarpetHUDs();
            extensions.forEach(e -> e.onServerClosed(server));
            minecraft_server = null;
        }
        TickSpeed.reset();
    }

    public static void onServerDoneClosing(MinecraftServer server) {
        settingsManager.detachServer();
    }

    public static void registerExtensionLoggers() {
        extensions.forEach(CarpetExtension::registerLoggers);
    }

    public static void onReload(MinecraftServer server) {
        scriptServer.reload(server);
        extensions.forEach(e -> e.onReload(server));
    }

    static {
        extensions = new ArrayList<CarpetExtension>();
    }
}

