/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.class_2338;

public class SyncmaticaUtil {
    static final int[] ILLEGAL_CHARS = new int[]{34, 60, 62, 124, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 58, 42, 63, 92, 47};
    static final String ILLEGAL_PATTERNS = "(^(con|prn|aux|nul|com[0-9]|lpt[0-9])(\\..*)?$)|(^\\.\\.*$)";

    private SyncmaticaUtil() {
    }

    public static UUID createChecksum(InputStream fis) throws NoSuchAlgorithmException, IOException {
        int numRead;
        byte[] buffer = new byte[4096];
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = fis.read(buffer)) <= 0) continue;
            messageDigest.update(buffer, 0, numRead);
        } while (numRead != -1);
        fis.close();
        return UUID.nameUUIDFromBytes(messageDigest.digest());
    }

    public static String sanitizeFileName(String badFileName) {
        StringBuilder sanitized = new StringBuilder();
        int len = badFileName.codePointCount(0, badFileName.length());
        for (int i = 0; i < len; ++i) {
            int c = badFileName.codePointAt(i);
            if (Arrays.binarySearch(ILLEGAL_CHARS, c) >= 0) continue;
            sanitized.appendCodePoint(c);
            if (sanitized.length() == 255) break;
        }
        return sanitized.toString().replaceAll(ILLEGAL_PATTERNS, "_");
    }

    public static double getBlockDistanceSquared(class_2338 a, double x, double y, double z) {
        double combinedX = (double)a.method_10263() - x;
        double combinedY = (double)a.method_10264() - y;
        double combinedZ = (double)a.method_10260() - z;
        return combinedX * combinedX + combinedY * combinedY + combinedZ * combinedZ;
    }

    static {
        Arrays.sort(ILLEGAL_CHARS);
    }
}

