/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.mixin;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.FileStorage;
import ch.endte.syncmatica.SyncmaticManager;
import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.communication.ServerCommunicationManager;
import java.util.function.Function;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public class MixinMinecraftServer {
    @Inject(method={"startServer"}, at={@At(value="TAIL")})
    private static <S extends MinecraftServer> void initSyncmatica(Function<Thread, S> serverFactory, CallbackInfoReturnable<S> ci) {
        FileStorage data = new FileStorage();
        SyncmaticManager man = new SyncmaticManager();
        ServerCommunicationManager comms = new ServerCommunicationManager();
        Syncmatica.initServer(comms, data, man);
        Context con = Syncmatica.getContext(Syncmatica.SERVER_CONTEXT);
        con.startup();
    }

    @Inject(method={"shutdown"}, at={@At(value="TAIL")})
    public void shutdownSyncmatica(CallbackInfo ci) {
        Context con = Syncmatica.getContext(Syncmatica.SERVER_CONTEXT);
        con.shutdown();
    }
}

