/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.litematica.gui;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Feature;
import ch.endte.syncmatica.communication.ClientCommunicationManager;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.exchange.ShareLitematicExchange;
import ch.endte.syncmatica.litematica.LitematicManager;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;

public class ButtonListenerShare
implements IButtonActionListener {
    private final SchematicPlacement schematicPlacement;
    private final GuiBase messageDisplay;

    public ButtonListenerShare(SchematicPlacement placement, GuiBase messageDisplay) {
        this.schematicPlacement = placement;
        this.messageDisplay = messageDisplay;
    }

    public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
        if (LitematicManager.getInstance().isSyncmatic(this.schematicPlacement)) {
            return;
        }
        if (!GuiBase.isShiftDown()) {
            this.messageDisplay.addMessage(Message.MessageType.ERROR, "syncmatica.error.share_without_shift", new Object[0]);
            return;
        }
        button.setEnabled(false);
        Context con = LitematicManager.getInstance().getActiveContext();
        ExchangeTarget server = ((ClientCommunicationManager)con.getCommunicationManager()).getServer();
        if (!server.getFeatureSet().hasFeature(Feature.CORE_EX) && this.schematicPlacement.isRegionPlacementModified()) {
            this.messageDisplay.addMessage(Message.MessageType.ERROR, "syncmatica.error.share_modified_subregions", new Object[0]);
            return;
        }
        ShareLitematicExchange ex = new ShareLitematicExchange(this.schematicPlacement, server, con);
        con.getCommunicationManager().startExchange(ex);
    }
}

