/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication.exchange;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.ServerPlacement;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.FeatureSet;
import ch.endte.syncmatica.communication.PacketType;
import ch.endte.syncmatica.communication.exchange.FeatureExchange;
import ch.endte.syncmatica.litematica.LitematicManager;
import io.netty.buffer.Unpooled;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;

public class VersionHandshakeClient
extends FeatureExchange {
    private String partnerVersion;

    public VersionHandshakeClient(ExchangeTarget partner, Context con) {
        super(partner, con);
    }

    @Override
    public boolean checkPacket(class_2960 id, class_2540 packetBuf) {
        return id.equals((Object)PacketType.CONFIRM_USER.identifier) || id.equals((Object)PacketType.REGISTER_VERSION.identifier) || super.checkPacket(id, packetBuf);
    }

    @Override
    public void handle(class_2960 id, class_2540 packetBuf) {
        if (id.equals((Object)PacketType.REGISTER_VERSION.identifier)) {
            String version = packetBuf.method_10800(Short.MAX_VALUE);
            if (!this.getContext().checkPartnerVersion(version)) {
                LogManager.getLogger(VersionHandshakeClient.class).info("Denying syncmatica join due to outdated server with local version {} and server version {}", (Object)"0.3.2", (Object)version);
                this.close(false);
            } else {
                this.partnerVersion = version;
                FeatureSet fs = FeatureSet.fromVersionString(version);
                if (fs == null) {
                    this.requestFeatureSet();
                } else {
                    this.getPartner().setFeatureSet(fs);
                    this.onFeatureSetReceive();
                }
            }
        } else if (id.equals((Object)PacketType.CONFIRM_USER.identifier)) {
            int placementCount = packetBuf.readInt();
            for (int i = 0; i < placementCount; ++i) {
                ServerPlacement p = this.getManager().receiveMetaData(packetBuf, this.getPartner());
                this.getContext().getSyncmaticManager().addPlacement(p);
            }
            LogManager.getLogger(VersionHandshakeClient.class).info("Joining syncmatica server with local version {} and server version {}", (Object)"0.3.2", (Object)this.partnerVersion);
            LitematicManager.getInstance().commitLoad();
            this.getContext().startup();
            this.succeed();
        } else {
            super.handle(id, packetBuf);
        }
    }

    @Override
    public void onFeatureSetReceive() {
        class_2540 newBuf = new class_2540(Unpooled.buffer());
        newBuf.method_10814("0.3.2");
        this.getPartner().sendPacket(PacketType.REGISTER_VERSION.identifier, newBuf, this.getContext());
    }

    @Override
    public void init() {
    }
}

