/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication.exchange;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.ServerPlacement;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.PacketType;
import ch.endte.syncmatica.communication.exchange.AbstractExchange;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class UploadExchange
extends AbstractExchange {
    private static final int BUFFER_SIZE = 16384;
    private final ServerPlacement toUpload;
    private final InputStream inputStream;
    private final byte[] buffer = new byte[16384];

    public UploadExchange(ServerPlacement syncmatic, File uploadFile, ExchangeTarget partner, Context con) throws FileNotFoundException {
        super(partner, con);
        this.toUpload = syncmatic;
        this.inputStream = new FileInputStream(uploadFile);
    }

    @Override
    public boolean checkPacket(class_2960 id, class_2540 packetBuf) {
        if (id.equals((Object)PacketType.RECEIVED_LITEMATIC.identifier) || id.equals((Object)PacketType.CANCEL_LITEMATIC.identifier)) {
            return UploadExchange.checkUUID(packetBuf, this.toUpload.getId());
        }
        return false;
    }

    @Override
    public void handle(class_2960 id, class_2540 packetBuf) {
        packetBuf.method_10790();
        if (id.equals((Object)PacketType.RECEIVED_LITEMATIC.identifier)) {
            this.send();
        }
        if (id.equals((Object)PacketType.CANCEL_LITEMATIC.identifier)) {
            this.close(false);
        }
    }

    private void send() {
        int bytesRead;
        try {
            bytesRead = this.inputStream.read(this.buffer);
        }
        catch (IOException e) {
            this.close(true);
            e.printStackTrace();
            return;
        }
        if (bytesRead == -1) {
            this.sendFinish();
        } else {
            this.sendData(bytesRead);
        }
    }

    private void sendData(int bytesRead) {
        class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
        packetByteBuf.method_10797(this.toUpload.getId());
        packetByteBuf.writeInt(bytesRead);
        packetByteBuf.writeBytes(this.buffer, 0, bytesRead);
        this.getPartner().sendPacket(PacketType.SEND_LITEMATIC.identifier, packetByteBuf, this.getContext());
    }

    private void sendFinish() {
        class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
        packetByteBuf.method_10797(this.toUpload.getId());
        this.getPartner().sendPacket(PacketType.FINISHED_LITEMATIC.identifier, packetByteBuf, this.getContext());
        this.succeed();
    }

    @Override
    public void init() {
        this.send();
    }

    @Override
    protected void onClose() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void sendCancelPacket() {
        class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
        packetByteBuf.method_10797(this.toUpload.getId());
        this.getPartner().sendPacket(PacketType.CANCEL_LITEMATIC.identifier, packetByteBuf, this.getContext());
    }
}

