/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication.exchange;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.communication.CommunicationManager;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.exchange.Exchange;
import java.util.UUID;
import net.minecraft.class_2540;

public abstract class AbstractExchange
implements Exchange {
    private boolean success = false;
    private boolean finished = false;
    private final ExchangeTarget partner;
    private final Context context;

    protected AbstractExchange(ExchangeTarget partner, Context con) {
        this.partner = partner;
        this.context = con;
    }

    @Override
    public ExchangeTarget getPartner() {
        return this.partner;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean isSuccessful() {
        return this.success;
    }

    @Override
    public void close(boolean notifyPartner) {
        this.finished = true;
        this.success = false;
        this.onClose();
        if (notifyPartner) {
            this.sendCancelPacket();
        }
    }

    public CommunicationManager getManager() {
        return this.context.getCommunicationManager();
    }

    protected void sendCancelPacket() {
    }

    protected void onClose() {
    }

    protected void succeed() {
        this.finished = true;
        this.success = true;
        this.onClose();
    }

    protected static boolean checkUUID(class_2540 sourceBuf, UUID targetId) {
        int r = sourceBuf.readerIndex();
        UUID sourceId = sourceBuf.method_10790();
        sourceBuf.readerIndex(r);
        return sourceId.equals(targetId);
    }
}

