/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Feature;
import ch.endte.syncmatica.ServerPlacement;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.PacketType;
import ch.endte.syncmatica.communication.exchange.DownloadExchange;
import ch.endte.syncmatica.communication.exchange.Exchange;
import ch.endte.syncmatica.extended_core.PlayerIdentifier;
import ch.endte.syncmatica.extended_core.PlayerIdentifierProvider;
import ch.endte.syncmatica.extended_core.SubRegionData;
import ch.endte.syncmatica.extended_core.SubRegionPlacementModification;
import ch.endte.syncmatica.util.SyncmaticaUtil;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public abstract class CommunicationManager {
    protected final Collection<ExchangeTarget> broadcastTargets = new ArrayList<ExchangeTarget>();
    protected final Map<UUID, Boolean> downloadState = new HashMap<UUID, Boolean>();
    protected final Map<UUID, Exchange> modifyState = new HashMap<UUID, Exchange>();
    protected Context context;
    protected static final class_2470[] rotOrdinals = class_2470.values();
    protected static final class_2415[] mirOrdinals = class_2415.values();

    protected CommunicationManager() {
    }

    public boolean handlePacket(class_2960 id) {
        return PacketType.containsIdentifier(id);
    }

    public void onPacket(ExchangeTarget source, class_2960 id, class_2540 packetBuf) {
        this.context.getDebugService().logReceivePacket(id);
        Exchange handler = null;
        Collection<Exchange> potentialMessageTarget = source.getExchanges();
        if (potentialMessageTarget != null) {
            for (Exchange target : potentialMessageTarget) {
                if (!target.checkPacket(id, packetBuf)) continue;
                target.handle(id, packetBuf);
                handler = target;
                break;
            }
        }
        if (handler == null) {
            this.handle(source, id, packetBuf);
        } else if (handler.isFinished()) {
            this.notifyClose(handler);
        }
    }

    protected abstract void handle(ExchangeTarget var1, class_2960 var2, class_2540 var3);

    protected abstract void handleExchange(Exchange var1);

    public void sendMetaData(ServerPlacement metaData, ExchangeTarget target) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.putMetaData(metaData, buf, target);
        target.sendPacket(PacketType.REGISTER_METADATA.identifier, buf, this.context);
    }

    public void putMetaData(ServerPlacement metaData, class_2540 buf, ExchangeTarget exchangeTarget) {
        buf.method_10797(metaData.getId());
        buf.method_10814(SyncmaticaUtil.sanitizeFileName(metaData.getName()));
        buf.method_10797(metaData.getHash());
        if (exchangeTarget.getFeatureSet().hasFeature(Feature.CORE_EX)) {
            buf.method_10797(metaData.getOwner().uuid);
            buf.method_10814(metaData.getOwner().getName());
            buf.method_10797(metaData.getLastModifiedBy().uuid);
            buf.method_10814(metaData.getLastModifiedBy().getName());
        }
        this.putPositionData(metaData, buf, exchangeTarget);
    }

    public void putPositionData(ServerPlacement metaData, class_2540 buf, ExchangeTarget exchangeTarget) {
        buf.method_10807(metaData.getPosition());
        buf.method_10814(metaData.getDimension());
        buf.writeInt(metaData.getRotation().ordinal());
        buf.writeInt(metaData.getMirror().ordinal());
        if (exchangeTarget.getFeatureSet().hasFeature(Feature.CORE_EX)) {
            if (metaData.getSubRegionData().getModificationData() == null) {
                buf.writeInt(0);
                return;
            }
            Collection<SubRegionPlacementModification> regionData = metaData.getSubRegionData().getModificationData().values();
            buf.writeInt(regionData.size());
            for (SubRegionPlacementModification subPlacement : regionData) {
                buf.method_10814(subPlacement.name);
                buf.method_10807(subPlacement.position);
                buf.writeInt(subPlacement.rotation.ordinal());
                buf.writeInt(subPlacement.mirror.ordinal());
            }
        }
    }

    public ServerPlacement receiveMetaData(class_2540 buf, ExchangeTarget exchangeTarget) {
        UUID id = buf.method_10790();
        String fileName = SyncmaticaUtil.sanitizeFileName(buf.method_10800(Short.MAX_VALUE));
        UUID hash = buf.method_10790();
        PlayerIdentifier owner = PlayerIdentifier.MISSING_PLAYER;
        PlayerIdentifier lastModifiedBy = PlayerIdentifier.MISSING_PLAYER;
        if (exchangeTarget.getFeatureSet().hasFeature(Feature.CORE_EX)) {
            PlayerIdentifierProvider provider = this.context.getPlayerIdentifierProvider();
            owner = provider.createOrGet(buf.method_10790(), buf.method_10800(Short.MAX_VALUE));
            lastModifiedBy = provider.createOrGet(buf.method_10790(), buf.method_10800(Short.MAX_VALUE));
        }
        ServerPlacement placement = new ServerPlacement(id, fileName, hash, owner);
        placement.setLastModifiedBy(lastModifiedBy);
        this.receivePositionData(placement, buf, exchangeTarget);
        return placement;
    }

    public void receivePositionData(ServerPlacement placement, class_2540 buf, ExchangeTarget exchangeTarget) {
        class_2338 pos = buf.method_10811();
        String dimensionId = buf.method_10800(Short.MAX_VALUE);
        class_2470 rot = rotOrdinals[buf.readInt()];
        class_2415 mir = mirOrdinals[buf.readInt()];
        placement.move(dimensionId, pos, rot, mir);
        if (exchangeTarget.getFeatureSet().hasFeature(Feature.CORE_EX)) {
            SubRegionData subRegionData = placement.getSubRegionData();
            subRegionData.reset();
            int limit = buf.readInt();
            for (int i = 0; i < limit; ++i) {
                subRegionData.modify(buf.method_10800(Short.MAX_VALUE), buf.method_10811(), rotOrdinals[buf.readInt()], mirOrdinals[buf.readInt()]);
            }
        }
    }

    public void download(ServerPlacement syncmatic, ExchangeTarget source) throws NoSuchAlgorithmException, IOException {
        if (!this.context.getFileStorage().getLocalState(syncmatic).isReadyForDownload()) {
            throw new IllegalArgumentException(syncmatic.toString() + " is not ready for download local state is: " + this.context.getFileStorage().getLocalState(syncmatic).toString());
        }
        File toDownload = this.context.getFileStorage().createLocalLitematic(syncmatic);
        DownloadExchange downloadExchange = new DownloadExchange(syncmatic, toDownload, source, this.context);
        this.setDownloadState(syncmatic, true);
        this.startExchange(downloadExchange);
        this.context.getSyncmaticManager().updateServerPlacement(syncmatic);
    }

    public void setDownloadState(ServerPlacement syncmatic, boolean b) {
        this.downloadState.put(syncmatic.getHash(), b);
        this.context.getSyncmaticManager().updateServerPlacement(syncmatic);
    }

    public boolean getDownloadState(ServerPlacement syncmatic) {
        return this.downloadState.getOrDefault(syncmatic.getHash(), false);
    }

    public void setModifier(ServerPlacement syncmatic, Exchange exchange) {
        this.modifyState.put(syncmatic.getHash(), exchange);
    }

    public Exchange getModifier(ServerPlacement syncmatic) {
        return this.modifyState.get(syncmatic.getHash());
    }

    public void startExchange(Exchange newExchange) {
        if (!this.broadcastTargets.contains(newExchange.getPartner())) {
            throw new IllegalArgumentException(newExchange.getPartner().toString() + " is not a valid ExchangeTarget");
        }
        this.startExchangeUnchecked(newExchange);
    }

    protected void startExchangeUnchecked(Exchange newExchange) {
        newExchange.getPartner().getExchanges().add(newExchange);
        newExchange.init();
        if (newExchange.isFinished()) {
            this.notifyClose(newExchange);
        }
    }

    public void setContext(Context con) {
        if (this.context != null) {
            throw new Context.DuplicateContextAssignmentException("Duplicate Context Assignment");
        }
        this.context = con;
    }

    public void notifyClose(Exchange e) {
        e.getPartner().getExchanges().remove(e);
        this.handleExchange(e);
    }
}

