/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Feature;
import ch.endte.syncmatica.ServerPlacement;
import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.communication.CommunicationManager;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.MessageType;
import ch.endte.syncmatica.communication.PacketType;
import ch.endte.syncmatica.communication.exchange.DownloadExchange;
import ch.endte.syncmatica.communication.exchange.Exchange;
import ch.endte.syncmatica.communication.exchange.VersionHandshakeClient;
import ch.endte.syncmatica.extended_core.PlayerIdentifier;
import ch.endte.syncmatica.litematica.LitematicManager;
import ch.endte.syncmatica.litematica.ScreenHelper;
import ch.endte.syncmatica.mixin_actor.ActorClientPlayNetworkHandler;
import fi.dy.masa.malilib.gui.Message;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class ClientCommunicationManager
extends CommunicationManager {
    private final ExchangeTarget server;
    private final Collection<ServerPlacement> sharing;

    public ClientCommunicationManager(ExchangeTarget server) {
        this.server = server;
        this.broadcastTargets.add(server);
        this.sharing = new HashSet<ServerPlacement>();
    }

    public ExchangeTarget getServer() {
        return this.server;
    }

    @Override
    protected void handle(ExchangeTarget source, class_2960 id, class_2540 packetBuf) {
        if (id.equals((Object)PacketType.REGISTER_METADATA.identifier)) {
            ServerPlacement placement = this.receiveMetaData(packetBuf, source);
            this.context.getSyncmaticManager().addPlacement(placement);
            return;
        }
        if (id.equals((Object)PacketType.REMOVE_SYNCMATIC.identifier)) {
            UUID placementId = packetBuf.method_10790();
            ServerPlacement placement = this.context.getSyncmaticManager().getPlacement(placementId);
            if (placement != null) {
                Exchange modifier = this.getModifier(placement);
                if (modifier != null) {
                    modifier.close(false);
                    this.notifyClose(modifier);
                }
                this.context.getSyncmaticManager().removePlacement(placement);
                if (LitematicManager.getInstance().isRendered(placement)) {
                    LitematicManager.getInstance().unrenderSyncmatic(placement);
                }
            }
            return;
        }
        if (id.equals((Object)PacketType.MODIFY.identifier)) {
            UUID placementId = packetBuf.method_10790();
            ServerPlacement toModify = this.context.getSyncmaticManager().getPlacement(placementId);
            this.receivePositionData(toModify, packetBuf, source);
            if (source.getFeatureSet().hasFeature(Feature.CORE_EX)) {
                PlayerIdentifier lastModifiedBy = this.context.getPlayerIdentifierProvider().createOrGet(packetBuf.method_10790(), packetBuf.method_10800(Short.MAX_VALUE));
                toModify.setLastModifiedBy(lastModifiedBy);
            }
            LitematicManager.getInstance().updateRendered(toModify);
            this.context.getSyncmaticManager().updateServerPlacement(toModify);
            return;
        }
        if (id.equals((Object)PacketType.MESSAGE.identifier)) {
            Message.MessageType type = this.mapMessageType(MessageType.valueOf(packetBuf.method_10800(Short.MAX_VALUE)));
            String text = packetBuf.method_10800(Short.MAX_VALUE);
            ScreenHelper.ifPresent(s -> s.addMessage(type, text, new Object[0]));
            return;
        }
        if (id.equals((Object)PacketType.REGISTER_VERSION.identifier)) {
            LitematicManager.clear();
            Syncmatica.restartClient();
            ActorClientPlayNetworkHandler.getInstance().packetEvent(id, packetBuf);
        }
    }

    @Override
    protected void handleExchange(Exchange exchange) {
        if (exchange instanceof DownloadExchange && exchange.isSuccessful()) {
            LitematicManager.getInstance().renderSyncmatic(((DownloadExchange)exchange).getPlacement());
        }
    }

    @Override
    public void setDownloadState(ServerPlacement syncmatic, boolean state) {
        this.downloadState.put(syncmatic.getHash(), state);
        if (state || LitematicManager.getInstance().isRendered(syncmatic)) {
            this.context.getSyncmaticManager().updateServerPlacement(syncmatic);
        }
    }

    public void setSharingState(ServerPlacement placement, boolean state) {
        if (state) {
            this.sharing.add(placement);
        } else {
            this.sharing.remove(placement);
        }
    }

    public boolean getSharingState(ServerPlacement placement) {
        return this.sharing.contains(placement);
    }

    @Override
    public void setContext(Context con) {
        super.setContext(con);
        VersionHandshakeClient hi = new VersionHandshakeClient(this.server, this.context);
        this.startExchangeUnchecked(hi);
    }

    private Message.MessageType mapMessageType(MessageType m) {
        switch (m) {
            case SUCCESS: {
                return Message.MessageType.SUCCESS;
            }
            case WARNING: {
                return Message.MessageType.WARNING;
            }
            case ERROR: {
                return Message.MessageType.ERROR;
            }
        }
        return Message.MessageType.INFO;
    }
}

