/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.ServerPosition;
import ch.endte.syncmatica.extended_core.PlayerIdentifier;
import ch.endte.syncmatica.extended_core.SubRegionData;
import ch.endte.syncmatica.material.SyncmaticaMaterialList;
import ch.endte.syncmatica.util.SyncmaticaUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileInputStream;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;

public class ServerPlacement {
    private final UUID id;
    private final String fileName;
    private final UUID hashValue;
    private PlayerIdentifier owner;
    private PlayerIdentifier lastModifiedBy;
    private ServerPosition origin;
    private class_2470 rotation;
    private class_2415 mirror;
    private SubRegionData subRegionData = new SubRegionData();
    private SyncmaticaMaterialList matList;

    public ServerPlacement(UUID id, String fileName, UUID hashValue, PlayerIdentifier owner) {
        this.id = id;
        this.fileName = fileName;
        this.hashValue = hashValue;
        this.owner = owner;
        this.lastModifiedBy = owner;
    }

    public ServerPlacement(UUID id, File file, PlayerIdentifier owner) {
        this(id, ServerPlacement.removeExtension(file), ServerPlacement.generateHash(file), owner);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.fileName;
    }

    public UUID getHash() {
        return this.hashValue;
    }

    public String getDimension() {
        return this.origin.getDimensionId();
    }

    public class_2338 getPosition() {
        return this.origin.getBlockPosition();
    }

    public ServerPosition getOrigin() {
        return this.origin;
    }

    public class_2470 getRotation() {
        return this.rotation;
    }

    public class_2415 getMirror() {
        return this.mirror;
    }

    public ServerPlacement move(String dimensionId, class_2338 origin, class_2470 rotation, class_2415 mirror) {
        this.move(new ServerPosition(origin, dimensionId), rotation, mirror);
        return this;
    }

    public ServerPlacement move(ServerPosition origin, class_2470 rotation, class_2415 mirror) {
        this.origin = origin;
        this.rotation = rotation;
        this.mirror = mirror;
        return this;
    }

    public PlayerIdentifier getOwner() {
        return this.owner;
    }

    public void setOwner(PlayerIdentifier playerIdentifier) {
        this.owner = playerIdentifier;
    }

    public PlayerIdentifier getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(PlayerIdentifier lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public SubRegionData getSubRegionData() {
        return this.subRegionData;
    }

    public SyncmaticaMaterialList getMaterialList() {
        return this.matList;
    }

    public ServerPlacement setMaterialList(SyncmaticaMaterialList matList) {
        if (this.matList != null) {
            this.matList = matList;
        }
        return this;
    }

    private static String removeExtension(File file) {
        String fileName = file.getName();
        int pos = fileName.lastIndexOf(".");
        return fileName.substring(0, pos);
    }

    private static UUID generateHash(File file) {
        UUID hash = null;
        try {
            hash = SyncmaticaUtil.createChecksum(new FileInputStream(file));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return hash;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("id", (JsonElement)new JsonPrimitive(this.id.toString()));
        obj.add("file_name", (JsonElement)new JsonPrimitive(this.fileName));
        obj.add("hash", (JsonElement)new JsonPrimitive(this.hashValue.toString()));
        obj.add("origin", (JsonElement)this.origin.toJson());
        obj.add("rotation", (JsonElement)new JsonPrimitive(this.rotation.name()));
        obj.add("mirror", (JsonElement)new JsonPrimitive(this.mirror.name()));
        obj.add("owner", (JsonElement)this.owner.toJson());
        if (!this.owner.equals(this.lastModifiedBy)) {
            obj.add("lastModifiedBy", (JsonElement)this.lastModifiedBy.toJson());
        }
        if (this.subRegionData.isModified()) {
            obj.add("subregionData", this.subRegionData.toJson());
        }
        return obj;
    }

    public static ServerPlacement fromJson(JsonObject obj, Context context) {
        if (obj.has("id") && obj.has("file_name") && obj.has("hash") && obj.has("origin") && obj.has("rotation") && obj.has("mirror")) {
            UUID id = UUID.fromString(obj.get("id").getAsString());
            String name = obj.get("file_name").getAsString();
            UUID hashValue = UUID.fromString(obj.get("hash").getAsString());
            PlayerIdentifier owner = PlayerIdentifier.MISSING_PLAYER;
            if (obj.has("owner")) {
                owner = context.getPlayerIdentifierProvider().fromJson(obj.get("owner").getAsJsonObject());
            }
            ServerPlacement newPlacement = new ServerPlacement(id, name, hashValue, owner);
            ServerPosition pos = ServerPosition.fromJson(obj.get("origin").getAsJsonObject());
            if (pos == null) {
                return null;
            }
            newPlacement.origin = pos;
            newPlacement.rotation = class_2470.valueOf((String)obj.get("rotation").getAsString());
            newPlacement.mirror = class_2415.valueOf((String)obj.get("mirror").getAsString());
            newPlacement.lastModifiedBy = obj.has("lastModifiedBy") ? context.getPlayerIdentifierProvider().fromJson(obj.get("lastModifiedBy").getAsJsonObject()) : owner;
            if (obj.has("subregionData")) {
                newPlacement.subRegionData = SubRegionData.fromJson(obj.get("subregionData"));
            }
            return newPlacement;
        }
        return null;
    }
}

