/*
 * Decompiled with CFR 0.152.
 */
package me.axieum.mcmod.authme.api.util;

import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.axieum.mcmod.authme.impl.AuthMe;
import me.axieum.mcmod.authme.mixin.MinecraftClientAccessor;
import me.axieum.mcmod.authme.mixin.RealmsMainScreenAccessor;
import net.minecraft.class_310;
import net.minecraft.class_320;

public final class SessionUtils {
    private static final YggdrasilAuthenticationService YAS = new YggdrasilAuthenticationService(class_310.method_1551().method_1487(), UUID.randomUUID().toString());
    private static final YggdrasilUserAuthentication YUA = (YggdrasilUserAuthentication)YAS.createUserAuthentication(Agent.MINECRAFT);
    private static final YggdrasilMinecraftSessionService YMSS = (YggdrasilMinecraftSessionService)YAS.createMinecraftSessionService();
    public static final long STATUS_TTL = 60000L;
    private static long lastStatusCheck;
    private static SessionStatus lastStatus;

    private SessionUtils() {
    }

    public static class_320 getSession() {
        return class_310.method_1551().method_1548();
    }

    public static void setSession(class_320 session) {
        ((MinecraftClientAccessor)class_310.method_1551()).setSession(session);
        RealmsMainScreenAccessor.setCheckedClientCompatibility(false);
        RealmsMainScreenAccessor.setRealmsGenericErrorScreen(null);
        lastStatus = SessionStatus.UNKNOWN;
        lastStatusCheck = 0L;
        AuthMe.LOGGER.info("Minecraft session for {} (uuid={}) has been applied", (Object)session.method_1676(), (Object)session.method_1673());
    }

    public static class_320 offline(String username) {
        return new class_320(username, UUID.nameUUIDFromBytes(("offline:" + username).getBytes()).toString(), "invalidtoken", Optional.empty(), Optional.empty(), class_320.class_321.field_1990);
    }

    public static CompletableFuture<SessionStatus> getStatus() {
        if (System.currentTimeMillis() - lastStatusCheck < 60000L) {
            return CompletableFuture.completedFuture(lastStatus);
        }
        return CompletableFuture.supplyAsync(() -> {
            class_320 session = SessionUtils.getSession();
            GameProfile profile = session.method_1677();
            String token = session.method_1674();
            String id = UUID.randomUUID().toString();
            try {
                AuthMe.LOGGER.info("Verifying Minecraft session...");
                YMSS.joinServer(profile, token, id);
                if (YMSS.hasJoinedServer(profile, id, null).isComplete()) {
                    AuthMe.LOGGER.info("The Minecraft session is valid");
                    lastStatus = SessionStatus.VALID;
                } else {
                    AuthMe.LOGGER.warn("The Minecraft session is invalid!");
                    lastStatus = SessionStatus.INVALID;
                }
            }
            catch (AuthenticationException e) {
                AuthMe.LOGGER.error("Could not validate the Minecraft session!", (Throwable)e);
                lastStatus = SessionStatus.OFFLINE;
            }
            lastStatusCheck = System.currentTimeMillis();
            return lastStatus;
        });
    }

    public static YggdrasilAuthenticationService getAuthService() {
        return YAS;
    }

    public static YggdrasilUserAuthentication getAuthProvider() {
        return YUA;
    }

    public static YggdrasilMinecraftSessionService getSessionService() {
        return YMSS;
    }

    static {
        lastStatus = SessionStatus.UNKNOWN;
    }

    public static enum SessionStatus {
        VALID,
        INVALID,
        OFFLINE,
        UNKNOWN;

    }
}

