/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage1;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EssentialLoaderBase {
    private static final Logger LOGGER = LogManager.getLogger(EssentialLoaderBase.class);
    protected static final String STAGE2_PKG = "gg.essential.loader.stage2.";
    protected static final String STAGE2_CLS = "gg.essential.loader.stage2.EssentialLoader";
    private static final String BASE_URL = System.getProperty("essential.download.url", System.getenv().getOrDefault("ESSENTIAL_DOWNLOAD_URL", "https://downloads.essential.gg"));
    private static final String BRANCH = System.getProperty("essential.stage2.branch", System.getenv().getOrDefault("ESSENTIAL_STAGE2_BRANCH", "stable"));
    private static final String VERSION_URL = BASE_URL + "/v1/mods/essential/loader-stage2/updates/" + BRANCH + "/%s/";
    private static final boolean AUTO_UPDATE = "true".equals(System.getProperty("essential.autoUpdate", "true"));
    private final String variant;
    private final String gameVersion;
    private Object stage2;
    private boolean loaded;

    EssentialLoaderBase(String variant, String gameVersion) {
        this.variant = variant;
        this.gameVersion = gameVersion;
    }

    public void load(Path gameDir) throws Exception {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        Path dataDir = gameDir.resolve("essential").resolve("loader").resolve("stage1").resolve(this.variant);
        Path stage2File = dataDir.resolve("stage2." + this.gameVersion + ".jar");
        URL stage2Url = stage2File.toUri().toURL();
        if (!Files.exists(dataDir, new LinkOption[0])) {
            Files.createDirectories(dataDir, new FileAttribute[0]);
        }
        boolean needUpdate = !Files.exists(stage2File, new LinkOption[0]);
        FileMeta meta = null;
        if ((needUpdate || AUTO_UPDATE) && (meta = this.fetchLatestMetadata()) == null && needUpdate) {
            return;
        }
        if (!needUpdate && meta != null && !meta.checksum.equals(this.getChecksum(stage2File))) {
            needUpdate = true;
        }
        if (needUpdate) {
            Path downloadedFile = Files.createTempFile("essential-download-", "", new FileAttribute[0]);
            if (this.downloadFile(meta, downloadedFile)) {
                Files.deleteIfExists(stage2File);
                Files.move(downloadedFile, stage2File, new CopyOption[0]);
            } else {
                LOGGER.warn("Unable to download Essential, please check your internet connection. If the problem persists, please contact Support.");
                Files.deleteIfExists(downloadedFile);
            }
        }
        if (!Files.exists(stage2File, new LinkOption[0])) {
            return;
        }
        ClassLoader classLoader = this.addToClassLoader(stage2Url);
        this.stage2 = Class.forName(STAGE2_CLS, true, classLoader).getConstructor(Path.class, String.class).newInstance(gameDir, this.gameVersion);
        this.stage2.getClass().getMethod("load", new Class[0]).invoke(this.stage2, new Object[0]);
    }

    protected abstract ClassLoader addToClassLoader(URL var1) throws Exception;

    public void initialize() {
        if (this.stage2 == null) {
            return;
        }
        try {
            this.stage2.getClass().getMethod("initialize", new Class[0]).invoke(this.stage2, new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unexpected error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getChecksum(Path input) {
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);){
            String string = DigestUtils.md5Hex((InputStream)inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private URLConnection prepareConnection(String url) throws IOException {
        URLConnection urlConnection = new URL(url).openConnection();
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setUseCaches(true);
            httpURLConnection.setReadTimeout(3000);
            httpURLConnection.setReadTimeout(3000);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("User-Agent", "Mozilla/5.0 (Essential Initializer)");
        }
        return urlConnection;
    }

    private FileMeta fetchLatestMetadata() {
        String checksum;
        JsonObject responseObject;
        try {
            String response;
            URLConnection connection = this.prepareConnection(String.format(VERSION_URL, this.gameVersion.replace(".", "-")));
            try (InputStream inputStream = connection.getInputStream();){
                response = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
            }
            JsonElement jsonElement = new JsonParser().parse(response);
            responseObject = jsonElement.isJsonObject() ? jsonElement.getAsJsonObject() : null;
        }
        catch (JsonParseException | IOException e) {
            LOGGER.error("Error occurred checking for updates for game version {}.", new Object[]{this.gameVersion, e});
            return null;
        }
        if (responseObject == null) {
            LOGGER.warn("Essential does not support the following game version: {}", new Object[]{this.gameVersion});
            return null;
        }
        JsonElement jsonUrl = responseObject.get("url");
        JsonElement jsonChecksum = responseObject.get("checksum");
        String url = jsonUrl != null && jsonUrl.isJsonPrimitive() ? jsonUrl.getAsString() : null;
        String string = checksum = jsonChecksum != null && jsonChecksum.isJsonPrimitive() ? responseObject.get("checksum").getAsString() : null;
        if (StringUtils.isEmpty((CharSequence)url) || StringUtils.isEmpty((CharSequence)checksum)) {
            LOGGER.warn("Unexpected response object data (url={}, checksum={})", new Object[]{jsonUrl, jsonChecksum});
            return null;
        }
        return new FileMeta(url, checksum);
    }

    private boolean downloadFile(FileMeta meta, Path target) {
        try {
            URLConnection connection = this.prepareConnection(meta.url);
            Files.copy(connection.getInputStream(), target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("Error occurred when downloading file '{}'.", new Object[]{meta.url, e});
            return false;
        }
        String actualHash = this.getChecksum(target);
        if (!meta.checksum.equals(actualHash)) {
            LOGGER.warn("Downloaded Essential file checksum did not match what we expected (actual={}, expected={}", new Object[]{actualHash, meta.checksum});
            return false;
        }
        return true;
    }

    private static class FileMeta {
        String url;
        String checksum;

        public FileMeta(String url, String checksum) {
            this.url = url;
            this.checksum = checksum;
        }
    }
}

