/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.registry;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.impl.content.registry.util.ImmutableCollectionUtils;
import net.fabricmc.fabric.mixin.content.registry.FarmerWorkTaskAccessor;
import net.fabricmc.fabric.mixin.content.registry.GiveGiftsToHeroTaskAccessor;
import net.fabricmc.fabric.mixin.content.registry.VillagerEntityAccessor;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VillagerInteractionRegistries {
    private static final Logger LOGGER = LoggerFactory.getLogger(VillagerInteractionRegistries.class);

    private VillagerInteractionRegistries() {
    }

    public static void registerCollectable(class_1935 item) {
        Objects.requireNonNull(item.method_8389(), "Item cannot be null!");
        VillagerInteractionRegistries.getCollectableRegistry().add(item.method_8389());
    }

    public static void registerCompostable(class_1935 item) {
        Objects.requireNonNull(item.method_8389(), "Item cannot be null!");
        VillagerInteractionRegistries.getCompostableRegistry().add(item.method_8389());
    }

    public static void registerFood(class_1935 item, int foodValue) {
        Objects.requireNonNull(item.method_8389(), "Item cannot be null!");
        Objects.requireNonNull(Integer.valueOf(foodValue), "Food value cannot be null!");
        Integer oldValue = VillagerInteractionRegistries.getFoodRegistry().put(item.method_8389(), foodValue);
        if (oldValue != null) {
            LOGGER.info("Overriding previous food value of {}, was: {}, now: {}", new Object[]{item.method_8389().toString(), oldValue, foodValue});
        }
    }

    public static void registerGiftLootTable(class_3852 profession, class_2960 lootTable) {
        Objects.requireNonNull(profession, "Profession cannot be null!");
        Objects.requireNonNull(lootTable, "Loot table identifier cannot be null!");
        class_2960 oldValue = GiveGiftsToHeroTaskAccessor.fabric_getGifts().put(profession, lootTable);
        if (oldValue != null) {
            LOGGER.info("Overriding previous gift loot table of {} profession, was: {}, now: {}", new Object[]{profession.comp_818(), oldValue, lootTable});
        }
    }

    private static Set<class_1792> getCollectableRegistry() {
        return ImmutableCollectionUtils.getAsMutableSet(VillagerEntityAccessor::fabric_getGatherableItems, VillagerEntityAccessor::fabric_setGatherableItems);
    }

    private static List<class_1792> getCompostableRegistry() {
        return ImmutableCollectionUtils.getAsMutableList(FarmerWorkTaskAccessor::fabric_getCompostable, FarmerWorkTaskAccessor::fabric_setCompostables);
    }

    private static Map<class_1792, Integer> getFoodRegistry() {
        return ImmutableCollectionUtils.getAsMutableMap(() -> class_1646.field_18526, VillagerEntityAccessor::fabric_setItemFoodValues);
    }
}

