/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.mcless.config;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;

public class ConfigIo<T> {
    private final Consumer<String> warn;
    private final BiConsumer<String, Throwable> error;
    private final Gson gson;
    private final Type type;
    private final Supplier<T> factory;
    private final int currentVersion;
    private final ToIntFunction<T> versionGetter;
    private final ObjIntConsumer<T> versionSetter;

    public ConfigIo(Consumer<String> warn, BiConsumer<String, Throwable> error, Gson gson, Type type, Supplier<T> factory, int currentVersion, ToIntFunction<T> versionGetter, ObjIntConsumer<T> versionSetter) {
        this.warn = warn;
        this.error = error;
        this.gson = gson;
        this.type = type;
        this.factory = factory;
        this.currentVersion = currentVersion;
        this.versionGetter = versionGetter;
        this.versionSetter = versionSetter;
    }

    public ConfigIo(Consumer<String> warn, BiConsumer<String, Throwable> error, Gson gson, Type type, Supplier<T> factory) {
        this(warn, error, gson, type, factory, 0, t -> 0, (a, b) -> {});
    }

    public T read(Path path) {
        Object config;
        boolean init = true;
        if (!Files.exists(path, new LinkOption[0])) {
            Path parent = path.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                try {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                catch (IOException e) {
                    this.error.accept("Failed to make directory " + parent, e);
                }
            }
            config = this.factory.get();
        } else {
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                config = this.gson.fromJson((Reader)reader, this.type);
                int version = this.versionGetter.applyAsInt(config);
                if (version != this.currentVersion) {
                    Path old = Paths.get(path + "_old", new String[0]);
                    this.warn.accept("Config file " + path + " contains different version (" + version + ") than required version (" + this.currentVersion + "), this config will be reset. Old config will be placed at " + old);
                    Files.deleteIfExists(old);
                    Files.copy(path, old, new CopyOption[0]);
                    config = this.factory.get();
                } else {
                    init = false;
                }
            }
            catch (Exception e) {
                Path old = Paths.get(path + "_old", new String[0]);
                this.error.accept("Exception when reading config file " + path + ", this config will be reset. Old config will be placed at " + old, e);
                try {
                    Files.deleteIfExists(old);
                    Files.copy(path, old, new CopyOption[0]);
                }
                catch (IOException e1) {
                    this.error.accept("well this is embarrassing...", e1);
                }
                config = this.factory.get();
            }
        }
        if (init) {
            this.versionSetter.accept(config, this.currentVersion);
            this.write(path, config);
        }
        return config;
    }

    public boolean write(Path path, T value) {
        boolean bl;
        block8: {
            BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
            try {
                writer.write(this.gson.toJson(value));
                bl = true;
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            writer.close();
        }
        return bl;
    }
}

