/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.command;

import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.stream.Stream;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.command.ArgumentBuilderBuilder;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.gui.screen.HomeScreen;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public abstract class ClientCommand<S> {
    private final ArgumentBuilderFactory<S> argument;

    protected ClientCommand(ArgumentBuilderFactory<S> argument) {
        this.argument = argument;
    }

    protected abstract FeedbackSender feedback(S var1);

    public final void register(CommandDispatcher<S> dispatcher) {
        new ArgumentBuilderBuilder<S>(this.argument.literal("wailac")).then((ArgumentBuilder<S, ?>)this.argument.literal("config")).then((ArgumentBuilder<S, ?>)this.argument.literal("open")).executes(context -> {
            class_310 client = class_310.method_1551();
            client.method_18858(() -> client.method_1507((class_437)new HomeScreen(client.field_1755)));
            return 1;
        }).pop("open").then((ArgumentBuilder<S, ?>)this.argument.literal("plugin")).then((ArgumentBuilder<S, ?>)this.argument.required("id", class_2232.method_9441())).suggests((context, builder) -> class_2172.method_9270(PluginConfig.INSTANCE.getKeys(), (SuggestionsBuilder)builder)).executes(context -> {
            FeedbackSender feedback = this.feedback(context.getSource());
            class_2960 id = (class_2960)context.getArgument("id", class_2960.class);
            ConfigEntry entry = PluginConfig.INSTANCE.getEntry(id);
            if (entry == null) {
                feedback.fail((class_2561)class_2561.method_43469((String)"command.waila.config.unknown_id", (Object[])new Object[]{id}));
                return 0;
            }
            feedback.success((class_2561)class_2561.method_43469((String)"command.waila.config.get.id", (Object[])new Object[]{id}));
            feedback.success((class_2561)class_2561.method_43469((String)"command.waila.config.get.synced", (Object[])new Object[]{entry.isSynced()}));
            feedback.success((class_2561)class_2561.method_43469((String)"command.waila.config.get.current_value", (Object[])new Object[]{entry.getValue().toString()}));
            feedback.success((class_2561)class_2561.method_43469((String)"command.waila.config.get.default_value", (Object[])new Object[]{entry.getDefaultValue().toString()}));
            if (entry.isSynced()) {
                feedback.success((class_2561)class_2561.method_43469((String)"command.waila.config.get.client_only_value", (Object[])new Object[]{entry.getClientOnlyValue().toString()}));
            }
            return 1;
        }).then((ArgumentBuilder<S, ?>)this.argument.required("value", StringArgumentType.word())).suggests((context, builder) -> {
            class_2960 id = (class_2960)context.getArgument("id", class_2960.class);
            ConfigEntry entry = PluginConfig.INSTANCE.getEntry(id);
            if (entry != null) {
                if (entry.getType().equals(ConfigEntry.BOOLEAN)) {
                    return class_2172.method_9253((String[])new String[]{String.valueOf((Boolean)entry.getValue() == false)}, (SuggestionsBuilder)builder);
                }
                if (entry.getType().equals(ConfigEntry.ENUM)) {
                    Stream<String> suggestions = Arrays.stream(entry.getValue().getClass().getEnumConstants()).filter(e -> e != entry.getValue()).map(e -> ((Enum)e).name());
                    return class_2172.method_9264(suggestions, (SuggestionsBuilder)builder);
                }
            }
            return class_2172.method_9253((String[])new String[0], (SuggestionsBuilder)builder);
        }).executes(context -> {
            FeedbackSender feedback = this.feedback(context.getSource());
            class_2960 id = (class_2960)context.getArgument("id", class_2960.class);
            ConfigEntry entry = PluginConfig.INSTANCE.getEntry(id);
            if (entry == null) {
                feedback.fail((class_2561)class_2561.method_43469((String)"command.waila.config.unknown_id", (Object[])new Object[]{id}));
                return 0;
            }
            if (entry.isSynced() && class_310.method_1551().method_1558() != null) {
                feedback.fail((class_2561)class_2561.method_43469((String)"command.waila.config.set.synced", (Object[])new Object[]{id}));
            }
            JsonPrimitive jsonValue = new JsonPrimitive((String)context.getArgument("value", String.class));
            try {
                entry.setValue(entry.getType().parser.apply(jsonValue, (JsonPrimitive)entry.getDefaultValue()));
                feedback.success((class_2561)class_2561.method_43469((String)"command.waila.config.set.success", (Object[])new Object[]{id, entry.getValue()}));
                return 1;
            }
            catch (Throwable throwable) {
                feedback.fail((class_2561)class_2561.method_43469((String)"command.waila.config.set.parse_fail", (Object[])new Object[]{throwable.getMessage()}));
                throwable.printStackTrace();
                return 0;
            }
        }).pop("value", "id", "plugin", "config").then((ArgumentBuilder<S, ?>)this.argument.literal("overlay")).then((ArgumentBuilder<S, ?>)this.argument.required("enabled", BoolArgumentType.bool())).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{String.valueOf(!Waila.CONFIG.get().getGeneral().isDisplayTooltip())}, (SuggestionsBuilder)builder)).executes(context -> {
            FeedbackSender feedback = this.feedback(context.getSource());
            boolean enabled = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            Waila.CONFIG.get().getGeneral().setDisplayTooltip(enabled);
            feedback.success((class_2561)class_2561.method_43471((String)("command.waila.overlay." + enabled)));
            return enabled ? 1 : 0;
        }).pop("enabled", "overlay").register(dispatcher);
    }

    protected static interface ArgumentBuilderFactory<S> {
        public LiteralArgumentBuilder<S> literal(String var1);

        public <T> RequiredArgumentBuilder<S, T> required(String var1, ArgumentType<T> var2);
    }

    protected static interface FeedbackSender {
        public void success(class_2561 var1);

        public void fail(class_2561 var1);
    }
}

