/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.api.fiber.v1.exception;

import io.github.fablabsmc.fablabs.api.fiber.v1.exception.FiberException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.SerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigBranch;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigNode;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FiberQueryException
extends FiberException {
    private final ConfigTree invalidTree;

    public FiberQueryException(String message, ConfigTree invalidTree) {
        super(message + (invalidTree instanceof ConfigBranch && ((ConfigBranch)invalidTree).getName() != null ? " (in branch " + ((ConfigBranch)invalidTree).getName() + ")" : ""));
        this.invalidTree = invalidTree;
    }

    public FiberQueryException(String message, Throwable cause, ConfigTree invalidTree) {
        super(message, cause);
        this.invalidTree = invalidTree;
    }

    public ConfigTree getErrorParent() {
        return this.invalidTree;
    }

    public static class WrongType
    extends FiberQueryException {
        private final ConfigNode invalidItem;
        private final Class<?> expectedNodeType;
        @Nullable
        private final SerializableType<?> expectedValueType;

        public WrongType(ConfigTree invalidTree, ConfigNode invalidItem, Class<?> expectedNodeType, @Nullable SerializableType<?> expectedValueType) {
            super("Expected node of type " + expectedNodeType.getSimpleName() + (expectedValueType == null ? "" : "<" + expectedValueType + ">") + ", got " + invalidItem, invalidTree);
            this.invalidItem = invalidItem;
            this.expectedNodeType = expectedNodeType;
            this.expectedValueType = expectedValueType;
        }

        public ConfigNode getInvalidNode() {
            return this.invalidItem;
        }

        public Class<?> getExpectedNodeType() {
            return this.expectedNodeType;
        }

        @Nullable
        public SerializableType<?> getExpectedValueType() {
            return this.expectedValueType;
        }
    }

    public static class MissingChild
    extends FiberQueryException {
        private final String missingNodeName;

        public MissingChild(String name, ConfigTree invalidTree) {
            super("Missing child " + name, invalidTree);
            this.missingNodeName = name;
        }

        @Nonnull
        public String getMissingChildName() {
            return this.missingNodeName;
        }
    }
}

