/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.audioplayer.AudioPlayer;
import de.maxhenkel.audioplayer.Filebin;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;

public class AudioPlayerCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 ctx, class_2170.class_5364 environment) {
        LiteralArgumentBuilder literalBuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)"audioplayer").requires(commandSource -> commandSource.method_9259(Math.min(AudioPlayer.SERVER_CONFIG.uploadPermissionLevel.get(), AudioPlayer.SERVER_CONFIG.musicDiscPermissionLevel.get())));
        literalBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"upload").requires(commandSource -> commandSource.method_9259(AudioPlayer.SERVER_CONFIG.uploadPermissionLevel.get().intValue()))).executes(context -> {
            UUID uuid = UUID.randomUUID();
            String uploadURL = Filebin.getBin(uuid);
            class_5250 msg = class_2561.method_43470((String)"Click ").method_10852((class_2561)class_2561.method_43470((String)"this link").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, uploadURL)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to open")))).method_27692(class_124.field_1060)).method_27693(" and upload your sound as ").method_10852((class_2561)class_2561.method_43470((String)"wav").method_27692(class_124.field_1080)).method_27693(".\n").method_27693("Once you have uploaded the file, click ").method_10852((class_2561)class_2561.method_43470((String)"here").method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/audioplayer load " + uuid)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to confirm upload")))).method_27692(class_124.field_1060)).method_27693(".");
            ((class_2168)context.getSource()).method_9226((class_2561)msg, false);
            return 1;
        }));
        literalBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"load").requires(commandSource -> commandSource.method_9259(AudioPlayer.SERVER_CONFIG.uploadPermissionLevel.get().intValue()))).then(class_2170.method_9244((String)"id", (ArgumentType)class_5242.method_27643()).executes(context -> {
            UUID sound = class_5242.method_27645((CommandContext)context, (String)"id");
            new Thread(() -> {
                try {
                    ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Downloading sound, please wait..."), false);
                    Filebin.downloadSound(((class_2168)context.getSource()).method_9211(), sound);
                    class_5250 tc = class_2561.method_43470((String)"Successfully downloaded sound. ").method_10852((class_2561)class_2564.method_10885((class_2561)class_2561.method_43470((String)"Copy ID")).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, sound.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Copy sound ID")))).method_27692(class_124.field_1060)).method_27693(" ").method_10852((class_2561)class_2564.method_10885((class_2561)class_2561.method_43470((String)"Put on music disc")).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/audioplayer musicdisc %s".formatted(sound.toString()))).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Put the sound on a music disc")))).method_27692(class_124.field_1060));
                    ((class_2168)context.getSource()).method_9226((class_2561)tc, false);
                }
                catch (Exception e) {
                    AudioPlayer.LOGGER.warn("{} failed to download a sound: {}", (Object)((class_2168)context.getSource()).method_9214(), (Object)e.getMessage());
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to download sound: %s".formatted(e.getMessage())));
                }
            }).start();
            return 1;
        })));
        literalBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"musicdisc").requires(commandSource -> commandSource.method_9259(AudioPlayer.SERVER_CONFIG.musicDiscPermissionLevel.get().intValue()))).then(class_2170.method_9244((String)"sound", (ArgumentType)class_5242.method_27643()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            UUID sound = class_5242.method_27645((CommandContext)context, (String)"sound");
            class_1799 itemInHand = player.method_5998(class_1268.field_5808);
            AudioPlayerCommands.renameRecord((CommandContext<class_2168>)context, itemInHand, sound, null);
            return 1;
        })));
        literalBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"musicdisc").requires(commandSource -> commandSource.method_9259(AudioPlayer.SERVER_CONFIG.musicDiscPermissionLevel.get().intValue()))).then(class_2170.method_9244((String)"sound", (ArgumentType)class_5242.method_27643()).then(class_2170.method_9244((String)"custom_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            UUID sound = class_5242.method_27645((CommandContext)context, (String)"sound");
            class_1799 itemInHand = player.method_5998(class_1268.field_5808);
            String customName = StringArgumentType.getString((CommandContext)context, (String)"custom_name");
            AudioPlayerCommands.renameRecord((CommandContext<class_2168>)context, itemInHand, sound, customName);
            return 1;
        }))));
        dispatcher.register(literalBuilder);
    }

    private static void renameRecord(CommandContext<class_2168> context, class_1799 stack, UUID soundID, @Nullable String name) {
        if (!(stack.method_7909() instanceof class_1813)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You don't have a music disc in your main hand"));
            return;
        }
        class_2487 tag = stack.method_7948();
        tag.method_25927("CustomSound", soundID);
        class_2499 lore = new class_2499();
        if (name != null) {
            lore.method_10531(0, (class_2520)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43470((String)name).method_27694(style -> style.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1080))));
        }
        class_2487 display = new class_2487();
        display.method_10566("Lore", (class_2520)lore);
        tag.method_10566("display", (class_2520)display);
        tag.method_10569("HideFlags", class_1799.class_5422.field_25773.method_30269());
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Successfully updated music disc"), false);
    }
}

