/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.type;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kodein.type.DispJVMKt;
import org.kodein.type.TypeStringer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\f\u0010\rJ#\u0010\u0007\u001a\u00020\u00062\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/kodein/type/SimpleTypeStringer;", "Lorg/kodein/type/TypeStringer;", "Ljava/lang/Class;", "cls", "", "skipStars", "", "dispName", "(Ljava/lang/Class;Z)Ljava/lang/String;", "getArrayTypeName", "()Ljava/lang/String;", "arrayTypeName", "<init>", "()V", "kodein-type"})
final class SimpleTypeStringer
extends TypeStringer {
    @NotNull
    public static final SimpleTypeStringer INSTANCE = new SimpleTypeStringer();

    private SimpleTypeStringer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String dispName(@NotNull Class<?> cls, boolean skipStars) {
        String string;
        Intrinsics.checkNotNullParameter(cls, "cls");
        if (cls.isArray()) {
            if (cls.getComponentType().isPrimitive()) {
                Class<?> clazz = cls.getComponentType();
                if (Intrinsics.areEqual(clazz, Boolean.TYPE)) {
                    return "BooleanArray";
                }
                if (Intrinsics.areEqual(clazz, Byte.TYPE)) {
                    return "ByteArray";
                }
                if (Intrinsics.areEqual(clazz, Character.TYPE)) {
                    return "CharArray";
                }
                if (Intrinsics.areEqual(clazz, Short.TYPE)) {
                    return "ShortArray";
                }
                if (Intrinsics.areEqual(clazz, Integer.TYPE)) {
                    return "IntArray";
                }
                if (Intrinsics.areEqual(clazz, Long.TYPE)) {
                    return "LongArray";
                }
                if (Intrinsics.areEqual(clazz, Float.TYPE)) {
                    return "FloatArray";
                }
                if (Intrinsics.areEqual(clazz, Double.TYPE)) {
                    return "DoubleArray";
                }
                String string2 = Intrinsics.stringPlus("Unknown primitive type ", this);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            StringBuilder stringBuilder = new StringBuilder().append("Array<");
            TypeStringer typeStringer = this;
            Class<?> clazz = cls.getComponentType();
            Intrinsics.checkNotNullExpressionValue(clazz, "cls.componentType");
            string = stringBuilder.append(TypeStringer.dispString$default(typeStringer, clazz, false, 2, null)).append('>').toString();
            return string;
        } else {
            String string3 = DispJVMKt.access$getPrimitiveName(cls);
            string = string3 == null ? Intrinsics.stringPlus(DispJVMKt.simpleErasedName(cls), !skipStars ? DispJVMKt.access$getStars(cls) : "") : string3;
        }
        return string;
    }

    @Override
    @NotNull
    public String getArrayTypeName() {
        return "Array";
    }
}

