/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.scheduling;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.scheduling.GlobalQueue;
import kotlinx.coroutines.scheduling.Task;
import kotlinx.coroutines.scheduling.TasksKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b(\u0010)J!\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0011\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u001f\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\f*\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001c\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010%\u001a\u00020\"8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010'\u001a\u00020\"8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010$\u00a8\u0006*"}, d2={"Lkotlinx/coroutines/scheduling/WorkQueue;", "", "Lkotlinx/coroutines/scheduling/Task;", "task", "", "fair", "add", "(Lkotlinx/coroutines/scheduling/Task;Z)Lkotlinx/coroutines/scheduling/Task;", "addLast", "(Lkotlinx/coroutines/scheduling/Task;)Lkotlinx/coroutines/scheduling/Task;", "Lkotlinx/coroutines/scheduling/GlobalQueue;", "globalQueue", "", "offloadAllWorkTo", "(Lkotlinx/coroutines/scheduling/GlobalQueue;)V", "poll", "()Lkotlinx/coroutines/scheduling/Task;", "pollBuffer", "queue", "pollTo", "(Lkotlinx/coroutines/scheduling/GlobalQueue;)Z", "victim", "", "tryStealBlockingFrom", "(Lkotlinx/coroutines/scheduling/WorkQueue;)J", "tryStealFrom", "blockingOnly", "tryStealLastScheduled", "(Lkotlinx/coroutines/scheduling/WorkQueue;Z)J", "decrementIfBlocking", "(Lkotlinx/coroutines/scheduling/Task;)V", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "buffer", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "", "getBufferSize$kotlinx_coroutines_core", "()I", "bufferSize", "getSize$kotlinx_coroutines_core", "size", "<init>", "()V", "kotlinx-coroutines-core"})
public final class WorkQueue {
    @NotNull
    private final AtomicReferenceArray<Task> buffer = new AtomicReferenceArray(128);
    @NotNull
    private volatile /* synthetic */ Object lastScheduledTask;
    private static final /* synthetic */ AtomicReferenceFieldUpdater lastScheduledTask$FU;
    @NotNull
    private volatile /* synthetic */ int producerIndex;
    private static final /* synthetic */ AtomicIntegerFieldUpdater producerIndex$FU;
    @NotNull
    private volatile /* synthetic */ int consumerIndex;
    private static final /* synthetic */ AtomicIntegerFieldUpdater consumerIndex$FU;
    @NotNull
    private volatile /* synthetic */ int blockingTasksInBuffer;
    private static final /* synthetic */ AtomicIntegerFieldUpdater blockingTasksInBuffer$FU;

    public WorkQueue() {
        this.lastScheduledTask = null;
        this.producerIndex = 0;
        this.consumerIndex = 0;
        this.blockingTasksInBuffer = 0;
    }

    public final int getBufferSize$kotlinx_coroutines_core() {
        return this.producerIndex - this.consumerIndex;
    }

    public final int getSize$kotlinx_coroutines_core() {
        return this.lastScheduledTask != null ? this.getBufferSize$kotlinx_coroutines_core() + 1 : this.getBufferSize$kotlinx_coroutines_core();
    }

    @Nullable
    public final Task poll() {
        Task task = lastScheduledTask$FU.getAndSet(this, null);
        return task == null ? this.pollBuffer() : task;
    }

    @Nullable
    public final Task add(@NotNull Task task, boolean fair) {
        if (fair) {
            return this.addLast(task);
        }
        Task task2 = lastScheduledTask$FU.getAndSet(this, task);
        if (task2 == null) {
            return null;
        }
        Task previous = task2;
        return this.addLast(previous);
    }

    public static /* synthetic */ Task add$default(WorkQueue workQueue, Task task, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return workQueue.add(task, bl);
    }

    private final Task addLast(Task task) {
        Task $this$isBlocking$iv = task;
        boolean $i$f$isBlocking = false;
        if ($this$isBlocking$iv.taskContext.getTaskMode() == 1) {
            blockingTasksInBuffer$FU.incrementAndGet(this);
        }
        if (this.getBufferSize$kotlinx_coroutines_core() == 127) {
            return task;
        }
        int nextIndex = this.producerIndex & 0x7F;
        while (this.buffer.get(nextIndex) != null) {
            Thread.yield();
        }
        this.buffer.lazySet(nextIndex, task);
        producerIndex$FU.incrementAndGet(this);
        return null;
    }

    public final long tryStealFrom(@NotNull WorkQueue victim) {
        Task task;
        boolean bl = false;
        if (DebugKt.getASSERTIONS_ENABLED()) {
            boolean bl2 = false;
            if (!(this.getBufferSize$kotlinx_coroutines_core() == 0)) {
                throw new AssertionError();
            }
        }
        if ((task = victim.pollBuffer()) != null) {
            Task notAdded = WorkQueue.add$default(this, task, false, 2, null);
            boolean bl3 = false;
            if (DebugKt.getASSERTIONS_ENABLED()) {
                boolean bl4 = false;
                if (!(notAdded == null)) {
                    throw new AssertionError();
                }
            }
            return -1L;
        }
        return this.tryStealLastScheduled(victim, false);
    }

    public final long tryStealBlockingFrom(@NotNull WorkQueue victim) {
        boolean bl = false;
        if (DebugKt.getASSERTIONS_ENABLED()) {
            boolean bl2 = false;
            if (!(this.getBufferSize$kotlinx_coroutines_core() == 0)) {
                throw new AssertionError();
            }
        }
        int end = victim.producerIndex;
        AtomicReferenceArray<Task> buffer = victim.buffer;
        for (int start = victim.consumerIndex; start != end; ++start) {
            int index2 = start & 0x7F;
            if (victim.blockingTasksInBuffer == 0) break;
            Task value2 = buffer.get(index2);
            if (value2 == null) continue;
            Task $this$isBlocking$iv = value2;
            boolean $i$f$isBlocking = false;
            if (!($this$isBlocking$iv.taskContext.getTaskMode() == 1) || !buffer.compareAndSet(index2, value2, null)) continue;
            blockingTasksInBuffer$FU.decrementAndGet(victim);
            WorkQueue.add$default(this, value2, false, 2, null);
            return -1L;
        }
        return this.tryStealLastScheduled(victim, true);
    }

    public final void offloadAllWorkTo(@NotNull GlobalQueue globalQueue) {
        Task task = lastScheduledTask$FU.getAndSet(this, null);
        if (task != null) {
            Task task2 = task;
            boolean bl = false;
            boolean bl2 = false;
            Task it = task2;
            boolean bl3 = false;
            globalQueue.addLast(it);
        }
        while (this.pollTo(globalQueue)) {
        }
    }

    private final long tryStealLastScheduled(WorkQueue victim, boolean blockingOnly) {
        Task lastScheduled;
        do {
            long time;
            long staleness;
            Task task;
            if ((task = (Task)victim.lastScheduledTask) == null) {
                return -2L;
            }
            lastScheduled = task;
            if (blockingOnly) {
                Task $this$isBlocking$iv = lastScheduled;
                boolean $i$f$isBlocking = false;
                if (!($this$isBlocking$iv.taskContext.getTaskMode() == 1)) {
                    return -2L;
                }
            }
            if ((staleness = (time = TasksKt.schedulerTimeSource.nanoTime()) - lastScheduled.submissionTime) >= TasksKt.WORK_STEALING_TIME_RESOLUTION_NS) continue;
            return TasksKt.WORK_STEALING_TIME_RESOLUTION_NS - staleness;
        } while (!lastScheduledTask$FU.compareAndSet(victim, lastScheduled, null));
        WorkQueue.add$default(this, lastScheduled, false, 2, null);
        return -1L;
    }

    private final boolean pollTo(GlobalQueue queue) {
        Task task = this.pollBuffer();
        if (task == null) {
            return false;
        }
        Task task2 = task;
        queue.addLast(task2);
        return true;
    }

    private final Task pollBuffer() {
        int index2;
        Task task;
        int tailLocal;
        do {
            if ((tailLocal = this.consumerIndex) - this.producerIndex == 0) {
                return null;
            }
            index2 = tailLocal & 0x7F;
        } while (!consumerIndex$FU.compareAndSet(this, tailLocal, tailLocal + 1) || (task = (Task)this.buffer.getAndSet(index2, null)) == null);
        Task value2 = task;
        this.decrementIfBlocking(value2);
        return value2;
    }

    private final void decrementIfBlocking(Task $this$decrementIfBlocking) {
        if ($this$decrementIfBlocking != null) {
            Task $this$isBlocking$iv = $this$decrementIfBlocking;
            boolean $i$f$isBlocking = false;
            if ($this$isBlocking$iv.taskContext.getTaskMode() == 1) {
                int value2 = blockingTasksInBuffer$FU.decrementAndGet(this);
                boolean bl = false;
                if (DebugKt.getASSERTIONS_ENABLED()) {
                    boolean bl2 = false;
                    if (!(value2 >= 0)) {
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    static {
        lastScheduledTask$FU = AtomicReferenceFieldUpdater.newUpdater(WorkQueue.class, Object.class, "lastScheduledTask");
        producerIndex$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "producerIndex");
        consumerIndex$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "consumerIndex");
        blockingTasksInBuffer$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "blockingTasksInBuffer");
    }
}

