/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.scheduling;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.DefaultExecutor;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.InternalCoroutinesApi;
import kotlinx.coroutines.scheduling.CoroutineScheduler;
import kotlinx.coroutines.scheduling.LimitingDispatcher;
import kotlinx.coroutines.scheduling.TaskContext;
import kotlinx.coroutines.scheduling.TasksKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\b\u0017\u0018\u00002\u00020\u0001B'\b\u0016\u0012\b\b\u0002\u0010(\u001a\u00020\u0002\u0012\b\b\u0002\u00102\u001a\u00020\u0002\u0012\b\b\u0002\u00103\u001a\u00020#\u00a2\u0006\u0004\b5\u00106B\u001d\b\u0017\u0012\b\b\u0002\u0010(\u001a\u00020\u0002\u0012\b\b\u0002\u00102\u001a\u00020\u0002\u00a2\u0006\u0004\b5\u00107B)\u0012\u0006\u0010(\u001a\u00020\u0002\u0012\u0006\u00102\u001a\u00020\u0002\u0012\u0006\u00100\u001a\u00020\u001e\u0012\b\b\u0002\u00103\u001a\u00020#\u00a2\u0006\u0004\b5\u00108J\u0017\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\u0011\u001a\u00060\u000fj\u0002`\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J+\u0010\u0019\u001a\u00020\u00072\n\u0010\u0011\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0015H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J#\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\u0011\u001a\u00060\u000fj\u0002`\u0010H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0013J\u0015\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0006J\u000f\u0010\u001d\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\u001c\u0010\tJ\u0017\u0010\"\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u001eH\u0000\u00a2\u0006\u0004\b \u0010!J\u000f\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010'\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b&\u0010\tR\u0014\u0010(\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010/\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u00100\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0014\u00102\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u0010)R\u0014\u00103\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104\u00a8\u00069"}, d2={"Lkotlinx/coroutines/scheduling/ExperimentalCoroutineDispatcher;", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "", "parallelism", "Lkotlinx/coroutines/CoroutineDispatcher;", "blocking", "(I)Lkotlinx/coroutines/CoroutineDispatcher;", "", "close", "()V", "Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "createScheduler", "()Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "Lkotlin/coroutines/CoroutineContext;", "context", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "block", "dispatch", "(Lkotlin/coroutines/CoroutineContext;Ljava/lang/Runnable;)V", "Lkotlinx/coroutines/scheduling/TaskContext;", "", "tailDispatch", "dispatchWithContext$kotlinx_coroutines_core", "(Ljava/lang/Runnable;Lkotlinx/coroutines/scheduling/TaskContext;Z)V", "dispatchWithContext", "dispatchYield", "limited", "restore$kotlinx_coroutines_core", "restore", "", "timeout", "shutdown$kotlinx_coroutines_core", "(J)V", "shutdown", "", "toString", "()Ljava/lang/String;", "usePrivateScheduler$kotlinx_coroutines_core", "usePrivateScheduler", "corePoolSize", "I", "coroutineScheduler", "Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "Ljava/util/concurrent/Executor;", "getExecutor", "()Ljava/util/concurrent/Executor;", "executor", "idleWorkerKeepAliveNs", "J", "maxPoolSize", "schedulerName", "Ljava/lang/String;", "<init>", "(IILjava/lang/String;)V", "(II)V", "(IIJLjava/lang/String;)V", "kotlinx-coroutines-core"})
@InternalCoroutinesApi
public class ExperimentalCoroutineDispatcher
extends ExecutorCoroutineDispatcher {
    private final int corePoolSize;
    private final int maxPoolSize;
    private final long idleWorkerKeepAliveNs;
    @NotNull
    private final String schedulerName;
    @NotNull
    private CoroutineScheduler coroutineScheduler;

    public ExperimentalCoroutineDispatcher(int corePoolSize, int maxPoolSize, long idleWorkerKeepAliveNs, @NotNull String schedulerName) {
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.idleWorkerKeepAliveNs = idleWorkerKeepAliveNs;
        this.schedulerName = schedulerName;
        this.coroutineScheduler = this.createScheduler();
    }

    public /* synthetic */ ExperimentalCoroutineDispatcher(int n, int n2, long l, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            string = "CoroutineScheduler";
        }
        this(n, n2, l, string);
    }

    public ExperimentalCoroutineDispatcher(int corePoolSize, int maxPoolSize, @NotNull String schedulerName) {
        this(corePoolSize, maxPoolSize, TasksKt.IDLE_WORKER_KEEP_ALIVE_NS, schedulerName);
    }

    public /* synthetic */ ExperimentalCoroutineDispatcher(int n, int n2, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = TasksKt.CORE_POOL_SIZE;
        }
        if ((n3 & 2) != 0) {
            n2 = TasksKt.MAX_POOL_SIZE;
        }
        if ((n3 & 4) != 0) {
            string = "DefaultDispatcher";
        }
        this(n, n2, string);
    }

    @Deprecated(message="Binary compatibility for Ktor 1.0-beta", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ ExperimentalCoroutineDispatcher(int corePoolSize, int maxPoolSize) {
        this(corePoolSize, maxPoolSize, TasksKt.IDLE_WORKER_KEEP_ALIVE_NS, null, 8, null);
    }

    public /* synthetic */ ExperimentalCoroutineDispatcher(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = TasksKt.CORE_POOL_SIZE;
        }
        if ((n3 & 2) != 0) {
            n2 = TasksKt.MAX_POOL_SIZE;
        }
        this(n, n2);
    }

    @Override
    @NotNull
    public Executor getExecutor() {
        return this.coroutineScheduler;
    }

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        try {
            CoroutineScheduler.dispatch$default(this.coroutineScheduler, block, null, false, 6, null);
        }
        catch (RejectedExecutionException e) {
            DefaultExecutor.INSTANCE.dispatch(context, block);
        }
    }

    @Override
    public void dispatchYield(@NotNull CoroutineContext context, @NotNull Runnable block) {
        try {
            CoroutineScheduler.dispatch$default(this.coroutineScheduler, block, null, true, 2, null);
        }
        catch (RejectedExecutionException e) {
            DefaultExecutor.INSTANCE.dispatchYield(context, block);
        }
    }

    @Override
    public void close() {
        this.coroutineScheduler.close();
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + "[scheduler = " + this.coroutineScheduler + ']';
    }

    @NotNull
    public final CoroutineDispatcher blocking(int parallelism) {
        boolean bl = parallelism > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus("Expected positive parallelism level, but have ", parallelism);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new LimitingDispatcher(this, parallelism, null, 1);
    }

    public static /* synthetic */ CoroutineDispatcher blocking$default(ExperimentalCoroutineDispatcher experimentalCoroutineDispatcher, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: blocking");
        }
        if ((n2 & 1) != 0) {
            n = TasksKt.BLOCKING_DEFAULT_PARALLELISM;
        }
        return experimentalCoroutineDispatcher.blocking(n);
    }

    @NotNull
    public final CoroutineDispatcher limited(int parallelism) {
        boolean bl = parallelism > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus("Expected positive parallelism level, but have ", parallelism);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = parallelism <= this.corePoolSize;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Expected parallelism level lesser than core pool size (" + this.corePoolSize + "), but have " + parallelism;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new LimitingDispatcher(this, parallelism, null, 0);
    }

    public final void dispatchWithContext$kotlinx_coroutines_core(@NotNull Runnable block, @NotNull TaskContext context, boolean tailDispatch) {
        try {
            this.coroutineScheduler.dispatch(block, context, tailDispatch);
        }
        catch (RejectedExecutionException e) {
            DefaultExecutor.INSTANCE.enqueue(this.coroutineScheduler.createTask(block, context));
        }
    }

    private final CoroutineScheduler createScheduler() {
        return new CoroutineScheduler(this.corePoolSize, this.maxPoolSize, this.idleWorkerKeepAliveNs, this.schedulerName);
    }

    public final synchronized void usePrivateScheduler$kotlinx_coroutines_core() {
        this.coroutineScheduler.shutdown(1000L);
        this.coroutineScheduler = this.createScheduler();
    }

    public final synchronized void shutdown$kotlinx_coroutines_core(long timeout2) {
        this.coroutineScheduler.shutdown(timeout2);
    }

    public final void restore$kotlinx_coroutines_core() {
        this.usePrivateScheduler$kotlinx_coroutines_core();
    }
}

