/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.CoroutineStackFrame;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.InternalCoroutinesApi;
import kotlinx.coroutines.internal.ExceptionsConstuctorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000d\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0010\u001a\u001b\u0010\u0004\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u0001\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a;\u0010\f\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00028\u00002\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\nH\u0002\u00a2\u0006\u0004\b\f\u0010\r\u001a%\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\n2\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a3\u0010\u0016\u001a\u00020\u00152\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u00132\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\nH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u001b\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0006H\u0080H\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a-\u0010\u001c\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\u0018\u001a\u00028\u00002\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u000fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a!\u0010\u001e\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\u0018\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a.\u0010\u001e\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\u0018\u001a\u00028\u00002\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030 H\u0080\b\u00a2\u0006\u0004\b\u001e\u0010!\u001a\"\u0010\"\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\u0018\u001a\u00028\u0000H\u0080\b\u00a2\u0006\u0004\b\"\u0010\u001f\u001a!\u0010#\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\u0018\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b#\u0010\u001f\u001a3\u0010%\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u00130$\"\b\b\u0000\u0010\u0007*\u00020\u0006*\u00028\u0000H\u0002\u00a2\u0006\u0004\b%\u0010&\u001a#\u0010)\u001a\u00020(*\u00060\u0002j\u0002`\u00032\n\u0010'\u001a\u00060\u0002j\u0002`\u0003H\u0002\u00a2\u0006\u0004\b)\u0010*\u001a%\u0010-\u001a\u00020,*\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u00132\u0006\u0010+\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b-\u0010.\u001a\u001b\u0010/\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b/\u00100\u001a\u0017\u00101\u001a\u00020(*\u00060\u0002j\u0002`\u0003H\u0000\u00a2\u0006\u0004\b1\u00102\u001a\u001d\u00103\u001a\u00028\u0000\"\b\b\u0000\u0010\u0007*\u00020\u0006*\u00028\u0000H\u0002\u00a2\u0006\u0004\b3\u0010\u001f\"\u0014\u00104\u001a\u00020\u00008\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b4\u00105\"\u001c\u00107\u001a\n 6*\u0004\u0018\u00010\u00000\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00105\"\u0014\u00108\u001a\u00020\u00008\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b8\u00105\"\u001c\u00109\u001a\n 6*\u0004\u0018\u00010\u00000\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u00105*\f\b\u0000\u0010:\"\u00020\u000e2\u00020\u000e*\f\b\u0000\u0010;\"\u00020\u00022\u00020\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006<"}, d2={"", "message", "Ljava/lang/StackTraceElement;", "Lkotlinx/coroutines/internal/StackTraceElement;", "artificialFrame", "(Ljava/lang/String;)Ljava/lang/StackTraceElement;", "", "E", "cause", "result", "Ljava/util/ArrayDeque;", "resultStackTrace", "createFinalException", "(Ljava/lang/Throwable;Ljava/lang/Throwable;Ljava/util/ArrayDeque;)Ljava/lang/Throwable;", "Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;", "Lkotlinx/coroutines/internal/CoroutineStackFrame;", "continuation", "createStackTrace", "(Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;)Ljava/util/ArrayDeque;", "", "recoveredStacktrace", "", "mergeRecoveredTraces", "([Ljava/lang/StackTraceElement;Ljava/util/ArrayDeque;)V", "exception", "", "recoverAndThrow", "(Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "recoverFromStackFrame", "(Ljava/lang/Throwable;Lkotlin/coroutines/jvm/internal/CoroutineStackFrame;)Ljava/lang/Throwable;", "recoverStackTrace", "(Ljava/lang/Throwable;)Ljava/lang/Throwable;", "Lkotlin/coroutines/Continuation;", "(Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Throwable;", "unwrap", "unwrapImpl", "Lkotlin/Pair;", "causeAndStacktrace", "(Ljava/lang/Throwable;)Lkotlin/Pair;", "e", "", "elementWiseEquals", "(Ljava/lang/StackTraceElement;Ljava/lang/StackTraceElement;)Z", "methodName", "", "frameIndex", "([Ljava/lang/StackTraceElement;Ljava/lang/String;)I", "initCause", "(Ljava/lang/Throwable;Ljava/lang/Throwable;)V", "isArtificial", "(Ljava/lang/StackTraceElement;)Z", "sanitizeStackTrace", "baseContinuationImplClass", "Ljava/lang/String;", "kotlin.jvm.PlatformType", "baseContinuationImplClassName", "stackTraceRecoveryClass", "stackTraceRecoveryClassName", "CoroutineStackFrame", "StackTraceElement", "kotlinx-coroutines-core"})
public final class StackTraceRecoveryKt {
    @NotNull
    private static final String baseContinuationImplClass = "kotlin.coroutines.jvm.internal.BaseContinuationImpl";
    @NotNull
    private static final String stackTraceRecoveryClass = "kotlinx.coroutines.internal.StackTraceRecoveryKt";
    private static final String baseContinuationImplClassName;
    private static final String stackTraceRecoveryClassName;

    @NotNull
    public static final <E extends Throwable> E recoverStackTrace(@NotNull E exception) {
        if (!DebugKt.getRECOVER_STACK_TRACES()) {
            return exception;
        }
        E e = ExceptionsConstuctorKt.tryCopyException(exception);
        if (e == null) {
            return exception;
        }
        E copy2 = e;
        return StackTraceRecoveryKt.sanitizeStackTrace(copy2);
    }

    private static final <E extends Throwable> E sanitizeStackTrace(E $this$sanitizeStackTrace) {
        StackTraceElement[] stackTrace = $this$sanitizeStackTrace.getStackTrace();
        int size = stackTrace.length;
        int lastIntrinsic = StackTraceRecoveryKt.frameIndex(stackTrace, stackTraceRecoveryClassName);
        int startIndex = lastIntrinsic + 1;
        int endIndex = StackTraceRecoveryKt.frameIndex(stackTrace, baseContinuationImplClassName);
        int adjustment = endIndex == -1 ? 0 : size - endIndex;
        int n = size - lastIntrinsic - adjustment;
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            stackTraceElementArray[n2] = n2 == 0 ? StackTraceRecoveryKt.artificialFrame("Coroutine boundary") : stackTrace[startIndex + n2 - 1];
        }
        StackTraceElement[] trace = stackTraceElementArray;
        $this$sanitizeStackTrace.setStackTrace(trace);
        return $this$sanitizeStackTrace;
    }

    @NotNull
    public static final <E extends Throwable> E recoverStackTrace(@NotNull E exception, @NotNull Continuation<?> continuation) {
        boolean $i$f$recoverStackTrace = false;
        if (!DebugKt.getRECOVER_STACK_TRACES() || !(continuation instanceof CoroutineStackFrame)) {
            return exception;
        }
        return (E)StackTraceRecoveryKt.recoverFromStackFrame(exception, (CoroutineStackFrame)((Object)continuation));
    }

    private static final <E extends Throwable> E recoverFromStackFrame(E exception, CoroutineStackFrame continuation) {
        Pair<E, StackTraceElement[]> pair = StackTraceRecoveryKt.causeAndStacktrace(exception);
        E cause = pair.component1();
        StackTraceElement[] recoveredStacktrace = pair.component2();
        E e = ExceptionsConstuctorKt.tryCopyException(cause);
        if (e == null) {
            return exception;
        }
        E newException = e;
        if (!Intrinsics.areEqual(newException.getMessage(), cause.getMessage())) {
            return exception;
        }
        ArrayDeque<StackTraceElement> stacktrace = StackTraceRecoveryKt.createStackTrace(continuation);
        if (stacktrace.isEmpty()) {
            return exception;
        }
        if (cause != exception) {
            StackTraceRecoveryKt.mergeRecoveredTraces(recoveredStacktrace, stacktrace);
        }
        return StackTraceRecoveryKt.createFinalException(cause, newException, stacktrace);
    }

    private static final <E extends Throwable> E createFinalException(E cause, E result2, ArrayDeque<StackTraceElement> resultStackTrace) {
        resultStackTrace.addFirst(StackTraceRecoveryKt.artificialFrame("Coroutine boundary"));
        StackTraceElement[] causeTrace = cause.getStackTrace();
        int size = StackTraceRecoveryKt.frameIndex(causeTrace, baseContinuationImplClassName);
        if (size == -1) {
            Collection $this$toTypedArray$iv = resultStackTrace;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            StackTraceElement[] stackTraceElementArray = thisCollection$iv.toArray(new StackTraceElement[0]);
            if (stackTraceElementArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            result2.setStackTrace(stackTraceElementArray);
            return result2;
        }
        StackTraceElement[] mergedStackTrace = new StackTraceElement[resultStackTrace.size() + size];
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                mergedStackTrace[i] = causeTrace[i];
            } while (n < size);
        }
        Iterator<StackTraceElement> iterator2 = resultStackTrace.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            StackTraceElement element;
            int index2 = n2++;
            mergedStackTrace[size + index2] = element = iterator2.next();
        }
        result2.setStackTrace(mergedStackTrace);
        return result2;
    }

    private static final <E extends Throwable> Pair<E, StackTraceElement[]> causeAndStacktrace(E $this$causeAndStacktrace) {
        Pair<Object, StackTraceElement[]> pair;
        Throwable cause = $this$causeAndStacktrace.getCause();
        if (cause != null && Intrinsics.areEqual(cause.getClass(), $this$causeAndStacktrace.getClass())) {
            boolean bl;
            StackTraceElement[] currentTrace;
            block3: {
                StackTraceElement[] $this$any$iv = currentTrace = $this$causeAndStacktrace.getStackTrace();
                boolean $i$f$any = false;
                StackTraceElement[] stackTraceElementArray = $this$any$iv;
                int n = stackTraceElementArray.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement element$iv;
                    StackTraceElement it = element$iv = stackTraceElementArray[i];
                    boolean bl2 = false;
                    if (!StackTraceRecoveryKt.isArtificial(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            pair = bl ? TuplesKt.to(cause, currentTrace) : TuplesKt.to($this$causeAndStacktrace, new StackTraceElement[0]);
        } else {
            pair = TuplesKt.to($this$causeAndStacktrace, new StackTraceElement[0]);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private static final void mergeRecoveredTraces(StackTraceElement[] recoveredStacktrace, ArrayDeque<StackTraceElement> result2) {
        int lastFrameIndex;
        int n;
        block5: {
            StackTraceElement[] $this$indexOfFirst$iv = recoveredStacktrace;
            boolean $i$f$indexOfFirst = false;
            int n2 = 0;
            int n3 = $this$indexOfFirst$iv.length;
            while (n2 < n3) {
                void index$iv;
                StackTraceElement it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (StackTraceRecoveryKt.isArtificial(it)) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = -1;
        }
        int startIndex = n + 1;
        int n4 = lastFrameIndex = recoveredStacktrace.length - 1;
        if (startIndex <= n4) {
            int i;
            do {
                StackTraceElement element;
                if (StackTraceRecoveryKt.elementWiseEquals(element = recoveredStacktrace[i = n4--], result2.getLast())) {
                    result2.removeLast();
                }
                result2.addFirst(recoveredStacktrace[i]);
            } while (i != startIndex);
        }
    }

    @Nullable
    public static final Object recoverAndThrow(@NotNull Throwable exception, @NotNull Continuation<?> $completion) {
        boolean $i$f$recoverAndThrow = false;
        if (!DebugKt.getRECOVER_STACK_TRACES()) {
            throw exception;
        }
        Continuation<?> it = $completion;
        boolean bl = false;
        if (!(it instanceof CoroutineStackFrame)) {
            throw exception;
        }
        throw StackTraceRecoveryKt.recoverFromStackFrame(exception, (CoroutineStackFrame)((Object)it));
    }

    private static final Object recoverAndThrow$$forInline(Throwable exception, Continuation<?> $completion) {
        boolean $i$f$recoverAndThrow = false;
        if (!DebugKt.getRECOVER_STACK_TRACES()) {
            throw exception;
        }
        InlineMarker.mark(0);
        Continuation<?> it = $completion;
        boolean bl = false;
        if (!(it instanceof CoroutineStackFrame)) {
            throw exception;
        }
        throw StackTraceRecoveryKt.recoverFromStackFrame(exception, (CoroutineStackFrame)((Object)it));
    }

    @NotNull
    public static final <E extends Throwable> E unwrap(@NotNull E exception) {
        boolean $i$f$unwrap = false;
        return !DebugKt.getRECOVER_STACK_TRACES() ? exception : StackTraceRecoveryKt.unwrapImpl(exception);
    }

    @NotNull
    public static final <E extends Throwable> E unwrapImpl(@NotNull E exception) {
        boolean bl;
        Throwable cause;
        block3: {
            cause = exception.getCause();
            if (cause == null || !Intrinsics.areEqual(cause.getClass(), exception.getClass())) {
                return exception;
            }
            StackTraceElement[] $this$any$iv = exception.getStackTrace();
            boolean $i$f$any = false;
            StackTraceElement[] stackTraceElementArray = $this$any$iv;
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement element$iv;
                StackTraceElement it = element$iv = stackTraceElementArray[i];
                boolean bl2 = false;
                if (!StackTraceRecoveryKt.isArtificial(it)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            return (E)cause;
        }
        return exception;
    }

    private static final ArrayDeque<StackTraceElement> createStackTrace(CoroutineStackFrame continuation) {
        Object object;
        ArrayDeque<StackTraceElement> stack = new ArrayDeque<StackTraceElement>();
        StackTraceElement stackTraceElement = continuation.getStackTraceElement();
        if (stackTraceElement != null) {
            object = stackTraceElement;
            boolean bl = false;
            boolean bl2 = false;
            StackTraceElement it = object;
            boolean bl3 = false;
            stack.add(it);
        }
        Object last2 = continuation;
        while (true) {
            CoroutineStackFrame coroutineStackFrame;
            Object object2 = (coroutineStackFrame = last2) instanceof CoroutineStackFrame ? coroutineStackFrame : null;
            Object object3 = object = object2 == null ? null : object2.getCallerFrame();
            if (object == null) break;
            last2 = object;
            if ((object = last2.getStackTraceElement()) == null) continue;
            object2 = object;
            boolean bl = false;
            boolean bl4 = false;
            Object it = object2;
            boolean bl5 = false;
            stack.add((StackTraceElement)it);
        }
        return stack;
    }

    @InternalCoroutinesApi
    @NotNull
    public static final StackTraceElement artificialFrame(@NotNull String message) {
        return new StackTraceElement(Intrinsics.stringPlus("\b\b\b(", message), "\b", "\b", -1);
    }

    public static final boolean isArtificial(@NotNull StackTraceElement $this$isArtificial) {
        return StringsKt.startsWith$default($this$isArtificial.getClassName(), "\b\b\b", false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final int frameIndex(StackTraceElement[] $this$frameIndex, String methodName) {
        int n;
        block2: {
            StackTraceElement[] $this$indexOfFirst$iv = $this$frameIndex;
            boolean $i$f$indexOfFirst = false;
            int n2 = 0;
            int n3 = $this$indexOfFirst$iv.length;
            while (n2 < n3) {
                void index$iv;
                StackTraceElement it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (Intrinsics.areEqual(methodName, it.getClassName())) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    private static final boolean elementWiseEquals(StackTraceElement $this$elementWiseEquals, StackTraceElement e) {
        return $this$elementWiseEquals.getLineNumber() == e.getLineNumber() && Intrinsics.areEqual($this$elementWiseEquals.getMethodName(), e.getMethodName()) && Intrinsics.areEqual($this$elementWiseEquals.getFileName(), e.getFileName()) && Intrinsics.areEqual($this$elementWiseEquals.getClassName(), e.getClassName());
    }

    public static final void initCause(@NotNull Throwable $this$initCause, @NotNull Throwable cause) {
        $this$initCause.initCause(cause);
    }

    public static /* synthetic */ void CoroutineStackFrame$annotations() {
    }

    public static /* synthetic */ void StackTraceElement$annotations() {
    }

    static {
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        Object object4;
        boolean bl2 = false;
        try {
            object4 = Result.Companion;
            boolean $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322 = false;
            String $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322 = Class.forName(baseContinuationImplClass).getCanonicalName();
            boolean bl3 = false;
            object4 = Result.constructor-impl($i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322);
        }
        catch (Throwable $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object4 = Result.constructor-impl(ResultKt.createFailure($i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322));
        }
        Object object5 = object4;
        boolean bl5 = false;
        boolean $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322 = false;
        Throwable $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322 = Result.exceptionOrNull-impl(object5);
        if ($i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322 == null) {
            object3 = object5;
        } else {
            Throwable it = $i$a$-runCatching-StackTraceRecoveryKt$baseContinuationImplClassName$322;
            bl = false;
            object3 = baseContinuationImplClass;
        }
        baseContinuationImplClassName = (String)object3;
        boolean bl6 = false;
        try {
            object2 = Result.Companion;
            boolean bl7 = false;
            String string = Class.forName(stackTraceRecoveryClass).getCanonicalName();
            boolean it = false;
            object2 = Result.constructor-impl(string);
        }
        catch (Throwable throwable) {
            Result.Companion it = Result.Companion;
            bl = false;
            object2 = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        Object object6 = object2;
        boolean bl8 = false;
        boolean bl9 = false;
        Throwable throwable = Result.exceptionOrNull-impl(object6);
        if (throwable == null) {
            object = object6;
        } else {
            Throwable it = throwable;
            boolean bl10 = false;
            object = stackTraceRecoveryClass;
        }
        stackTraceRecoveryClassName = (String)object;
    }
}

