/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.SignatureSerializer;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.annotations.NotNull;

final class ReflectClassStructure {
    @NotNull
    public static final ReflectClassStructure INSTANCE = new ReflectClassStructure();

    private ReflectClassStructure() {
    }

    public final void loadClassAnnotations(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor2) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        Annotation[] annotationArray = klass.getDeclaredAnnotations();
        Intrinsics.checkNotNullExpressionValue(annotationArray, "klass.declaredAnnotations");
        for (Annotation annotation2 : annotationArray) {
            Intrinsics.checkNotNullExpressionValue(annotation2, "annotation");
            this.processAnnotation(visitor2, annotation2);
        }
        visitor2.visitEnd();
    }

    public final void visitMembers(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(memberVisitor, "memberVisitor");
        this.loadMethodAnnotations(klass, memberVisitor);
        this.loadConstructorAnnotations(klass, memberVisitor);
        this.loadFieldAnnotations(klass, memberVisitor);
    }

    private final void loadMethodAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Method[] methodArray = klass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue(methodArray, "klass.declaredMethods");
        Method[] methodArray2 = methodArray;
        int n = 0;
        int n2 = methodArray2.length;
        while (n < n2) {
            Method method = methodArray2[n];
            ++n;
            Annotation[] annotationArray = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue(annotationArray, "identifier(method.name)");
            Intrinsics.checkNotNullExpressionValue(method, "method");
            Annotation[] annotationArray2 = memberVisitor.visitMethod((Name)annotationArray, SignatureSerializer.INSTANCE.methodDesc(method));
            if (annotationArray2 == null) continue;
            Annotation[] visitor2 = annotationArray2;
            annotationArray = method.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue(annotationArray, "method.declaredAnnotations");
            for (Annotation annotation2 : annotationArray) {
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = (KotlinJvmBinaryClass.AnnotationVisitor)visitor2;
                Intrinsics.checkNotNullExpressionValue(annotation2, "annotation");
                this.processAnnotation(annotationVisitor, annotation2);
            }
            Annotation[][] annotationArray3 = method.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue(annotationArray3, "method.parameterAnnotations");
            annotationArray2 = annotationArray3;
            int n3 = 0;
            int n4 = ((Object[])annotationArray2).length;
            while (n3 < n4) {
                int parameterIndex = n3;
                Annotation annotations2 = annotationArray2[n3];
                ++n3;
                Intrinsics.checkNotNullExpressionValue(annotations2, "annotations");
                for (Annotation annotation3 : annotations2) {
                    Class<KClass<Annotation>> annotationType = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(annotation3));
                    ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                    Intrinsics.checkNotNullExpressionValue(annotation3, "annotation");
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitParameterAnnotation(parameterIndex, classId, new ReflectAnnotationSource(annotation3));
                    if (annotationArgumentVisitor == null) continue;
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = annotationArgumentVisitor;
                    boolean bl = false;
                    boolean bl2 = false;
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor2;
                    boolean bl3 = false;
                    INSTANCE.processAnnotationArguments(it, annotation3, annotationType);
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Constructor<?>[] constructorArray = klass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, "klass.declaredConstructors");
        Constructor<?>[] constructorArray2 = constructorArray;
        int n = 0;
        int n2 = constructorArray2.length;
        while (n < n2) {
            Constructor<?> constructor = constructorArray2[n];
            ++n;
            Annotation[] annotationArray = Name.special("<init>");
            Intrinsics.checkNotNullExpressionValue(annotationArray, "special(\"<init>\")");
            Intrinsics.checkNotNullExpressionValue(constructor, "constructor");
            Annotation[] annotationArray2 = memberVisitor.visitMethod((Name)annotationArray, SignatureSerializer.INSTANCE.constructorDesc(constructor));
            if (annotationArray2 == null) continue;
            Annotation[] visitor2 = annotationArray2;
            annotationArray = constructor.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue(annotationArray, "constructor.declaredAnnotations");
            for (Annotation annotation2 : annotationArray) {
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = (KotlinJvmBinaryClass.AnnotationVisitor)visitor2;
                Intrinsics.checkNotNullExpressionValue(annotation2, "annotation");
                this.processAnnotation(annotationVisitor, annotation2);
            }
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue(parameterAnnotations, "parameterAnnotations");
            Object[] objectArray = (Object[])parameterAnnotations;
            int n3 = 0;
            Object[] objectArray2 = objectArray;
            int n4 = 0;
            if (!(objectArray2.length == 0)) {
                int shift = constructor.getParameterTypes().length - ((Object[])parameterAnnotations).length;
                Annotation[][] annotationArray3 = parameterAnnotations;
                int n5 = 0;
                n4 = ((Object[])annotationArray3).length;
                while (n5 < n4) {
                    int parameterIndex = n5;
                    Annotation[] annotations2 = annotationArray3[n5];
                    ++n5;
                    Intrinsics.checkNotNullExpressionValue(annotations2, "annotations");
                    for (Annotation annotation3 : annotations2) {
                        Class<KClass<Annotation>> annotationType = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(annotation3));
                        ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                        Intrinsics.checkNotNullExpressionValue(annotation3, "annotation");
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitParameterAnnotation(parameterIndex + shift, classId, new ReflectAnnotationSource(annotation3));
                        if (annotationArgumentVisitor == null) continue;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = annotationArgumentVisitor;
                        boolean bl = false;
                        boolean bl2 = false;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor2;
                        boolean bl3 = false;
                        INSTANCE.processAnnotationArguments(it, annotation3, annotationType);
                    }
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Field[] fieldArray = klass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue(fieldArray, "klass.declaredFields");
        Field[] fieldArray2 = fieldArray;
        int n = 0;
        int n2 = fieldArray2.length;
        while (n < n2) {
            Field field2 = fieldArray2[n];
            ++n;
            Annotation[] annotationArray = Name.identifier(field2.getName());
            Intrinsics.checkNotNullExpressionValue(annotationArray, "identifier(field.name)");
            Intrinsics.checkNotNullExpressionValue(field2, "field");
            Annotation[] annotationArray2 = memberVisitor.visitField((Name)annotationArray, SignatureSerializer.INSTANCE.fieldDesc(field2), null);
            if (annotationArray2 == null) continue;
            Annotation[] visitor2 = annotationArray2;
            annotationArray = field2.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue(annotationArray, "field.declaredAnnotations");
            for (Annotation annotation2 : annotationArray) {
                Intrinsics.checkNotNullExpressionValue(annotation2, "annotation");
                this.processAnnotation((KotlinJvmBinaryClass.AnnotationVisitor)visitor2, annotation2);
            }
            visitor2.visitEnd();
        }
    }

    private final void processAnnotation(KotlinJvmBinaryClass.AnnotationVisitor visitor2, Annotation annotation2) {
        Class<KClass<Annotation>> annotationType = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(annotation2));
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(ReflectClassUtilKt.getClassId(annotationType), new ReflectAnnotationSource(annotation2));
        if (annotationArgumentVisitor != null) {
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = annotationArgumentVisitor;
            boolean bl = false;
            boolean bl2 = false;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor2;
            boolean bl3 = false;
            INSTANCE.processAnnotationArguments(it, annotation2, annotationType);
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Annotation annotation2, Class<?> annotationType) {
        Method[] methodArray = annotationType.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue(methodArray, "annotationType.declaredMethods");
        for (Method method : methodArray) {
            Object object;
            try {
                Object object2 = method.invoke((Object)annotation2, new Object[0]);
                Intrinsics.checkNotNull(object2);
                object = object2;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            Object value2 = object;
            object = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue(object, "identifier(method.name)");
            this.processAnnotationArgumentValue(visitor2, (Name)object, value2);
        }
        visitor2.visitEnd();
    }

    private final ClassLiteralValue classLiteralValue(Class<?> $this$classLiteralValue) {
        Object object;
        Class<?> currentClass = $this$classLiteralValue;
        int dimensions = 0;
        while (currentClass.isArray()) {
            int n = dimensions;
            dimensions = n + 1;
            object = currentClass.getComponentType();
            Intrinsics.checkNotNullExpressionValue(object, "currentClass.componentType");
            currentClass = object;
        }
        if (currentClass.isPrimitive()) {
            if (Intrinsics.areEqual(currentClass, Void.TYPE)) {
                object = ClassId.topLevel(StandardNames.FqNames.unit.toSafe());
                Intrinsics.checkNotNullExpressionValue(object, "topLevel(StandardNames.FqNames.unit.toSafe())");
                return new ClassLiteralValue((ClassId)object, dimensions);
            }
            Object object2 = JvmPrimitiveType.get(currentClass.getName()).getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue(object2, "get(currentClass.name).primitiveType");
            PrimitiveType primitiveType = object2;
            if (dimensions > 0) {
                object2 = ClassId.topLevel(primitiveType.getArrayTypeFqName());
                Intrinsics.checkNotNullExpressionValue(object2, "topLevel(primitiveType.arrayTypeFqName)");
                return new ClassLiteralValue((ClassId)object2, dimensions - 1);
            }
            object2 = ClassId.topLevel(primitiveType.getTypeFqName());
            Intrinsics.checkNotNullExpressionValue(object2, "topLevel(primitiveType.typeFqName)");
            return new ClassLiteralValue((ClassId)object2, dimensions);
        }
        ClassId javaClassId = ReflectClassUtilKt.getClassId(currentClass);
        FqName fqName2 = javaClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "javaClassId.asSingleFqName()");
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName2);
        ClassId kotlinClassId = classId == null ? javaClassId : classId;
        return new ClassLiteralValue(kotlinClassId, dimensions);
    }

    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Name name, Object value2) {
        Class<?> clazz = value2.getClass();
        if (Intrinsics.areEqual(clazz, Class.class)) {
            visitor2.visitClassLiteral(name, this.classLiteralValue((Class)value2));
        } else if (ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p().contains(clazz)) {
            visitor2.visit(name, value2);
        } else if (ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            Object object = clazz.isEnum() ? clazz : clazz.getEnclosingClass();
            Intrinsics.checkNotNullExpressionValue(object, "if (clazz.isEnum) clazz else clazz.enclosingClass");
            ClassId classId = ReflectClassUtilKt.getClassId(object);
            object = Name.identifier(((Enum)value2).name());
            Intrinsics.checkNotNullExpressionValue(object, "identifier((value as Enum<*>).name)");
            visitor2.visitEnum(name, classId, (Name)object);
        } else if (Annotation.class.isAssignableFrom(clazz)) {
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, "clazz.interfaces");
            Class annotationClass = (Class)ArraysKt.single((Object[])classArray);
            Intrinsics.checkNotNullExpressionValue(annotationClass, "annotationClass");
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(name, ReflectClassUtilKt.getClassId(annotationClass));
            if (annotationArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArgumentVisitor v = annotationArgumentVisitor;
            this.processAnnotationArguments(v, (Annotation)value2, annotationClass);
        } else if (clazz.isArray()) {
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v = visitor2.visitArray(name);
            if (v == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v2 = v;
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isEnum()) {
                Intrinsics.checkNotNullExpressionValue(componentType, "componentType");
                ClassId enumClassId = ReflectClassUtilKt.getClassId(componentType);
                for (Object element : (Object[])value2) {
                    if (element == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Enum<*>");
                    }
                    Name name2 = Name.identifier(((Enum)element).name());
                    Intrinsics.checkNotNullExpressionValue(name2, "identifier((element as Enum<*>).name)");
                    v2.visitEnum(enumClassId, name2);
                }
            } else if (Intrinsics.areEqual(componentType, Class.class)) {
                for (Object element : (Object[])value2) {
                    if (element == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
                    }
                    v2.visitClassLiteral(this.classLiteralValue((Class)element));
                }
            } else if (Annotation.class.isAssignableFrom(componentType)) {
                for (Object element : (Object[])value2) {
                    Intrinsics.checkNotNullExpressionValue(componentType, "componentType");
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = v2.visitAnnotation(ReflectClassUtilKt.getClassId(componentType));
                    if (annotationArgumentVisitor == null) continue;
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor vv = annotationArgumentVisitor;
                    if (element == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Annotation");
                    }
                    this.processAnnotationArguments(vv, (Annotation)element, componentType);
                }
            } else {
                for (Object element : (Object[])value2) {
                    v2.visit(element);
                }
            }
            v2.visitEnd();
        } else {
            throw new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + value2);
        }
    }
}

