/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.KClassImpl;
import kotlin.reflect.jvm.internal.pcollections.HashPMap;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000(\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u000f\u0010\u0001\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0001\u0010\u0002\u001a-\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\"\b\b\u0000\u0010\u0004*\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0000\u00a2\u0006\u0004\b\b\u0010\t\"2\u0010\r\u001a\u001e\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00030\u00030\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"", "clearKClassCache", "()V", "", "T", "Ljava/lang/Class;", "jClass", "Lkotlin/reflect/jvm/internal/KClassImpl;", "getOrCreateKotlinClass", "(Ljava/lang/Class;)Lkotlin/reflect/jvm/internal/KClassImpl;", "Lkotlin/reflect/jvm/internal/pcollections/HashPMap;", "", "kotlin.jvm.PlatformType", "K_CLASS_CACHE", "Lkotlin/reflect/jvm/internal/pcollections/HashPMap;", "kotlin-reflection"})
public final class KClassCacheKt {
    private static HashPMap<String, Object> K_CLASS_CACHE;

    @NotNull
    public static final <T> KClassImpl<T> getOrCreateKotlinClass(@NotNull Class<T> jClass) {
        Intrinsics.checkNotNullParameter(jClass, "jClass");
        String name = jClass.getName();
        Object cached = K_CLASS_CACHE.get(name);
        if (cached instanceof WeakReference) {
            KClassImpl kClass;
            KClassImpl kClassImpl = kClass = (KClassImpl)((WeakReference)cached).get();
            if (Intrinsics.areEqual(kClassImpl != null ? kClassImpl.getJClass() : null, jClass)) {
                return kClass;
            }
        } else if (cached != null) {
            WeakReference[] cfr_ignored_0 = (WeakReference[])cached;
            for (WeakReference ref : (WeakReference[])cached) {
                KClassImpl kClass;
                KClassImpl kClassImpl = kClass = (KClassImpl)ref.get();
                if (!Intrinsics.areEqual(kClassImpl != null ? kClassImpl.getJClass() : null, jClass)) continue;
                return kClass;
            }
            int size = ((Object[])cached).length;
            WeakReference[] newArray = new WeakReference[size + 1];
            System.arraycopy(cached, 0, newArray, 0, size);
            KClassImpl<T> newKClass = new KClassImpl<T>(jClass);
            newArray[size] = new WeakReference<KClassImpl<T>>(newKClass);
            HashPMap<String, Object> hashPMap = K_CLASS_CACHE.plus(name, newArray);
            Intrinsics.checkNotNullExpressionValue(hashPMap, "K_CLASS_CACHE.plus(name, newArray)");
            K_CLASS_CACHE = hashPMap;
            return newKClass;
        }
        KClassImpl<T> newKClass = new KClassImpl<T>(jClass);
        HashPMap<String, WeakReference<KClassImpl<T>>> hashPMap = K_CLASS_CACHE.plus(name, new WeakReference<KClassImpl<T>>(newKClass));
        Intrinsics.checkNotNullExpressionValue(hashPMap, "K_CLASS_CACHE.plus(name, WeakReference(newKClass))");
        K_CLASS_CACHE = hashPMap;
        return newKClass;
    }

    public static final void clearKClassCache() {
        HashPMap hashPMap = HashPMap.empty();
        Intrinsics.checkNotNullExpressionValue(hashPMap, "HashPMap.empty()");
        K_CLASS_CACHE = hashPMap;
    }

    static {
        HashPMap hashPMap = HashPMap.empty();
        Intrinsics.checkNotNullExpressionValue(hashPMap, "HashPMap.empty<String, Any>()");
        K_CLASS_CACHE = hashPMap;
    }
}

