/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections.builders;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.builders.ListBuilderKt;
import kotlin.collections.builders.MapBuilderEntries;
import kotlin.collections.builders.MapBuilderKeys;
import kotlin.collections.builders.MapBuilderValues;
import kotlin.collections.builders.SerializedMap;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010&\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 \u008d\u0001*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00032\u00060\u0004j\u0002`\u0005:\f\u008d\u0001\u008e\u0001\u008f\u0001\u0090\u0001\u0091\u0001\u0092\u0001B\n\b\u0016\u00a2\u0006\u0005\b\u008a\u0001\u0010\u0013B\u0013\b\u0016\u0012\u0007\u0010\u008b\u0001\u001a\u00020\u0007\u00a2\u0006\u0005\b\u008a\u0001\u0010+BJ\b\u0002\u0012\f\u0010x\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u000f\u0010\u0086\u0001\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000b\u0012\u0006\u0010\u007f\u001a\u00020k\u0012\u0006\u0010l\u001a\u00020k\u0012\u0006\u0010~\u001a\u00020\u0007\u0012\u0006\u0010}\u001a\u00020\u0007\u00a2\u0006\u0006\b\u008a\u0001\u0010\u008c\u0001J\u0017\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0014\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u000f\u0010\u0016\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0013J\u001b\u0010\u001c\u001a\u00020\u00192\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ#\u0010!\u001a\u00020\u00192\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001dH\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u00192\u0006\u0010$\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b%\u0010#J\u001f\u0010'\u001a\u00020\u00192\u000e\u0010&\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eH\u0002\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b-\u0010+J\u001b\u00101\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010.H\u0000\u00a2\u0006\u0004\b/\u00100J\u001a\u00103\u001a\u00020\u00192\b\u0010&\u001a\u0004\u0018\u000102H\u0096\u0002\u00a2\u0006\u0004\b3\u0010#J\u0017\u00104\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b4\u0010\tJ\u0017\u00105\u001a\u00020\u00072\u0006\u0010$\u001a\u00028\u0001H\u0002\u00a2\u0006\u0004\b5\u0010\tJ\u001a\u00106\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0006\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b6\u00107J\u0017\u00108\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b8\u0010\tJ\u000f\u00109\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b9\u0010:J\u000f\u0010;\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b;\u0010<J\u001b\u0010@\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010=H\u0000\u00a2\u0006\u0004\b>\u0010?J!\u0010A\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0006\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\bA\u0010BJ%\u0010D\u001a\u00020\u00112\u0014\u0010C\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000eH\u0016\u00a2\u0006\u0004\bD\u0010EJ)\u0010F\u001a\u00020\u00192\u0018\u0010C\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001d0\u0017H\u0002\u00a2\u0006\u0004\bF\u0010\u001bJ#\u0010G\u001a\u00020\u00192\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001dH\u0002\u00a2\u0006\u0004\bG\u0010 J\u0017\u0010I\u001a\u00020\u00192\u0006\u0010H\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\bI\u0010JJ\u0017\u0010L\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\bL\u0010+J\u0019\u0010M\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0006\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\bM\u00107J#\u0010O\u001a\u00020\u00192\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001dH\u0000\u00a2\u0006\u0004\bN\u0010 J\u0017\u0010Q\u001a\u00020\u00112\u0006\u0010P\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\bQ\u0010+J\u0017\u0010S\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\bR\u0010\tJ\u0017\u0010U\u001a\u00020\u00112\u0006\u0010T\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\bU\u0010+J\u0017\u0010X\u001a\u00020\u00192\u0006\u0010V\u001a\u00028\u0001H\u0000\u00a2\u0006\u0004\bW\u0010#J\u000f\u0010Z\u001a\u00020YH\u0016\u00a2\u0006\u0004\bZ\u0010[J\u001b\u0010_\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\\H\u0000\u00a2\u0006\u0004\b]\u0010^J\u000f\u0010`\u001a\u000202H\u0002\u00a2\u0006\u0004\b`\u0010aR\u0014\u0010)\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bb\u0010:R&\u0010g\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010d0c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\be\u0010fR$\u0010i\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010h8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bi\u0010jR\u0016\u0010l\u001a\u00020k8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bl\u0010mR\u0016\u0010n\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bn\u0010oR\u0014\u0010q\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bp\u0010:R$\u0010s\u001a\u00020\u00192\u0006\u0010r\u001a\u00020\u00198\u0000@BX\u0080\u000e\u00a2\u0006\f\n\u0004\bs\u0010t\u001a\u0004\bu\u0010<R\u001a\u0010w\u001a\b\u0012\u0004\u0012\u00028\u00000c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bv\u0010fR\u001c\u0010x\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bx\u0010yR\u001e\u0010{\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010z8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b{\u0010|R\u0016\u0010}\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b}\u0010oR\u0016\u0010~\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b~\u0010oR\u0016\u0010\u007f\u001a\u00020k8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u007f\u0010mR'\u0010\u0080\u0001\u001a\u00020\u00072\u0006\u0010r\u001a\u00020\u00078\u0016@RX\u0096\u000e\u00a2\u0006\u000e\n\u0005\b\u0080\u0001\u0010o\u001a\u0005\b\u0081\u0001\u0010:R\u001e\u0010\u0085\u0001\u001a\t\u0012\u0004\u0012\u00028\u00010\u0082\u00018VX\u0096\u0004\u00a2\u0006\b\u001a\u0006\b\u0083\u0001\u0010\u0084\u0001R \u0010\u0086\u0001\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0007\n\u0005\b\u0086\u0001\u0010yR\"\u0010\u0088\u0001\u001a\u000b\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0087\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0088\u0001\u0010\u0089\u0001\u00a8\u0006\u0093\u0001"}, d2={"Lkotlin/collections/builders/MapBuilder;", "K", "V", "", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "key", "", "addKey$kotlin_stdlib", "(Ljava/lang/Object;)I", "addKey", "", "allocateValuesArray", "()[Ljava/lang/Object;", "", "build", "()Ljava/util/Map;", "", "checkIsMutable$kotlin_stdlib", "()V", "checkIsMutable", "clear", "compact", "", "m", "", "containsAllEntries$kotlin_stdlib", "(Ljava/util/Collection;)Z", "containsAllEntries", "", "entry", "containsEntry$kotlin_stdlib", "(Ljava/util/Map$Entry;)Z", "containsEntry", "containsKey", "(Ljava/lang/Object;)Z", "value", "containsValue", "other", "contentEquals", "(Ljava/util/Map;)Z", "capacity", "ensureCapacity", "(I)V", "n", "ensureExtraCapacity", "Lkotlin/collections/builders/MapBuilder$EntriesItr;", "entriesIterator$kotlin_stdlib", "()Lkotlin/collections/builders/MapBuilder$EntriesItr;", "entriesIterator", "", "equals", "findKey", "findValue", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "hash", "hashCode", "()I", "isEmpty", "()Z", "Lkotlin/collections/builders/MapBuilder$KeysItr;", "keysIterator$kotlin_stdlib", "()Lkotlin/collections/builders/MapBuilder$KeysItr;", "keysIterator", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "from", "putAll", "(Ljava/util/Map;)V", "putAllEntries", "putEntry", "i", "putRehash", "(I)Z", "newHashSize", "rehash", "remove", "removeEntry$kotlin_stdlib", "removeEntry", "removedHash", "removeHashAt", "removeKey$kotlin_stdlib", "removeKey", "index", "removeKeyAt", "element", "removeValue$kotlin_stdlib", "removeValue", "", "toString", "()Ljava/lang/String;", "Lkotlin/collections/builders/MapBuilder$ValuesItr;", "valuesIterator$kotlin_stdlib", "()Lkotlin/collections/builders/MapBuilder$ValuesItr;", "valuesIterator", "writeReplace", "()Ljava/lang/Object;", "getCapacity", "", "", "getEntries", "()Ljava/util/Set;", "entries", "Lkotlin/collections/builders/MapBuilderEntries;", "entriesView", "Lkotlin/collections/builders/MapBuilderEntries;", "", "hashArray", "[I", "hashShift", "I", "getHashSize", "hashSize", "<set-?>", "isReadOnly", "Z", "isReadOnly$kotlin_stdlib", "getKeys", "keys", "keysArray", "[Ljava/lang/Object;", "Lkotlin/collections/builders/MapBuilderKeys;", "keysView", "Lkotlin/collections/builders/MapBuilderKeys;", "length", "maxProbeDistance", "presenceArray", "size", "getSize", "", "getValues", "()Ljava/util/Collection;", "values", "valuesArray", "Lkotlin/collections/builders/MapBuilderValues;", "valuesView", "Lkotlin/collections/builders/MapBuilderValues;", "<init>", "initialCapacity", "([Ljava/lang/Object;[Ljava/lang/Object;[I[III)V", "Companion", "EntriesItr", "EntryRef", "Itr", "KeysItr", "ValuesItr", "kotlin-stdlib"})
public final class MapBuilder<K, V>
implements Map<K, V>,
Serializable,
KMutableMap {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private K[] keysArray;
    @Nullable
    private V[] valuesArray;
    @NotNull
    private int[] presenceArray;
    @NotNull
    private int[] hashArray;
    private int maxProbeDistance;
    private int length;
    private int hashShift;
    private int size;
    @Nullable
    private MapBuilderKeys<K> keysView;
    @Nullable
    private MapBuilderValues<V> valuesView;
    @Nullable
    private MapBuilderEntries<K, V> entriesView;
    private boolean isReadOnly;
    @Deprecated
    private static final int MAGIC = -1640531527;
    @Deprecated
    private static final int INITIAL_CAPACITY = 8;
    @Deprecated
    private static final int INITIAL_MAX_PROBE_DISTANCE = 2;
    @Deprecated
    private static final int TOMBSTONE = -1;

    private MapBuilder(K[] keysArray, V[] valuesArray, int[] presenceArray, int[] hashArray, int maxProbeDistance, int length) {
        this.keysArray = keysArray;
        this.valuesArray = valuesArray;
        this.presenceArray = presenceArray;
        this.hashArray = hashArray;
        this.maxProbeDistance = maxProbeDistance;
        this.length = length;
        this.hashShift = MapBuilder.Companion.computeShift(this.getHashSize());
    }

    public int getSize() {
        return this.size;
    }

    public final boolean isReadOnly$kotlin_stdlib() {
        return this.isReadOnly;
    }

    public MapBuilder() {
        this(8);
    }

    public MapBuilder(int initialCapacity) {
        this(ListBuilderKt.arrayOfUninitializedElements(initialCapacity), null, new int[initialCapacity], new int[MapBuilder.Companion.computeHashSize(initialCapacity)], 2, 0);
    }

    @NotNull
    public final Map<K, V> build() {
        this.checkIsMutable$kotlin_stdlib();
        this.isReadOnly = true;
        return this;
    }

    private final Object writeReplace() {
        if (!this.isReadOnly) {
            throw new NotSerializableException("The map cannot be serialized while it is being built.");
        }
        return new SerializedMap(this);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findKey(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.findValue(value2) >= 0;
    }

    @Override
    @Nullable
    public V get(Object key) {
        int index2 = this.findKey(key);
        if (index2 < 0) {
            return null;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        return this.valuesArray[index2];
    }

    @Override
    @Nullable
    public V put(K key, V value2) {
        this.checkIsMutable$kotlin_stdlib();
        int index2 = this.addKey$kotlin_stdlib(key);
        V[] valuesArray = this.allocateValuesArray();
        if (index2 < 0) {
            V oldValue = valuesArray[-index2 - 1];
            valuesArray[-index2 - 1] = value2;
            return oldValue;
        }
        valuesArray[index2] = value2;
        return null;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from2) {
        Intrinsics.checkNotNullParameter(from2, "from");
        this.checkIsMutable$kotlin_stdlib();
        this.putAllEntries((Collection)from2.entrySet());
    }

    @Override
    @Nullable
    public V remove(Object key) {
        int index2 = this.removeKey$kotlin_stdlib(key);
        if (index2 < 0) {
            return null;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        V[] valuesArray = this.valuesArray;
        V oldValue = valuesArray[index2];
        ListBuilderKt.resetAt(valuesArray, index2);
        return oldValue;
    }

    @Override
    public void clear() {
        this.checkIsMutable$kotlin_stdlib();
        int n = 0;
        int n2 = this.length - 1;
        if (n <= n2) {
            int i;
            do {
                int hash;
                if ((hash = this.presenceArray[i = n++]) < 0) continue;
                this.hashArray[hash] = 0;
                this.presenceArray[i] = -1;
            } while (i != n2);
        }
        ListBuilderKt.resetRange(this.keysArray, 0, this.length);
        V[] VArray = this.valuesArray;
        if (VArray != null) {
            ListBuilderKt.resetRange(VArray, 0, this.length);
        }
        this.size = 0;
        this.length = 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<K> getKeys() {
        Set set;
        MapBuilderKeys<K> cur = this.keysView;
        if (cur == null) {
            void var2_2;
            MapBuilderKeys mapBuilderKeys = new MapBuilderKeys(this);
            this.keysView = mapBuilderKeys;
            set = (Set)var2_2;
        } else {
            set = cur;
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<V> getValues() {
        Collection collection;
        MapBuilderValues<V> cur = this.valuesView;
        if (cur == null) {
            void var2_2;
            MapBuilderValues mapBuilderValues = new MapBuilderValues(this);
            this.valuesView = mapBuilderValues;
            collection = (Collection)var2_2;
        } else {
            collection = cur;
        }
        return collection;
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        MapBuilderEntries<K, V> cur = this.entriesView;
        if (cur == null) {
            MapBuilderEntries mapBuilderEntries = new MapBuilderEntries(this);
            this.entriesView = mapBuilderEntries;
            return mapBuilderEntries;
        }
        return cur;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof Map && this.contentEquals((Map)other);
    }

    @Override
    public int hashCode() {
        int result2 = 0;
        EntriesItr<K, V> it = this.entriesIterator$kotlin_stdlib();
        while (it.hasNext()) {
            result2 += it.nextHashCode$kotlin_stdlib();
        }
        return result2;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder(2 + this.size() * 3);
        sb.append("{");
        int i = 0;
        EntriesItr<K, V> it = this.entriesIterator$kotlin_stdlib();
        while (it.hasNext()) {
            if (i > 0) {
                sb.append(", ");
            }
            it.nextAppendString(sb);
            int n = i;
            i = n + 1;
        }
        sb.append("}");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    private final int getCapacity() {
        return this.keysArray.length;
    }

    private final int getHashSize() {
        return this.hashArray.length;
    }

    public final void checkIsMutable$kotlin_stdlib() {
        if (this.isReadOnly) {
            throw new UnsupportedOperationException();
        }
    }

    private final void ensureExtraCapacity(int n) {
        this.ensureCapacity(this.length + n);
    }

    private final void ensureCapacity(int capacity) {
        if (capacity < 0) {
            throw new OutOfMemoryError();
        }
        if (capacity > this.getCapacity()) {
            int newSize = this.getCapacity() * 3 / 2;
            if (capacity > newSize) {
                newSize = capacity;
            }
            this.keysArray = ListBuilderKt.copyOfUninitializedElements(this.keysArray, newSize);
            Object[] objectArray = this.valuesArray;
            this.valuesArray = objectArray == null ? null : ListBuilderKt.copyOfUninitializedElements(objectArray, newSize);
            objectArray = this.presenceArray;
            int[] nArray = Arrays.copyOf(objectArray, newSize);
            Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(this, newSize)");
            this.presenceArray = nArray;
            int newHashSize = MapBuilder.Companion.computeHashSize(newSize);
            if (newHashSize > this.getHashSize()) {
                this.rehash(newHashSize);
            }
        } else if (this.length + capacity - this.size() > this.getCapacity()) {
            this.rehash(this.getHashSize());
        }
    }

    private final V[] allocateValuesArray() {
        V[] curValuesArray = this.valuesArray;
        if (curValuesArray != null) {
            return curValuesArray;
        }
        E[] newValuesArray = ListBuilderKt.arrayOfUninitializedElements(this.getCapacity());
        this.valuesArray = newValuesArray;
        return newValuesArray;
    }

    private final int hash(K key) {
        K k = key;
        return (k == null ? 0 : k.hashCode()) * -1640531527 >>> this.hashShift;
    }

    private final void compact() {
        int i = 0;
        int j = 0;
        V[] valuesArray = this.valuesArray;
        while (i < this.length) {
            int n;
            if (this.presenceArray[i] >= 0) {
                this.keysArray[j] = this.keysArray[i];
                if (valuesArray != null) {
                    valuesArray[j] = valuesArray[i];
                }
                n = j;
                j = n + 1;
            }
            n = i;
            i = n + 1;
        }
        ListBuilderKt.resetRange(this.keysArray, j, this.length);
        V[] VArray = valuesArray;
        if (VArray != null) {
            ListBuilderKt.resetRange(VArray, j, this.length);
        }
        this.length = j;
    }

    private final void rehash(int newHashSize) {
        if (this.length > this.size()) {
            this.compact();
        }
        if (newHashSize != this.getHashSize()) {
            this.hashArray = new int[newHashSize];
            this.hashShift = MapBuilder.Companion.computeShift(newHashSize);
        } else {
            ArraysKt.fill(this.hashArray, 0, 0, this.getHashSize());
        }
        int i = 0;
        while (i < this.length) {
            int n = i;
            i = n + 1;
            if (this.putRehash(n)) continue;
            throw new IllegalStateException("This cannot happen with fixed magic multiplier and grow-only hash array. Have object hashCodes changed?");
        }
    }

    private final boolean putRehash(int i) {
        int hash = this.hash(this.keysArray[i]);
        int probesLeft = this.maxProbeDistance;
        while (true) {
            int index2;
            if ((index2 = this.hashArray[hash]) == 0) {
                this.hashArray[hash] = i + 1;
                this.presenceArray[i] = hash;
                return true;
            }
            if (--probesLeft < 0) {
                return false;
            }
            int n = hash;
            hash = n + -1;
            if (n != 0) continue;
            hash = this.getHashSize() - 1;
        }
    }

    private final int findKey(K key) {
        int hash = this.hash(key);
        int probesLeft = this.maxProbeDistance;
        int index2;
        while ((index2 = this.hashArray[hash]) != 0) {
            if (index2 > 0 && Intrinsics.areEqual(this.keysArray[index2 - 1], key)) {
                return index2 - 1;
            }
            if (--probesLeft < 0) {
                return -1;
            }
            int n = hash;
            hash = n + -1;
            if (n != 0) continue;
            hash = this.getHashSize() - 1;
        }
        return -1;
    }

    private final int findValue(V value2) {
        int i = this.length;
        while (--i >= 0) {
            if (this.presenceArray[i] < 0) continue;
            Intrinsics.checkNotNull(this.valuesArray);
            if (!Intrinsics.areEqual(this.valuesArray[i], value2)) continue;
            return i;
        }
        return -1;
    }

    public final int addKey$kotlin_stdlib(K key) {
        this.checkIsMutable$kotlin_stdlib();
        block0: while (true) {
            int hash = this.hash(key);
            int tentativeMaxProbeDistance = RangesKt.coerceAtMost(this.maxProbeDistance * 2, this.getHashSize() / 2);
            int probeDistance = 0;
            while (true) {
                int index2;
                if ((index2 = this.hashArray[hash]) <= 0) {
                    if (this.length >= this.getCapacity()) {
                        this.ensureExtraCapacity(1);
                        continue block0;
                    }
                    MapBuilder mapBuilder = this;
                    int n = mapBuilder.length;
                    mapBuilder.length = n + 1;
                    int putIndex = n;
                    this.keysArray[putIndex] = key;
                    this.presenceArray[putIndex] = hash;
                    this.hashArray[hash] = putIndex + 1;
                    mapBuilder = this;
                    n = mapBuilder.size();
                    mapBuilder.size = n + 1;
                    if (probeDistance > this.maxProbeDistance) {
                        this.maxProbeDistance = probeDistance;
                    }
                    return putIndex;
                }
                if (Intrinsics.areEqual(this.keysArray[index2 - 1], key)) {
                    return -index2;
                }
                if (++probeDistance > tentativeMaxProbeDistance) {
                    this.rehash(this.getHashSize() * 2);
                    continue block0;
                }
                int n = hash;
                hash = n + -1;
                if (n != 0) continue;
                hash = this.getHashSize() - 1;
            }
            break;
        }
    }

    public final int removeKey$kotlin_stdlib(K key) {
        this.checkIsMutable$kotlin_stdlib();
        int index2 = this.findKey(key);
        if (index2 < 0) {
            return -1;
        }
        this.removeKeyAt(index2);
        return index2;
    }

    private final void removeKeyAt(int index2) {
        ListBuilderKt.resetAt(this.keysArray, index2);
        this.removeHashAt(this.presenceArray[index2]);
        this.presenceArray[index2] = -1;
        MapBuilder mapBuilder = this;
        int n = mapBuilder.size();
        mapBuilder.size = n + -1;
    }

    private final void removeHashAt(int removedHash) {
        int hash = removedHash;
        int hole = removedHash;
        int probeDistance = 0;
        int patchAttemptsLeft = RangesKt.coerceAtMost(this.maxProbeDistance * 2, this.getHashSize() / 2);
        do {
            int n = hash;
            hash = n + -1;
            if (n == 0) {
                hash = this.getHashSize() - 1;
            }
            if (++probeDistance > this.maxProbeDistance) {
                this.hashArray[hole] = 0;
                return;
            }
            int index2 = this.hashArray[hash];
            if (index2 == 0) {
                this.hashArray[hole] = 0;
                return;
            }
            if (index2 < 0) {
                this.hashArray[hole] = -1;
                hole = hash;
                probeDistance = 0;
                continue;
            }
            int otherHash = this.hash(this.keysArray[index2 - 1]);
            if ((otherHash - hash & this.getHashSize() - 1) < probeDistance) continue;
            this.hashArray[hole] = index2;
            this.presenceArray[index2 - 1] = hole;
            hole = hash;
            probeDistance = 0;
        } while (--patchAttemptsLeft >= 0);
        this.hashArray[hole] = -1;
    }

    public final boolean containsEntry$kotlin_stdlib(@NotNull Map.Entry<? extends K, ? extends V> entry) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        int index2 = this.findKey(entry.getKey());
        if (index2 < 0) {
            return false;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        return Intrinsics.areEqual(this.valuesArray[index2], entry.getValue());
    }

    private final boolean contentEquals(Map<?, ?> other) {
        return this.size() == other.size() && this.containsAllEntries$kotlin_stdlib((Collection)other.entrySet());
    }

    public final boolean containsAllEntries$kotlin_stdlib(@NotNull Collection<?> m) {
        Intrinsics.checkNotNullParameter(m, "m");
        for (Object entry : m) {
            try {
                if (entry != null && this.containsEntry$kotlin_stdlib((Map.Entry)entry)) continue;
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return true;
    }

    private final boolean putEntry(Map.Entry<? extends K, ? extends V> entry) {
        int index2 = this.addKey$kotlin_stdlib(entry.getKey());
        V[] valuesArray = this.allocateValuesArray();
        if (index2 >= 0) {
            valuesArray[index2] = entry.getValue();
            return true;
        }
        V oldValue = valuesArray[-index2 - 1];
        if (!Intrinsics.areEqual(entry.getValue(), oldValue)) {
            valuesArray[-index2 - 1] = entry.getValue();
            return true;
        }
        return false;
    }

    private final boolean putAllEntries(Collection<? extends Map.Entry<? extends K, ? extends V>> from2) {
        if (from2.isEmpty()) {
            return false;
        }
        this.ensureExtraCapacity(from2.size());
        Iterator<Map.Entry<K, V>> it = from2.iterator();
        boolean updated = false;
        while (it.hasNext()) {
            if (!this.putEntry(it.next())) continue;
            updated = true;
        }
        return updated;
    }

    public final boolean removeEntry$kotlin_stdlib(@NotNull Map.Entry<? extends K, ? extends V> entry) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        this.checkIsMutable$kotlin_stdlib();
        int index2 = this.findKey(entry.getKey());
        if (index2 < 0) {
            return false;
        }
        Intrinsics.checkNotNull(this.valuesArray);
        if (!Intrinsics.areEqual(this.valuesArray[index2], entry.getValue())) {
            return false;
        }
        this.removeKeyAt(index2);
        return true;
    }

    public final boolean removeValue$kotlin_stdlib(V element) {
        this.checkIsMutable$kotlin_stdlib();
        int index2 = this.findValue(element);
        if (index2 < 0) {
            return false;
        }
        this.removeKeyAt(index2);
        return true;
    }

    @NotNull
    public final KeysItr<K, V> keysIterator$kotlin_stdlib() {
        return new KeysItr(this);
    }

    @NotNull
    public final ValuesItr<K, V> valuesIterator$kotlin_stdlib() {
        return new ValuesItr(this);
    }

    @NotNull
    public final EntriesItr<K, V> entriesIterator$kotlin_stdlib() {
        return new EntriesItr(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\r\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\t\u00a8\u0006\u000f"}, d2={"Lkotlin/collections/builders/MapBuilder$Companion;", "", "", "capacity", "computeHashSize", "(I)I", "hashSize", "computeShift", "INITIAL_CAPACITY", "I", "INITIAL_MAX_PROBE_DISTANCE", "MAGIC", "TOMBSTONE", "<init>", "()V", "kotlin-stdlib"})
    private static final class Companion {
        private Companion() {
        }

        private final int computeHashSize(int capacity) {
            return Integer.highestOneBit(RangesKt.coerceAtLeast(capacity, 1) * 3);
        }

        private final int computeShift(int hashSize) {
            return Integer.numberOfLeadingZeros(hashSize) + 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0010\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u00020\u0003B\u001b\u0012\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\n\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\tR\"\u0010\r\u001a\u00020\f8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u00020\f8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R&\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00168\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lkotlin/collections/builders/MapBuilder$Itr;", "K", "V", "", "", "hasNext", "()Z", "", "initNext$kotlin_stdlib", "()V", "initNext", "remove", "", "index", "I", "getIndex$kotlin_stdlib", "()I", "setIndex$kotlin_stdlib", "(I)V", "lastIndex", "getLastIndex$kotlin_stdlib", "setLastIndex$kotlin_stdlib", "Lkotlin/collections/builders/MapBuilder;", "map", "Lkotlin/collections/builders/MapBuilder;", "getMap$kotlin_stdlib", "()Lkotlin/collections/builders/MapBuilder;", "<init>", "(Lkotlin/collections/builders/MapBuilder;)V", "kotlin-stdlib"})
    public static class Itr<K, V> {
        @NotNull
        private final MapBuilder<K, V> map;
        private int index;
        private int lastIndex;

        public Itr(@NotNull MapBuilder<K, V> map2) {
            Intrinsics.checkNotNullParameter(map2, "map");
            this.map = map2;
            this.lastIndex = -1;
            this.initNext$kotlin_stdlib();
        }

        @NotNull
        public final MapBuilder<K, V> getMap$kotlin_stdlib() {
            return this.map;
        }

        public final int getIndex$kotlin_stdlib() {
            return this.index;
        }

        public final void setIndex$kotlin_stdlib(int n) {
            this.index = n;
        }

        public final int getLastIndex$kotlin_stdlib() {
            return this.lastIndex;
        }

        public final void setLastIndex$kotlin_stdlib(int n) {
            this.lastIndex = n;
        }

        public final void initNext$kotlin_stdlib() {
            while (this.index < ((MapBuilder)this.map).length && ((MapBuilder)this.map).presenceArray[this.index] < 0) {
                Itr itr = this;
                int n = itr.index;
                itr.index = n + 1;
            }
        }

        public final boolean hasNext() {
            return this.index < ((MapBuilder)this.map).length;
        }

        public final void remove() {
            boolean bl;
            boolean bl2 = bl = this.lastIndex != -1;
            if (!bl) {
                boolean bl3 = false;
                String string = "Call next() before removing element from the iterator.";
                throw new IllegalStateException(string.toString());
            }
            this.map.checkIsMutable$kotlin_stdlib();
            ((MapBuilder)this.map).removeKeyAt(this.lastIndex);
            this.lastIndex = -1;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00032\b\u0012\u0004\u0012\u00028\u00020\u0004B\u001b\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0005\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lkotlin/collections/builders/MapBuilder$KeysItr;", "K", "V", "Lkotlin/collections/builders/MapBuilder$Itr;", "", "next", "()Ljava/lang/Object;", "Lkotlin/collections/builders/MapBuilder;", "map", "<init>", "(Lkotlin/collections/builders/MapBuilder;)V", "kotlin-stdlib"})
    public static final class KeysItr<K, V>
    extends Itr<K, V>
    implements Iterator<K>,
    KMutableIterator {
        public KeysItr(@NotNull MapBuilder<K, V> map2) {
            Intrinsics.checkNotNullParameter(map2, "map");
            super(map2);
        }

        @Override
        public K next() {
            if (this.getIndex$kotlin_stdlib() >= this.getMap$kotlin_stdlib().length) {
                throw new NoSuchElementException();
            }
            KeysItr keysItr = this;
            int n = keysItr.getIndex$kotlin_stdlib();
            keysItr.setIndex$kotlin_stdlib(n + 1);
            this.setLastIndex$kotlin_stdlib(n);
            Object result2 = this.getMap$kotlin_stdlib().keysArray[this.getLastIndex$kotlin_stdlib()];
            this.initNext$kotlin_stdlib();
            return (K)result2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00032\b\u0012\u0004\u0012\u00028\u00030\u0004B\u001b\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0005\u001a\u00028\u0003H\u0096\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lkotlin/collections/builders/MapBuilder$ValuesItr;", "K", "V", "Lkotlin/collections/builders/MapBuilder$Itr;", "", "next", "()Ljava/lang/Object;", "Lkotlin/collections/builders/MapBuilder;", "map", "<init>", "(Lkotlin/collections/builders/MapBuilder;)V", "kotlin-stdlib"})
    public static final class ValuesItr<K, V>
    extends Itr<K, V>
    implements Iterator<V>,
    KMutableIterator {
        public ValuesItr(@NotNull MapBuilder<K, V> map2) {
            Intrinsics.checkNotNullParameter(map2, "map");
            super(map2);
        }

        @Override
        public V next() {
            if (this.getIndex$kotlin_stdlib() >= this.getMap$kotlin_stdlib().length) {
                throw new NoSuchElementException();
            }
            ValuesItr valuesItr = this;
            int n = valuesItr.getIndex$kotlin_stdlib();
            valuesItr.setIndex$kotlin_stdlib(n + 1);
            this.setLastIndex$kotlin_stdlib(n);
            Object[] objectArray = this.getMap$kotlin_stdlib().valuesArray;
            Intrinsics.checkNotNull(objectArray);
            Object result2 = objectArray[this.getLastIndex$kotlin_stdlib()];
            this.initNext$kotlin_stdlib();
            return (V)result2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0010'\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00032\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00050\u0004B\u001b\u0012\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0006H\u0096\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\r\u001a\u00020\f2\n\u0010\u000b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0012\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lkotlin/collections/builders/MapBuilder$EntriesItr;", "K", "V", "Lkotlin/collections/builders/MapBuilder$Itr;", "", "", "Lkotlin/collections/builders/MapBuilder$EntryRef;", "next", "()Lkotlin/collections/builders/MapBuilder$EntryRef;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "", "nextAppendString", "(Ljava/lang/StringBuilder;)V", "", "nextHashCode$kotlin_stdlib", "()I", "nextHashCode", "Lkotlin/collections/builders/MapBuilder;", "map", "<init>", "(Lkotlin/collections/builders/MapBuilder;)V", "kotlin-stdlib"})
    public static final class EntriesItr<K, V>
    extends Itr<K, V>
    implements Iterator<Map.Entry<K, V>>,
    KMutableIterator {
        public EntriesItr(@NotNull MapBuilder<K, V> map2) {
            Intrinsics.checkNotNullParameter(map2, "map");
            super(map2);
        }

        @Override
        @NotNull
        public EntryRef<K, V> next() {
            if (this.getIndex$kotlin_stdlib() >= this.getMap$kotlin_stdlib().length) {
                throw new NoSuchElementException();
            }
            EntriesItr entriesItr = this;
            int n = entriesItr.getIndex$kotlin_stdlib();
            entriesItr.setIndex$kotlin_stdlib(n + 1);
            this.setLastIndex$kotlin_stdlib(n);
            EntryRef result2 = new EntryRef(this.getMap$kotlin_stdlib(), this.getLastIndex$kotlin_stdlib());
            this.initNext$kotlin_stdlib();
            return result2;
        }

        public final int nextHashCode$kotlin_stdlib() {
            if (this.getIndex$kotlin_stdlib() >= this.getMap$kotlin_stdlib().length) {
                throw new NoSuchElementException();
            }
            EntriesItr entriesItr = this;
            int n = entriesItr.getIndex$kotlin_stdlib();
            entriesItr.setIndex$kotlin_stdlib(n + 1);
            this.setLastIndex$kotlin_stdlib(n);
            Object object = this.getMap$kotlin_stdlib().keysArray[this.getLastIndex$kotlin_stdlib()];
            int n2 = object == null ? 0 : object.hashCode();
            Object[] objectArray = this.getMap$kotlin_stdlib().valuesArray;
            Intrinsics.checkNotNull(objectArray);
            object = objectArray[this.getLastIndex$kotlin_stdlib()];
            int result2 = n2 ^ (object == null ? 0 : object.hashCode());
            this.initNext$kotlin_stdlib();
            return result2;
        }

        public final void nextAppendString(@NotNull StringBuilder sb) {
            Intrinsics.checkNotNullParameter(sb, "sb");
            if (this.getIndex$kotlin_stdlib() >= this.getMap$kotlin_stdlib().length) {
                throw new NoSuchElementException();
            }
            EntriesItr entriesItr = this;
            int n = entriesItr.getIndex$kotlin_stdlib();
            entriesItr.setIndex$kotlin_stdlib(n + 1);
            this.setLastIndex$kotlin_stdlib(n);
            Object key = this.getMap$kotlin_stdlib().keysArray[this.getLastIndex$kotlin_stdlib()];
            if (Intrinsics.areEqual(key, this.getMap$kotlin_stdlib())) {
                sb.append("(this Map)");
            } else {
                sb.append(key);
            }
            sb.append('=');
            Object[] objectArray = this.getMap$kotlin_stdlib().valuesArray;
            Intrinsics.checkNotNull(objectArray);
            Object value2 = objectArray[this.getLastIndex$kotlin_stdlib()];
            if (Intrinsics.areEqual(value2, this.getMap$kotlin_stdlib())) {
                sb.append("(this Map)");
            } else {
                sb.append(value2);
            }
            this.initNext$kotlin_stdlib();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010'\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0003B#\u0012\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0017\u0012\u0006\u0010\u0012\u001a\u00020\t\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001a\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0096\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00028\u00032\u0006\u0010\f\u001a\u00028\u0003H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00028\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00028\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lkotlin/collections/builders/MapBuilder$EntryRef;", "K", "V", "", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "newValue", "setValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "", "toString", "()Ljava/lang/String;", "index", "I", "getKey", "()Ljava/lang/Object;", "key", "Lkotlin/collections/builders/MapBuilder;", "map", "Lkotlin/collections/builders/MapBuilder;", "getValue", "value", "<init>", "(Lkotlin/collections/builders/MapBuilder;I)V", "kotlin-stdlib"})
    public static final class EntryRef<K, V>
    implements Map.Entry<K, V>,
    KMutableMap.Entry {
        @NotNull
        private final MapBuilder<K, V> map;
        private final int index;

        public EntryRef(@NotNull MapBuilder<K, V> map2, int index2) {
            Intrinsics.checkNotNullParameter(map2, "map");
            this.map = map2;
            this.index = index2;
        }

        @Override
        public K getKey() {
            return (K)((MapBuilder)this.map).keysArray[this.index];
        }

        @Override
        public V getValue() {
            Object[] objectArray = ((MapBuilder)this.map).valuesArray;
            Intrinsics.checkNotNull(objectArray);
            return (V)objectArray[this.index];
        }

        @Override
        public V setValue(V newValue) {
            this.map.checkIsMutable$kotlin_stdlib();
            Object[] valuesArray = ((MapBuilder)this.map).allocateValuesArray();
            Object oldValue = valuesArray[this.index];
            valuesArray[this.index] = newValue;
            return (V)oldValue;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return other instanceof Map.Entry && Intrinsics.areEqual(((Map.Entry)other).getKey(), this.getKey()) && Intrinsics.areEqual(((Map.Entry)other).getValue(), this.getValue());
        }

        @Override
        public int hashCode() {
            Object object = this.getKey();
            int n = object == null ? 0 : object.hashCode();
            object = this.getValue();
            return n ^ (object == null ? 0 : object.hashCode());
        }

        @NotNull
        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }
}

