/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.vigilance.data;

import gg.essential.vigilance.data.CategoryItem;
import gg.essential.vigilance.data.PropertyData;
import gg.essential.vigilance.data.PropertyInfo;
import gg.essential.vigilance.data.PropertyType;
import gg.essential.vigilance.gui.DataBackedSetting;
import gg.essential.vigilance.gui.Setting;
import gg.essential.vigilance.gui.settings.ButtonComponent;
import gg.essential.vigilance.gui.settings.CheckboxComponent;
import gg.essential.vigilance.gui.settings.ColorComponent;
import gg.essential.vigilance.gui.settings.DecimalSliderComponent;
import gg.essential.vigilance.gui.settings.NumberComponent;
import gg.essential.vigilance.gui.settings.PercentSliderComponent;
import gg.essential.vigilance.gui.settings.SelectorComponent;
import gg.essential.vigilance.gui.settings.SettingComponent;
import gg.essential.vigilance.gui.settings.SliderComponent;
import gg.essential.vigilance.gui.settings.SwitchComponent;
import gg.essential.vigilance.gui.settings.TextComponent;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lgg/essential/vigilance/data/PropertyItem;", "Lgg/essential/vigilance/data/CategoryItem;", "Lgg/essential/vigilance/gui/Setting;", "toSettingsObject", "()Lgg/essential/vigilance/gui/Setting;", "", "toString", "()Ljava/lang/String;", "Lgg/essential/vigilance/data/PropertyData;", "data", "Lgg/essential/vigilance/data/PropertyData;", "getData", "()Lgg/essential/vigilance/data/PropertyData;", "subcategory", "Ljava/lang/String;", "getSubcategory", "<init>", "(Lgg/essential/vigilance/data/PropertyData;Ljava/lang/String;)V", "Vigilance"})
public final class PropertyItem
extends CategoryItem {
    @NotNull
    private final PropertyData data;
    @NotNull
    private final String subcategory;

    public PropertyItem(@NotNull PropertyData data2, @NotNull String subcategory) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(subcategory, "subcategory");
        super(null);
        this.data = data2;
        this.subcategory = subcategory;
    }

    @NotNull
    public final PropertyData getData() {
        return this.data;
    }

    @NotNull
    public final String getSubcategory() {
        return this.subcategory;
    }

    @Override
    @NotNull
    public Setting toSettingsObject() {
        SettingComponent settingComponent;
        switch (WhenMappings.$EnumSwitchMapping$0[this.data.getDataType().ordinal()]) {
            case 1: {
                settingComponent = new SwitchComponent(this.data.getAsBoolean());
                break;
            }
            case 2: {
                settingComponent = new CheckboxComponent(this.data.getAsBoolean());
                break;
            }
            case 3: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                }
                settingComponent = new PercentSliderComponent(((Number)((Float)object)).floatValue());
                break;
            }
            case 4: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                settingComponent = new SliderComponent(((Number)((Integer)object)).intValue(), this.data.getAttributesExt().getMin(), this.data.getAttributesExt().getMax());
                break;
            }
            case 5: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                }
                settingComponent = new DecimalSliderComponent(((Number)((Float)object)).floatValue(), this.data.getAttributesExt().getMinF(), this.data.getAttributesExt().getMaxF(), this.data.getAttributesExt().getDecimalPlaces());
                break;
            }
            case 6: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                settingComponent = new NumberComponent(((Number)((Integer)object)).intValue(), this.data.getAttributesExt().getMin(), this.data.getAttributesExt().getMax(), this.data.getAttributesExt().getIncrement());
                break;
            }
            case 7: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                settingComponent = new SelectorComponent(((Number)((Integer)object)).intValue(), CollectionsKt.toList((Iterable)this.data.getAttributesExt().getOptions()));
                break;
            }
            case 8: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.awt.Color");
                }
                settingComponent = new ColorComponent((Color)object, this.data.getAttributesExt().getAllowAlpha());
                break;
            }
            case 9: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                settingComponent = new TextComponent((String)object, this.data.getAttributesExt().getPlaceholder(), false, this.data.getAttributesExt().getProtected());
                break;
            }
            case 10: {
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                Object object = this_$iv.getValue().getValue(this_$iv.getInstance());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                settingComponent = new TextComponent((String)object, this.data.getAttributesExt().getPlaceholder(), true, false);
                break;
            }
            case 11: {
                settingComponent = new ButtonComponent(this.data.getAttributesExt().getPlaceholder(), this.data);
                break;
            }
            case 12: {
                Class<? extends PropertyInfo> propertyInfoClass = this.data.getAttributesExt().getCustomPropertyInfo();
                PropertyData this_$iv = this.data;
                boolean $i$f$getValue = false;
                settingComponent = propertyInfoClass.getConstructor(new Class[0]).newInstance(new Object[0]).createSettingComponent(this_$iv.getValue().getValue(this_$iv.getInstance()));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        SettingComponent component2 = settingComponent;
        return new DataBackedSetting(this.data, component2);
    }

    @NotNull
    public String toString() {
        return (Object)((Object)this.data.getAttributesExt().getType()) + " \"" + this.data.getAttributesExt().getName() + '\"';
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PropertyType.values().length];
            nArray[PropertyType.SWITCH.ordinal()] = 1;
            nArray[PropertyType.CHECKBOX.ordinal()] = 2;
            nArray[PropertyType.PERCENT_SLIDER.ordinal()] = 3;
            nArray[PropertyType.SLIDER.ordinal()] = 4;
            nArray[PropertyType.DECIMAL_SLIDER.ordinal()] = 5;
            nArray[PropertyType.NUMBER.ordinal()] = 6;
            nArray[PropertyType.SELECTOR.ordinal()] = 7;
            nArray[PropertyType.COLOR.ordinal()] = 8;
            nArray[PropertyType.TEXT.ordinal()] = 9;
            nArray[PropertyType.PARAGRAPH.ordinal()] = 10;
            nArray[PropertyType.BUTTON.ordinal()] = 11;
            nArray[PropertyType.CUSTOM.ordinal()] = 12;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

