/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util.crash;

import gg.essential.Essential;
import gg.essential.util.Multithreading;
import gg.essential.util.WebUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;

public class StacktraceDeobfuscator {
    private static final boolean DEBUG_IN_DEV = false;
    public static final String MAPPINGS_VERSION = "39-1.12";
    private static final String mappingsLink = "https://maven.minecraftforge.net/de/oceanlabs/mcp/mcp_stable_nodoc/39-1.12/mcp_stable_nodoc-39-1.12.zip";
    private static CompletableFuture<StacktraceDeobfuscator> instanceFuture;
    private final Map<String, String> srgMcpMethodMap;

    public StacktraceDeobfuscator(Map<String, String> srgMcpMethodMap) {
        this.srgMcpMethodMap = srgMcpMethodMap;
    }

    public static void setup(File file) {
        if (instanceFuture != null) {
            return;
        }
        instanceFuture = ((CompletableFuture)((CompletableFuture)StacktraceDeobfuscator.fromFile(file).exceptionally(throwable -> {
            if (file.exists()) {
                Essential.logger.error("Failed to read mappings from " + file, throwable);
                FileUtils.deleteQuietly((File)file);
            }
            return null;
        })).thenComposeAsync(result2 -> {
            if (result2 != null) {
                return CompletableFuture.completedFuture(result2);
            }
            StacktraceDeobfuscator.downloadToFile(file);
            return StacktraceDeobfuscator.fromFile(file);
        }, (Executor)Multithreading.POOL)).exceptionally(throwable -> {
            Essential.logger.error("Failed to download mappings from https://maven.minecraftforge.net/de/oceanlabs/mcp/mcp_stable_nodoc/39-1.12/mcp_stable_nodoc-39-1.12.zip", throwable);
            return null;
        });
    }

    private static void downloadToFile(File file) {
        try {
            Path zipFile = Files.createTempFile("mappings", ".zip", new FileAttribute[0]);
            WebUtil.downloadToFile(mappingsLink, zipFile.toFile(), "Mozilla/4.76 (Essential)");
            try (FileSystem zipFileSystem = FileSystems.newFileSystem(zipFile, (ClassLoader)null);){
                Files.copy(zipFileSystem.getPath("methods.csv", new String[0]), file.toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new CompletionException(e);
        }
    }

    private static CompletableFuture<StacktraceDeobfuscator> fromFile(File file) {
        return CompletableFuture.supplyAsync(() -> StacktraceDeobfuscator.readFromFile(file), Multithreading.POOL);
    }

    private static StacktraceDeobfuscator readFromFile(File file) {
        HashMap<String, String> toMerge = new HashMap<String, String>();
        try (Scanner scanner = new Scanner(file);){
            scanner.nextLine();
            while (scanner.hasNext()) {
                String mappingLine = scanner.nextLine();
                int commaIndex = mappingLine.indexOf(44);
                String srgName = mappingLine.substring(0, commaIndex);
                String mcpName = mappingLine.substring(commaIndex + 1, commaIndex + 1 + mappingLine.substring(commaIndex + 1).indexOf(44));
                toMerge.put(srgName, mcpName);
            }
        }
        catch (IOException e) {
            throw new CompletionException(e);
        }
        return new StacktraceDeobfuscator(toMerge);
    }

    public static StacktraceDeobfuscator get() {
        if (instanceFuture == null) {
            return null;
        }
        try {
            return instanceFuture.get(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ignore) {
            return null;
        }
    }

    public void deobfuscateThrowable(Throwable t) {
        ArrayDeque<Throwable> queue = new ArrayDeque<Throwable>();
        queue.add(t);
        while (!queue.isEmpty()) {
            t = (Throwable)queue.remove();
            t.setStackTrace(this.deobfuscateStacktrace(t.getStackTrace()));
            if (t.getCause() != null) {
                queue.add(t.getCause());
            }
            Collections.addAll(queue, t.getSuppressed());
        }
    }

    public StackTraceElement[] deobfuscateStacktrace(StackTraceElement[] stackTrace) {
        int index2 = 0;
        for (StackTraceElement el : stackTrace) {
            stackTrace[index2++] = new StackTraceElement(el.getClassName(), this.deobfuscateMethodName(el.getMethodName()), el.getFileName(), el.getLineNumber());
        }
        return stackTrace;
    }

    public String deobfuscateMethodName(String srgName) {
        String mcpName = this.srgMcpMethodMap.get(srgName);
        return mcpName != null ? mcpName : srgName;
    }
}

