/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Version
implements Comparable<Version> {
    private final String version;

    public final String get() {
        return this.version;
    }

    public Version(String version) {
        Objects.requireNonNull(version, "Version can not be null");
        Pattern semanticVersionRegex = Pattern.compile("^(?<major>0|[1-9]\\d*)\\.(?<minor>0|[1-9]\\d*)(\\.(?<patch>0|[1-9]\\d*))?(?:-(?<prerelease>(?:0|[1-9]\\d*|\\d*[a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+(?<metadata>[0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
        if (!version.matches(semanticVersionRegex.toString())) {
            throw new IllegalArgumentException(String.format("Invalid version format: %s", version));
        }
        this.version = version;
    }

    @Override
    public int compareTo(@NotNull Version that) {
        String[] thisParts = this.get().split("\\.");
        String[] thatParts = that.get().split("\\.");
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
            int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((Version)that) == 0;
    }
}

