/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.Essential;
import gg.essential.event.client.ReAuthEvent;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.lib.kbrewster.exceptions.APIException;
import gg.essential.lib.kbrewster.mojangapi.MojangAPI;
import gg.essential.universal.UMinecraft;
import gg.essential.util.Multithreading;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class UUIDUtil {
    private static final ConcurrentHashMap<String, UUID> nameToUUID = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, String> uuidToName = new ConcurrentHashMap();
    private static UUID cachedUUID = null;

    public static CompletableFuture<String> getName(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            String fetchedName = uuidToName.computeIfAbsent(uuid, uuid1 -> {
                String s = UUIDUtil.loadNameSync(uuid1);
                nameToUUID.put(s.toLowerCase(), uuid);
                return s;
            });
            if (fetchedName.equals(uuid.toString())) {
                uuidToName.remove(uuid);
            }
            return fetchedName;
        }, Multithreading.POOL);
    }

    private static String loadNameSync(UUID uuid) {
        try {
            return MojangAPI.getName(uuid);
        }
        catch (APIException | IOException e) {
            e.printStackTrace();
            return "Error";
        }
    }

    private static UUID loadUUIDSync(String name) {
        try {
            return MojangAPI.getUUID(name);
        }
        catch (APIException | IOException e) {
            e.printStackTrace();
            return UUIDUtil.formatWithDashes("00000000000000000000000000000000");
        }
    }

    public static CompletableFuture<UUID> getUUID(String userName) {
        return CompletableFuture.supplyAsync(() -> nameToUUID.computeIfAbsent(userName.toLowerCase(), UUIDUtil::loadUUIDSync), Multithreading.POOL);
    }

    public static String getUUIDWithoutDashes(UUID uuid) {
        return uuid.toString().toLowerCase().replace("-", "");
    }

    public static String getUUIDWithoutDashes() {
        return UUIDUtil.getUUIDWithoutDashes(UUIDUtil.getClientUUID());
    }

    public static UUID getClientUUID() {
        UUID cached = cachedUUID;
        if (cached != null) {
            return cached;
        }
        cachedUUID = UMinecraft.getMinecraft().method_1548().method_1677().getId();
        return cachedUUID;
    }

    public static UUID formatWithDashes(String uuidWithoutDashes) {
        return UUID.fromString(uuidWithoutDashes.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
    }

    static {
        Essential.EVENT_BUS.register(new Object(){

            @Subscribe
            private void clearUUIDCache(ReAuthEvent event) {
                cachedUUID = null;
            }
        });
    }
}

