/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Multithreading {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final ScheduledExecutorService RUNNABLE_POOL = Executors.newScheduledThreadPool(10, r -> new Thread(r, "Essential Thread " + counter.incrementAndGet()));
    public static ThreadPoolExecutor POOL = new ThreadPoolExecutor(10, 30, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, String.format("Thread %s", counter.incrementAndGet())));

    public static ScheduledFuture<?> schedule(Runnable r, long initialDelay, long delay2, TimeUnit unit) {
        return RUNNABLE_POOL.scheduleAtFixedRate(r, initialDelay, delay2, unit);
    }

    public static ScheduledFuture<?> schedule(Runnable r, long delay2, TimeUnit unit) {
        return RUNNABLE_POOL.schedule(r, delay2, unit);
    }

    public static Executor delayedExecutor(long delay2, TimeUnit unit) {
        return task -> Multithreading.schedule(task, delay2, unit);
    }

    public static void runAsync(Runnable runnable) {
        POOL.execute(runnable);
    }

    public static Future<?> submit(Runnable runnable) {
        return POOL.submit(runnable);
    }
}

