/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.Essential;
import gg.essential.api.utils.JsonHolder;
import gg.essential.api.utils.mojang.Model;
import gg.essential.api.utils.mojang.SkinResponse;
import gg.essential.lib.kbrewster.mojangapi.Property;
import gg.essential.lib.kbrewster.mojangapi.profile.Name;
import gg.essential.lib.kbrewster.mojangapi.profile.Profile;
import gg.essential.lib.okhttp3.MediaType;
import gg.essential.lib.okhttp3.MultipartBody;
import gg.essential.lib.okhttp3.OkHttpClient;
import gg.essential.lib.okhttp3.Request;
import gg.essential.lib.okhttp3.RequestBody;
import gg.essential.lib.okhttp3.ResponseBody;
import gg.essential.util.UUIDUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ1\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ#\u0010\u0011\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lgg/essential/util/MojangAPI;", "Lgg/essential/api/utils/mojang/MojangAPI;", "", "accessToken", "Ljava/util/UUID;", "uuid", "Lgg/essential/api/utils/mojang/Model;", "model", "url", "Lgg/essential/api/utils/mojang/SkinResponse;", "changeSkin", "(Ljava/lang/String;Ljava/util/UUID;Lgg/essential/api/utils/mojang/Model;Ljava/lang/String;)Lgg/essential/api/utils/mojang/SkinResponse;", "Ljava/util/concurrent/CompletableFuture;", "getName", "(Ljava/util/UUID;)Ljava/util/concurrent/CompletableFuture;", "", "Lgg/essential/api/utils/mojang/Name;", "getNameHistory", "(Ljava/util/UUID;)Ljava/util/List;", "Lgg/essential/api/utils/mojang/Profile;", "getProfile", "(Ljava/util/UUID;)Lgg/essential/api/utils/mojang/Profile;", "name", "getUUID", "(Ljava/lang/String;)Ljava/util/concurrent/CompletableFuture;", "Ljava/io/File;", "file", "uploadSkin", "(Ljava/lang/String;Lgg/essential/api/utils/mojang/Model;Ljava/io/File;)Lgg/essential/api/utils/mojang/SkinResponse;", "<init>", "()V", "Essential 1.19-fabric"})
public final class MojangAPI
implements gg.essential.api.utils.mojang.MojangAPI {
    @NotNull
    public static final MojangAPI INSTANCE = new MojangAPI();

    private MojangAPI() {
    }

    @Override
    @Nullable
    public CompletableFuture<UUID> getUUID(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return UUIDUtil.getUUID(name);
    }

    @Override
    @Nullable
    public CompletableFuture<String> getName(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return UUIDUtil.getName(uuid);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<gg.essential.api.utils.mojang.Name> getNameHistory(@Nullable UUID uuid) {
        List list;
        ArrayList<Name> names;
        ArrayList<Name> arrayList = names = gg.essential.lib.kbrewster.mojangapi.MojangAPI.getNameHistory(uuid);
        if (arrayList == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = arrayList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Name name = (Name)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new gg.essential.api.utils.mojang.Name(it.getName(), it.getChangedToAt()));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public gg.essential.api.utils.mojang.Profile getProfile(@NotNull UUID uuid) {
        Collection<gg.essential.api.utils.mojang.Property> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Profile profile = gg.essential.lib.kbrewster.mojangapi.MojangAPI.getProfile(uuid);
        if (profile == null) {
            return null;
        }
        Profile profile2 = profile;
        String string = profile2.getId();
        String string2 = profile2.getName();
        Iterable<Property> iterable = profile2.getProperties();
        Intrinsics.checkNotNullExpressionValue(iterable, "profile.properties");
        iterable = iterable;
        String string3 = string2;
        String string4 = string;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Property property = (Property)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new gg.essential.api.utils.mojang.Property(it.getName(), it.getValue()));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        String string5 = string3;
        String string6 = string4;
        return new gg.essential.api.utils.mojang.Profile(string6, string5, list);
    }

    @Override
    @Nullable
    public SkinResponse changeSkin(@NotNull String accessToken, @NotNull UUID uuid, @NotNull Model model, @NotNull String url) {
        Intrinsics.checkNotNullParameter(accessToken, "accessToken");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter((Object)model, "model");
        Intrinsics.checkNotNullParameter(url, "url");
        try {
            JsonHolder payload = new JsonHolder().put("variant", model.getVariant()).put("url", url);
            MediaType MEDIA_TYPE = MediaType.parse("application/json");
            RequestBody body = RequestBody.create(MEDIA_TYPE, payload.toString());
            Request request = new Request.Builder().url("https://api.minecraftservices.com/minecraft/profile/skins").header("Authorization", "Bearer " + accessToken).post(body).build();
            ResponseBody responseBody = new OkHttpClient().newCall(request).execute().body();
            Intrinsics.checkNotNull(responseBody);
            String output = responseBody.string();
            return (SkinResponse)Essential.GSON.fromJson(output, SkinResponse.class);
        }
        catch (Exception e) {
            Essential.logger.error("An error occurred while updating skin", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final SkinResponse uploadSkin(@NotNull String accessToken, @NotNull Model model, @NotNull File file) {
        Intrinsics.checkNotNullParameter(accessToken, "accessToken");
        Intrinsics.checkNotNullParameter((Object)model, "model");
        Intrinsics.checkNotNullParameter(file, "file");
        try {
            MultipartBody multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create(MediaType.parse("image/png"), file)).addFormDataPart("variant", model.getVariant()).build();
            Intrinsics.checkNotNullExpressionValue(multipartBody, "Builder()\n              \u2026\n                .build()");
            RequestBody body = multipartBody;
            Request request = new Request.Builder().url("https://api.minecraftservices.com/minecraft/profile/skins").header("Authorization", "Bearer " + accessToken).post(body).build();
            ResponseBody responseBody = new OkHttpClient().newCall(request).execute().body();
            Intrinsics.checkNotNull(responseBody);
            String output = responseBody.string();
            return (SkinResponse)Essential.GSON.fromJson(output, SkinResponse.class);
        }
        catch (Exception e) {
            Essential.logger.error("An error occurred while uploading a skin to Mojang", (Throwable)e);
            return null;
        }
    }
}

