/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.Essential;
import gg.essential.connectionmanager.common.packet.mod.ClientModsAnnouncePacket;
import gg.essential.universal.UMinecraft;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0019\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0004\b\u000e\u0010\bJ\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0015\u0010\rR\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00168\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lgg/essential/util/ModLoaderUtil;", "", "Lgg/essential/connectionmanager/common/packet/mod/ClientModsAnnouncePacket;", "createModsAnnouncePacket", "()Lgg/essential/connectionmanager/common/packet/mod/ClientModsAnnouncePacket;", "", "", "getLoadedPartnerModIds", "()Ljava/util/Map;", "", "getLoadedPartnerModsNames", "()Ljava/util/Collection;", "getMinecraftVersion", "()Ljava/lang/String;", "getModChecksums", "identifier", "getPartnerModName", "(Ljava/lang/String;)Ljava/lang/String;", "Lgg/essential/connectionmanager/common/packet/mod/ClientModsAnnouncePacket$Platform;", "getPlatform", "()Lgg/essential/connectionmanager/common/packet/mod/ClientModsAnnouncePacket$Platform;", "getPlatformVersion", "", "PARTNER_MODS", "Ljava/util/List;", "<init>", "()V", "Essential 1.19-fabric"})
public final class ModLoaderUtil {
    @NotNull
    public static final ModLoaderUtil INSTANCE = new ModLoaderUtil();
    @JvmField
    @NotNull
    public static final List<String> PARTNER_MODS;

    private ModLoaderUtil() {
    }

    @JvmStatic
    @NotNull
    public static final ClientModsAnnouncePacket createModsAnnouncePacket() {
        Collection<String> $this$toTypedArray$iv = INSTANCE.getModChecksums().values();
        boolean $i$f$toTypedArray = false;
        Collection<String> thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return new ClientModsAnnouncePacket(INSTANCE.getMinecraftVersion(), stringArray, INSTANCE.getPlatform(), INSTANCE.getPlatformVersion());
    }

    private final ClientModsAnnouncePacket.Platform getPlatform() {
        return ClientModsAnnouncePacket.Platform.FABRIC;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> getLoadedPartnerModIds() {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        Collection collection = FabricLoader.getInstance().getAllMods();
        Intrinsics.checkNotNullExpressionValue(collection, "getInstance().allMods");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModContainer it = (ModContainer)element$iv$iv;
            boolean bl = false;
            if (!PARTNER_MODS.contains(it.getMetadata().getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            ModContainer it = (ModContainer)element$iv$iv;
            boolean bl = false;
            Pair<String, String> pair = TuplesKt.to(it.getMetadata().getId(), it.getMetadata().getName());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    @NotNull
    public final Collection<String> getLoadedPartnerModsNames() {
        return this.getLoadedPartnerModIds().values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<String, String> getModChecksums() {
        void $this$mapTo$iv$iv;
        Collection collection = FabricLoader.getInstance().getAllMods();
        Intrinsics.checkNotNullExpressionValue(collection, "getInstance().allMods");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair<String, Object> pair;
            Collection collection2;
            block27: {
                void modContainer;
                ModContainer modContainer2 = (ModContainer)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                String modId = modContainer.getMetadata().getId();
                Path sourceFile = modContainer.getRootPath();
                Intrinsics.checkNotNullExpressionValue(modId, "modId");
                Object object = modId.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(object, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                Object object2 = object;
                if (Intrinsics.areEqual(object2, "forge") ? true : Intrinsics.areEqual(object2, "fml")) {
                    pair = null;
                } else {
                    FileStore fileStore;
                    if (sourceFile.isAbsolute() && sourceFile.getParent() == null) {
                        object2 = sourceFile;
                        Intrinsics.checkNotNullExpressionValue(object2, "sourceFile");
                        fileStore = Files.getFileStore((Path)object2);
                        Intrinsics.checkNotNullExpressionValue(fileStore, "getFileStore(this)");
                        if (Intrinsics.areEqual(fileStore.type(), "zipfs")) {
                            sourceFile = FileSystems.getDefault().getPath(sourceFile.getFileSystem().toString(), new String[0]);
                        }
                    }
                    object2 = sourceFile;
                    Intrinsics.checkNotNullExpressionValue(object2, "sourceFile");
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.isRegularFile((Path)object2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        pair = null;
                    } else {
                        try {
                            Object object3;
                            String string;
                            object = FileSystems.newFileSystem(sourceFile, (ClassLoader)null);
                            Object object4 = null;
                            try {
                                String string2;
                                FileSystem fileSystem = (FileSystem)object;
                                boolean bl2 = false;
                                Object object5 = new String[]{"MANIFEST.MF"};
                                Path manifestPath = fileSystem.getPath("META-INF", (String)object5);
                                Object object6 = manifestPath;
                                Path it = object6;
                                boolean bl3 = false;
                                Object object7 = object5 = Files.exists(it, new LinkOption[0]) ? object6 : null;
                                if (object5 == null) {
                                    string2 = null;
                                } else {
                                    Object p0 = object5;
                                    boolean bl4 = false;
                                    object6 = Files.newInputStream((Path)p0, new OpenOption[0]);
                                    if (object6 == null) {
                                        string2 = null;
                                    } else {
                                        Manifest manifest;
                                        Object object8 = (Closeable)object6;
                                        Throwable throwable = null;
                                        try {
                                            InputStream p02 = (InputStream)object8;
                                            boolean bl5 = false;
                                            manifest = new Manifest(p02);
                                        }
                                        catch (Throwable throwable2) {
                                            throwable = throwable2;
                                            throw throwable2;
                                        }
                                        finally {
                                            CloseableKt.closeFinally((Closeable)object8, throwable);
                                        }
                                        Manifest manifest2 = manifest;
                                        object8 = manifest2.getMainAttributes();
                                        string2 = object8 == null ? null : ((Attributes)object8).getValue("Essential-Mod-Checksum");
                                    }
                                }
                                string = string2;
                            }
                            catch (Throwable throwable) {
                                object4 = throwable;
                                throw throwable;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object, (Throwable)object4);
                            }
                            fileStore = string;
                            if (fileStore == null) {
                                object = sourceFile;
                                Intrinsics.checkNotNullExpressionValue(object, "sourceFile");
                                object4 = Files.readAllBytes((Path)object);
                                Intrinsics.checkNotNullExpressionValue(object4, "readAllBytes(this)");
                                object3 = DigestUtils.md5Hex((byte[])object4);
                            } else {
                                object3 = fileStore;
                            }
                            fileStore = object3;
                        }
                        catch (IOException e) {
                            Essential.logger.error("Error occurred when getting md5 checksum for mod {} (file={}).", (Object)modId, (Object)sourceFile, (Object)e);
                            pair = null;
                            break block27;
                        }
                        FileStore checksum = fileStore;
                        pair = TuplesKt.to(modId, !Intrinsics.areEqual(modId, "feather") ? checksum : "e3d04e686b28b34b5a98ce078e4f9da8");
                    }
                }
            }
            collection2.add(pair);
        }
        return MapsKt.toMap(CollectionsKt.filterNotNull((List)destination$iv$iv));
    }

    private final String getMinecraftVersion() {
        String string = UMinecraft.getMinecraft().method_16689().getVersion().getId();
        Intrinsics.checkNotNullExpressionValue(string, "getMinecraft().game.version.id");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String getPlatformVersion() {
        Object object;
        Collection<Object> collection;
        Object object2;
        block4: {
            Iterator $this$mapTo$iv$iv;
            object2 = FabricLoader.getInstance().getAllMods();
            Intrinsics.checkNotNullExpressionValue(object2, "getInstance().allMods");
            Iterable $this$map$iv = (Iterable)object2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection<Object> destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                ModContainer modContainer = (ModContainer)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl = false;
                collection2.add(it.getMetadata());
            }
            for (Collection<Object> destination$iv$iv2 : (Iterable)((List)destination$iv$iv2)) {
                ModMetadata it = (ModMetadata)destination$iv$iv2;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getId(), "fabricloader") || it.getProvides().contains("fabricloader"))) continue;
                collection = destination$iv$iv2;
                break block4;
            }
            collection = null;
        }
        ModMetadata modMetadata = (ModMetadata)collection;
        if (modMetadata == null) {
            object = "unknown";
        } else {
            ModMetadata it = modMetadata;
            boolean bl = false;
            object2 = it.getId() + ":" + it.getVersion().getFriendlyString();
            object = object2 == null ? "unknown" : object2;
        }
        return object;
    }

    @NotNull
    public final String getPartnerModName(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        return this.getLoadedPartnerModIds().getOrDefault(identifier, identifier);
    }

    static {
        String[] stringArray = new String[]{"level_head", "skytils", "patcher", "text_overflow_scroll", "keystrokesmod", "autogg", "autotip", "hypixel_auto_complete", "tnttime", "nick_hider", "popup_events", "sk1er-bedwars_resource_display", "motionblurmod", "compactchat", "bossbar_customizer", "sk1er_fullscreen", "cpsmod", "combat_info", "victory_royale", "mousebindfix", "lobby_sounds", "autocorrect", "better_fps_limiter", "autogl", "item_optimization", "subtitles_mod", "case_commands", "autodab", "thanosmod", "command_patcher", "hypixel_join_hider_2", "cross_chat", "mouse_sensitivity_tweak", "20_20_20", "winter_weather", "Sk1er-UHCstars", "cape_editor", "ChromaHUD"};
        PARTNER_MODS = CollectionsKt.listOf(stringArray);
    }
}

