/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.Essential;
import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.components.image.BlurHashImage;
import gg.essential.lib.caffeine.cache.AsyncLoadingCache;
import gg.essential.lib.caffeine.cache.Caffeine;
import gg.essential.util.CachedAvatarImage;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.Multithreading;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000E\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u001c\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011RA\u0010\u0015\u001a/\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00020\u0002\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0004 \f*\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00130\u00130\u0012\u00a2\u0006\u0002\b\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R5\u0010\u001a\u001a#\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00040\u00040\u0012\u00a2\u0006\u0002\b\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lgg/essential/util/CachedAvatarImage;", "", "Ljava/util/UUID;", "uuid", "Ljava/awt/image/BufferedImage;", "loadFromDisk", "(Ljava/util/UUID;)Ljava/awt/image/BufferedImage;", "loadFromWeb", "Lgg/essential/elementa/components/UIImage;", "ofUUID", "(Ljava/util/UUID;)Lgg/essential/elementa/components/UIImage;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "cacheBasePath", "Ljava/nio/file/Path;", "gg/essential/util/CachedAvatarImage$cachePath$1", "cachePath", "Lgg/essential/util/CachedAvatarImage$cachePath$1;", "Lgg/essential/lib/caffeine/cache/AsyncLoadingCache;", "Ljava/util/Optional;", "Lorg/checkerframework/checker/nullness/qual/NonNull;", "diskCache", "Lgg/essential/lib/caffeine/cache/AsyncLoadingCache;", "Lgg/essential/elementa/components/image/BlurHashImage;", "fallbackImage", "Lgg/essential/elementa/components/image/BlurHashImage;", "freshCache", "<init>", "()V", "Essential 1.19-fabric"})
public final class CachedAvatarImage {
    @NotNull
    public static final CachedAvatarImage INSTANCE = new CachedAvatarImage();
    private static final Path cacheBasePath = Essential.getInstance().getBaseDir().toPath().resolve("avatar-cache");
    @NotNull
    private static final cachePath.1 cachePath = new Object(){

        @NotNull
        public final Path get(@NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            String it = ExtensionsKt.toDashlessString(uuid);
            boolean bl = false;
            Path path = CachedAvatarImage.access$getCacheBasePath$p().resolve(String.valueOf(it.charAt(0))).resolve(String.valueOf(it.charAt(1)));
            String string = it.substring(2);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            Path path2 = path.resolve(string);
            Intrinsics.checkNotNullExpressionValue(path2, "uuid.toDashlessString().\u2026t.substring(2))\n        }");
            return path2;
        }
    };
    @NotNull
    private static final AsyncLoadingCache<UUID, BufferedImage> freshCache;
    @NotNull
    private static final AsyncLoadingCache<UUID, Optional<BufferedImage>> diskCache;
    @NotNull
    private static final BlurHashImage fallbackImage;

    private CachedAvatarImage() {
    }

    private final BufferedImage loadFromDisk(UUID uuid) {
        BufferedImage bufferedImage;
        Path path = cachePath.get(uuid);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        try {
            bufferedImage = ImageIO.read(path.toFile());
        }
        catch (Exception e) {
            Essential.logger.warn("Failed to load avatar " + uuid + " from cache: ", (Throwable)e);
            bufferedImage = null;
        }
        return bufferedImage;
    }

    private final BufferedImage loadFromWeb(UUID uuid) {
        Object e2;
        byte[] byArray;
        URL url = new URL("https://cravatar.eu/helmavatar/" + ExtensionsKt.toDashlessString(uuid));
        try {
            byArray = TextStreamsKt.readBytes(url);
        }
        catch (Exception e2) {
            Essential.logger.warn("Failed to fetch " + url + ": ", (Throwable)e2);
            return null;
        }
        byte[] bytes = byArray;
        try {
            e2 = bytes;
            e2 = ImageIO.read(new ByteArrayInputStream((byte[])e2));
        }
        catch (Exception e3) {
            Essential.logger.warn("Failed read avatar " + uuid + " image: ", (Throwable)e3);
            return null;
        }
        Object image2 = e2;
        e2 = diskCache.asMap();
        Intrinsics.checkNotNullExpressionValue(e2, "diskCache.asMap()");
        e2 = (Map)e2;
        Object object = CompletableFuture.completedFuture(Optional.of(image2));
        e2.put(uuid, object);
        try {
            Path path = cachePath.get(uuid);
            object = path.getParent();
            Intrinsics.checkNotNullExpressionValue(object, "path.parent");
            Object[] objectArray = new FileAttribute[]{};
            Path path2 = Files.createDirectories((Path)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(path2, "createDirectories(this, *attributes)");
            object = path;
            objectArray = new OpenOption[]{};
            Files.write((Path)object, bytes, (OpenOption[])Arrays.copyOf(objectArray, objectArray.length));
        }
        catch (Exception e2) {
            Essential.logger.warn("Failed to write avatar " + uuid + " cache: ", (Throwable)e2);
            return null;
        }
        return image2;
    }

    @JvmStatic
    @NotNull
    public static final UIImage ofUUID(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        CompletionStage freshFuture = freshCache.get(uuid).thenApply(CachedAvatarImage::ofUUID$lambda-2);
        if (((CompletableFuture)freshFuture).isDone()) {
            CompletableFuture completableFuture = ((CompletableFuture)freshFuture).toCompletableFuture();
            Intrinsics.checkNotNullExpressionValue(completableFuture, "freshFuture.toCompletableFuture()");
            return new UIImage(completableFuture, fallbackImage, null, 4, null);
        }
        CompletionStage diskFuture = diskCache.get(uuid).thenCompose(arg_0 -> CachedAvatarImage.ofUUID$lambda-3((CompletableFuture)freshFuture, arg_0));
        Intrinsics.checkNotNullExpressionValue(freshFuture, "freshFuture");
        Intrinsics.checkNotNullExpressionValue(diskFuture, "diskFuture");
        return new UIImage((CompletableFuture)freshFuture, new UIImage((CompletableFuture)diskFuture, fallbackImage, null, 4, null), null, 4, null);
    }

    private static final BufferedImage freshCache$lambda-0(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.loadFromWeb(it);
    }

    private static final Optional diskCache$lambda-1(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Optional.ofNullable(INSTANCE.loadFromDisk(it));
    }

    private static final BufferedImage ofUUID$lambda-2(BufferedImage it) {
        return it;
    }

    private static final CompletionStage ofUUID$lambda-3(CompletableFuture $freshFuture, Optional it) {
        return it.map(CompletableFuture::completedFuture).orElse($freshFuture);
    }

    public static final /* synthetic */ Path access$getCacheBasePath$p() {
        return cacheBasePath;
    }

    static {
        AsyncLoadingCache<UUID, Object> asyncLoadingCache = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).executor(Multithreading.POOL).buildAsync(CachedAvatarImage::freshCache$lambda-0);
        Intrinsics.checkNotNullExpressionValue(asyncLoadingCache, "newBuilder()\n        .ex\u2026oadFromWeb(it)\n        })");
        freshCache = asyncLoadingCache;
        asyncLoadingCache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).executor(Multithreading.POOL).buildAsync(CachedAvatarImage::diskCache$lambda-1);
        Intrinsics.checkNotNullExpressionValue(asyncLoadingCache, "newBuilder()\n        .ex\u2026dFromDisk(it))\n        })");
        diskCache = asyncLoadingCache;
        fallbackImage = new BlurHashImage("U9QuA+e8vyu48wVsVYkq_~tlP9Z~Y7pIyXVX");
    }
}

