/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import java.net.InetAddress;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001c\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lgg/essential/util/AddressUtil;", "", "", "address", "getFormattedAddress", "(Ljava/lang/String;)Ljava/lang/String;", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "IPV4_PATTERN", "Ljava/util/regex/Pattern;", "<init>", "()V", "Essential 1.19-fabric"})
public final class AddressUtil {
    @NotNull
    public static final AddressUtil INSTANCE = new AddressUtil();
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(?:[0-9]{1,3}\\.){3}[0-9]{1,3}$");

    private AddressUtil() {
    }

    @NotNull
    public final String getFormattedAddress(@NotNull String address) {
        Intrinsics.checkNotNullParameter(address, "address");
        String addr = address;
        if (StringsKt.endsWith$default(address, ":25565", false, 2, null)) {
            String string = address.substring(0, address.length() - ":25565".length());
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            addr = string;
        }
        if (StringsKt.equals(addr, "localhost", true) || Intrinsics.areEqual(addr, "127.0.0.1")) {
            return "Local Address";
        }
        try {
            if (IPV4_PATTERN.matcher(addr).matches() && InetAddress.getByName(address).isSiteLocalAddress()) {
                return "Local Server";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return addr;
    }
}

