/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.universal;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.utils.ReleasedDynamicTexture;
import gg.essential.universal.vertex.UVertexConsumer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5225;
import net.minecraft.class_5348;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.lwjgl.opengl.GL11;

public class UGraphics {
    private static final Pattern formattingCodePattern = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    public static class_2583 EMPTY_WITH_FONT_ID = class_2583.field_24360.method_27704(new class_2960("minecraft", "alt"));
    private static UMatrixStack UNIT_STACK = new UMatrixStack();
    public static int ZERO_TEXT_ALPHA = 10;
    private class_287 instance;
    private class_293 vertexFormat;
    private static final Map<class_293, Supplier<class_5944>> DEFAULT_SHADERS = new HashMap<class_293, Supplier<class_5944>>();
    private class_1921 renderLayer;

    public UGraphics(class_287 instance2) {
        this.instance = instance2;
    }

    public UVertexConsumer asUVertexConsumer() {
        return UVertexConsumer.of((class_4588)this.instance);
    }

    public static UGraphics getFromTessellator() {
        return new UGraphics(UGraphics.getTessellator().method_1349());
    }

    public static class_289 getTessellator() {
        return class_289.method_1348();
    }

    @Deprecated
    public static void draw() {
        UGraphics.getTessellator().method_1350();
    }

    public static void cullFace(int mode) {
        GL11.glCullFace((int)mode);
    }

    public static void enableLighting() {
    }

    public static void disableLighting() {
    }

    public static void disableLight(int mode) {
    }

    public static void enableLight(int mode) {
    }

    public static void enableBlend() {
        RenderSystem.enableBlend();
    }

    @Deprecated
    public static void disableTexture2D() {
        RenderSystem.disableTexture();
    }

    public static void disableAlpha() {
    }

    public static void shadeModel(int mode) {
    }

    public static void blendEquation(int equation) {
        RenderSystem.blendEquation((int)equation);
    }

    public static void tryBlendFuncSeparate(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        RenderSystem.blendFuncSeparate((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
    }

    @Deprecated
    public static void enableTexture2D() {
        RenderSystem.enableTexture();
    }

    public static void disableBlend() {
        RenderSystem.disableBlend();
    }

    public static void deleteTexture(int glTextureId) {
        RenderSystem.deleteTexture((int)glTextureId);
    }

    public static void enableAlpha() {
    }

    public static void configureTexture(int glTextureId, Runnable block) {
        int prevTextureBinding = GL11.glGetInteger((int)32873);
        RenderSystem.bindTexture((int)glTextureId);
        block.run();
        RenderSystem.bindTexture((int)prevTextureBinding);
    }

    public static void configureTextureUnit(int index2, Runnable block) {
        int prevActiveTexture = UGraphics.getActiveTexture();
        UGraphics.setActiveTexture(33984 + index2);
        block.run();
        UGraphics.setActiveTexture(prevActiveTexture);
    }

    @Deprecated
    public static void activeTexture(int glId) {
        UGraphics.setActiveTexture(glId);
    }

    public static int getActiveTexture() {
        return GL11.glGetInteger((int)34016);
    }

    public static void setActiveTexture(int glId) {
        GlStateManager._activeTexture((int)glId);
    }

    @Deprecated
    public static void bindTexture(int glTextureId) {
        RenderSystem.setShaderTexture((int)(GlStateManager._getActiveTexture() - 33984), (int)glTextureId);
    }

    @Deprecated
    public static void bindTexture(class_2960 resourceLocation) {
        UGraphics.bindTexture(UGraphics.getOrLoadTextureId(resourceLocation));
    }

    public static void bindTexture(int index2, int glTextureId) {
        RenderSystem.setShaderTexture((int)index2, (int)glTextureId);
    }

    public static void bindTexture(int index2, class_2960 resourceLocation) {
        UGraphics.bindTexture(index2, UGraphics.getOrLoadTextureId(resourceLocation));
    }

    private static int getOrLoadTextureId(class_2960 resourceLocation) {
        class_1060 textureManager = UMinecraft.getMinecraft().method_1531();
        class_1044 texture = textureManager.method_4619(resourceLocation);
        if (texture == null) {
            texture = new class_1049(resourceLocation);
            textureManager.method_4616(resourceLocation, texture);
        }
        return texture.method_4624();
    }

    public static int getStringWidth(String in) {
        return UMinecraft.getFontRenderer().method_1727(in);
    }

    public static int getFontHeight() {
        Objects.requireNonNull(UMinecraft.getFontRenderer());
        return 9;
    }

    @Deprecated
    public static void drawString(String text, float x, float y, int color, boolean shadow) {
        UGraphics.drawString(UNIT_STACK, text, x, y, color, shadow);
    }

    public static void drawString(UMatrixStack stack, String text, float x, float y, int color, boolean shadow) {
        if ((color >> 24 & 0xFF) <= 10) {
            return;
        }
        class_4597.class_4598 irendertypebuffer$impl = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        UMinecraft.getFontRenderer().method_27521(text, x, y, color, shadow, stack.peek().getModel(), (class_4597)irendertypebuffer$impl, false, 0, 0xF000F0);
        irendertypebuffer$impl.method_22993();
    }

    @Deprecated
    public static void drawString(String text, float x, float y, int color, int shadowColor) {
        UGraphics.drawString(UNIT_STACK, text, x, y, color, shadowColor);
    }

    public static void drawString(UMatrixStack stack, String text, float x, float y, int color, int shadowColor) {
        if ((color >> 24 & 0xFF) <= 10) {
            return;
        }
        class_4597.class_4598 irendertypebuffer$impl = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        UMinecraft.getFontRenderer().method_27521(text, x + 1.0f, y + 1.0f, shadowColor, false, stack.peek().getModel(), (class_4597)irendertypebuffer$impl, false, 0, 0xF000F0);
        UMinecraft.getFontRenderer().method_27521(text, x, y, color, false, stack.peek().getModel(), (class_4597)irendertypebuffer$impl, false, 0, 0xF000F0);
        irendertypebuffer$impl.method_22993();
    }

    public static List<String> listFormattedStringToWidth(String str, int wrapWidth) {
        return UGraphics.listFormattedStringToWidth(str, wrapWidth, true);
    }

    public static List<String> listFormattedStringToWidth(String str, int wrapWidth, boolean safe) {
        if (safe) {
            String tmp = formattingCodePattern.matcher(str).replaceAll("");
            int max = 0;
            for (String s : tmp.split(" ")) {
                max = Math.max(max, UGraphics.getStringWidth(s));
            }
            wrapWidth = Math.max(max, wrapWidth);
        }
        ArrayList<String> strings = new ArrayList<String>();
        class_5225 charManager = UMinecraft.getFontRenderer().method_27527();
        class_5348 properties2 = charManager.method_27490((class_5348)class_2561.method_43470((String)str).method_27696(EMPTY_WITH_FONT_ID), wrapWidth, class_2583.field_24360);
        properties2.method_27657(string -> {
            strings.add(string);
            return Optional.empty();
        });
        return strings;
    }

    public static float getCharWidth(char character) {
        return UGraphics.getStringWidth(String.valueOf(character));
    }

    public static void glClear(int mode) {
        GL11.glClear((int)mode);
    }

    public static void glClearStencil(int mode) {
        GL11.glClearStencil((int)mode);
    }

    public static ReleasedDynamicTexture getTexture(InputStream stream) {
        try {
            return new ReleasedDynamicTexture(class_1011.method_4309((InputStream)stream));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to read image");
        }
    }

    public static ReleasedDynamicTexture getTexture(BufferedImage img) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", baos);
            return new ReleasedDynamicTexture(class_1011.method_4309((InputStream)new ByteArrayInputStream(baos.toByteArray())));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to create texture");
        }
    }

    public static ReleasedDynamicTexture getEmptyTexture() {
        return new ReleasedDynamicTexture(0, 0);
    }

    public static void glUseProgram(int program) {
        GlStateManager._glUseProgram((int)program);
    }

    public static boolean isOpenGl21Supported() {
        return true;
    }

    public static boolean areShadersSupported() {
        return true;
    }

    public static int glCreateProgram() {
        return GlStateManager.glCreateProgram();
    }

    public static int glCreateShader(int type2) {
        return GlStateManager.glCreateShader((int)type2);
    }

    public static void glCompileShader(int shaderIn) {
        GlStateManager.glCompileShader((int)shaderIn);
    }

    public static int glGetShaderi(int shaderIn, int pname) {
        return GlStateManager.glGetShaderi((int)shaderIn, (int)pname);
    }

    public static String glGetShaderInfoLog(int shader, int maxLen) {
        return GlStateManager.glGetShaderInfoLog((int)shader, (int)maxLen);
    }

    public static void glAttachShader(int program, int shaderIn) {
        GlStateManager.glAttachShader((int)program, (int)shaderIn);
    }

    public static void glLinkProgram(int program) {
        GlStateManager.glLinkProgram((int)program);
    }

    public static int glGetProgrami(int program, int pname) {
        return GlStateManager.glGetProgrami((int)program, (int)pname);
    }

    public static String glGetProgramInfoLog(int program, int maxLen) {
        return GlStateManager.glGetProgramInfoLog((int)program, (int)maxLen);
    }

    public static void color4f(float red, float green, float blue, float alpha) {
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void directColor3f(float red, float green, float blue) {
        UGraphics.color4f(red, green, blue, 1.0f);
    }

    public static void enableDepth() {
        RenderSystem.enableDepthTest();
    }

    public static void depthFunc(int mode) {
        RenderSystem.depthFunc((int)mode);
    }

    public static void depthMask(boolean flag) {
        RenderSystem.depthMask((boolean)flag);
    }

    public static void disableDepth() {
        RenderSystem.disableDepthTest();
    }

    public static void setShader(Supplier<class_5944> shader) {
        RenderSystem.setShader(shader);
    }

    public UGraphics beginWithActiveShader(DrawMode mode, CommonVertexFormats format) {
        return this.beginWithActiveShader(mode, format.mc);
    }

    public UGraphics beginWithActiveShader(DrawMode mode, class_293 format) {
        this.vertexFormat = format;
        this.instance.method_1328(mode.mcMode, format);
        return this;
    }

    public UGraphics beginWithDefaultShader(DrawMode mode, CommonVertexFormats format) {
        return this.beginWithDefaultShader(mode, format.mc);
    }

    public UGraphics beginWithDefaultShader(DrawMode mode, class_293 format) {
        Supplier<class_5944> supplier = DEFAULT_SHADERS.get(format);
        if (supplier == null) {
            throw new IllegalArgumentException("No default shader for " + format + ". Bind your own and use beginWithActiveShader instead.");
        }
        UGraphics.setShader(supplier);
        return this.beginWithActiveShader(mode, format);
    }

    public UGraphics beginRenderLayer(class_1921 renderLayer) {
        this.renderLayer = renderLayer;
        this.beginWithActiveShader(DrawMode.fromRenderLayer(renderLayer), renderLayer.method_23031());
        return this;
    }

    @Deprecated
    public UGraphics begin(int glMode, CommonVertexFormats format) {
        return this.begin(glMode, format.mc);
    }

    @Deprecated
    public UGraphics begin(int glMode, class_293 format) {
        this.beginWithDefaultShader(DrawMode.fromGl(glMode), format);
        return this;
    }

    public void drawDirect() {
        if (this.renderLayer != null) {
            this.renderLayer.method_23012(this.instance, 0, 0, 0);
            return;
        }
        this.doDraw();
    }

    public void drawSorted(int cameraX, int cameraY, int cameraZ) {
        if (this.renderLayer != null) {
            this.renderLayer.method_23012(this.instance, cameraX, cameraY, cameraZ);
            return;
        }
        this.instance.method_31948((float)cameraX, (float)cameraY, (float)cameraZ);
        this.doDraw();
    }

    private static boolean[] getDesiredTextureUnitState(class_293 vertexFormat) {
        boolean[] wantEnabled = new boolean[2];
        for (class_296 element : vertexFormat.method_1357()) {
            if (element.method_1382() != class_296.class_298.field_1636) continue;
            int index2 = element.method_1385();
            if (wantEnabled.length <= index2) {
                wantEnabled = Arrays.copyOf(wantEnabled, index2 + 1);
            }
            wantEnabled[index2] = true;
        }
        return wantEnabled;
    }

    private void doDraw() {
        class_293 vertexFormat = this.vertexFormat;
        if (vertexFormat == null) {
            UGraphics.getTessellator().method_1350();
            return;
        }
        UGraphics.getTessellator().method_1350();
    }

    @Deprecated
    public UGraphics pos(double x, double y, double z) {
        return this.pos(UNIT_STACK, x, y, z);
    }

    public UGraphics pos(UMatrixStack stack, double x, double y, double z) {
        this.instance.method_22918(stack.peek().getModel(), (float)x, (float)y, (float)z);
        return this;
    }

    @Deprecated
    public UGraphics norm(float x, float y, float z) {
        return this.norm(UNIT_STACK, x, y, z);
    }

    public UGraphics norm(UMatrixStack stack, float x, float y, float z) {
        this.instance.method_23763(stack.peek().getNormal(), x, y, z);
        return this;
    }

    public UGraphics color(int red, int green, int blue, int alpha) {
        return this.color((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public UGraphics color(float red, float green, float blue, float alpha) {
        this.instance.method_22915(red, green, blue, alpha);
        return this;
    }

    public UGraphics color(Color color) {
        return this.color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public UGraphics endVertex() {
        this.instance.method_1344();
        return this;
    }

    public UGraphics tex(double u, double v) {
        this.instance.method_22913((float)u, (float)v);
        return this;
    }

    public UGraphics overlay(int u, int v) {
        this.instance.method_22917(u, v);
        return this;
    }

    public UGraphics light(int u, int v) {
        this.instance.method_22921(u, v);
        return this;
    }

    static {
        DEFAULT_SHADERS.put(class_290.field_29337, class_757::method_34535);
        DEFAULT_SHADERS.put(class_290.field_1584, class_757::method_34546);
        DEFAULT_SHADERS.put(class_290.field_1592, class_757::method_34539);
        DEFAULT_SHADERS.put(class_290.field_1576, class_757::method_34540);
        DEFAULT_SHADERS.put(class_290.field_21468, class_757::method_34547);
        DEFAULT_SHADERS.put(class_290.field_1585, class_757::method_34542);
        DEFAULT_SHADERS.put(class_290.field_20887, class_757::method_34541);
        DEFAULT_SHADERS.put(class_290.field_1575, class_757::method_34543);
        DEFAULT_SHADERS.put(class_290.field_20888, class_757::method_34548);
        DEFAULT_SHADERS.put(class_290.field_1586, class_757::method_35764);
        DEFAULT_SHADERS.put(class_290.field_1577, class_757::method_34549);
    }

    public static enum CommonVertexFormats {
        POSITION(class_290.field_1592),
        POSITION_COLOR(class_290.field_1576),
        POSITION_TEXTURE(class_290.field_1585),
        POSITION_TEXTURE_COLOR(class_290.field_1575),
        POSITION_COLOR_TEXTURE_LIGHT(class_290.field_1590),
        POSITION_TEXTURE_LIGHT_COLOR(class_290.field_1586),
        POSITION_TEXTURE_COLOR_LIGHT(class_290.field_1584),
        POSITION_TEXTURE_COLOR_NORMAL(class_290.field_1577);

        private final class_293 mc;

        private CommonVertexFormats(class_293 mc) {
            this.mc = mc;
        }
    }

    public static enum DrawMode {
        LINES(1),
        LINE_STRIP(3),
        TRIANGLES(4),
        TRIANGLE_STRIP(5),
        TRIANGLE_FAN(6),
        QUADS(7);

        private final int glMode;
        private final class_293.class_5596 mcMode;

        private DrawMode(int glMode) {
            this.glMode = glMode;
            this.mcMode = DrawMode.glToMcDrawMode(glMode);
        }

        private static class_293.class_5596 glToMcDrawMode(int glMode) {
            switch (glMode) {
                case 1: {
                    return class_293.class_5596.field_27377;
                }
                case 3: {
                    return class_293.class_5596.field_27378;
                }
                case 4: {
                    return class_293.class_5596.field_27379;
                }
                case 5: {
                    return class_293.class_5596.field_27380;
                }
                case 6: {
                    return class_293.class_5596.field_27381;
                }
                case 7: {
                    return class_293.class_5596.field_27382;
                }
            }
            throw new IllegalArgumentException("Unsupported draw mode " + glMode);
        }

        private static DrawMode fromMc(class_293.class_5596 mcMode) {
            switch (mcMode) {
                case field_27377: {
                    return LINES;
                }
                case field_27378: {
                    return LINE_STRIP;
                }
                case field_27379: {
                    return TRIANGLES;
                }
                case field_27380: {
                    return TRIANGLE_STRIP;
                }
                case field_27381: {
                    return TRIANGLE_FAN;
                }
                case field_27382: {
                    return QUADS;
                }
            }
            throw new IllegalArgumentException("Unsupported draw mode " + mcMode);
        }

        public static DrawMode fromGl(int glMode) {
            switch (glMode) {
                case 1: {
                    return LINES;
                }
                case 3: {
                    return LINE_STRIP;
                }
                case 4: {
                    return TRIANGLES;
                }
                case 5: {
                    return TRIANGLE_STRIP;
                }
                case 6: {
                    return TRIANGLE_FAN;
                }
                case 7: {
                    return QUADS;
                }
            }
            throw new IllegalArgumentException("Unsupported draw mode " + glMode);
        }

        public static DrawMode fromRenderLayer(class_1921 renderLayer) {
            return DrawMode.fromMc(renderLayer.method_23033());
        }
    }
}

