/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.cosmetics.dev;

import com.google.common.collect.ImmutableMap;
import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.cosmetics.CosmeticSlot;
import gg.essential.cosmetics.SkinLayer;
import gg.essential.cosmetics.model.Cosmetic;
import gg.essential.cosmetics.model.CosmeticAssets;
import gg.essential.cosmetics.model.CosmeticGeometry;
import gg.essential.cosmetics.model.CosmeticSetting;
import gg.essential.cosmetics.model.CosmeticSkinMask;
import gg.essential.cosmetics.model.CosmeticType;
import gg.essential.gui.common.EmulatedUI3DPlayer;
import gg.essential.gui.studio.CosmeticStudio;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.model.EssentialAsset;
import gg.essential.model.ModelInstance;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.network.cosmetics.dev.DevCosmetics;
import gg.essential.util.ExtensionsKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0017\u0012\u0006\u0010.\u001a\u00020\u0014\u0012\u0006\u00101\u001a\u00020\u0002\u00a2\u0006\u0004\b=\u0010>J'\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\f\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0016\u001a\u00020\u0007*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001b\u0010\u001b\u001a\u00020\u001a*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001b\u0010\u001f\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0013\u0010\"\u001a\u00020!*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010$\u001a\u0004\u0018\u00010!*\u00020\u0002H\u0002\u00a2\u0006\u0004\b$\u0010#R \u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020&0%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R \u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R \u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010(R\u0014\u0010.\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R \u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u0010(R\u0014\u00101\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R.\u00104\u001a\u001c\u0012\u0004\u0012\u00020\u0004\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\u0010030%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u0010(R&\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020&0)8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b5\u0010(\u001a\u0004\b6\u0010+R\u0014\u00108\u001a\u0002078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u001c\u0010;\u001a\n \u001e*\u0004\u0018\u00010:0:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<\u00a8\u0006@"}, d2={"Lgg/essential/network/cosmetics/dev/DevCosmeticsImpl;", "Lgg/essential/network/cosmetics/dev/DevCosmetics;", "Ljava/nio/file/Path;", "path", "", "fileId", "cosmeticType", "", "loadCosmetic", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;)V", "Ljava/nio/file/WatchEvent$Kind;", "kind", "processEvent", "(Ljava/nio/file/Path;Ljava/nio/file/WatchEvent$Kind;)V", "processEvents", "()V", "Lgg/essential/cosmetics/model/Cosmetic;", "liveCosmetic", "substitute", "(Lgg/essential/cosmetics/model/Cosmetic;)Lgg/essential/cosmetics/model/Cosmetic;", "Lgg/essential/network/connectionmanager/cosmetics/CosmeticsManager;", "type", "addCosmeticTypeIfMissing", "(Lgg/essential/network/connectionmanager/cosmetics/CosmeticsManager;Ljava/lang/String;)V", "Lgg/essential/cosmetics/model/CosmeticAssets;", "other", "", "hashesEqual", "(Lgg/essential/cosmetics/model/CosmeticAssets;Lgg/essential/cosmetics/model/CosmeticAssets;)Z", "Ljava/nio/file/WatchKey;", "kotlin.jvm.PlatformType", "registerCMD", "(Ljava/nio/file/Path;)Ljava/nio/file/WatchKey;", "Lgg/essential/model/EssentialAsset;", "toAsset", "(Ljava/nio/file/Path;)Lgg/essential/model/EssentialAsset;", "toAssetOrNull", "", "Lgg/essential/cosmetics/model/CosmeticType;", "_types", "Ljava/util/Map;", "", "getAll", "()Ljava/util/Map;", "all", "keys", "manager", "Lgg/essential/network/connectionmanager/cosmetics/CosmeticsManager;", "originalCosmetics", "rootPath", "Ljava/nio/file/Path;", "Lkotlin/Function1;", "substitutions", "types", "getTypes", "Ljava/lang/Thread;", "updateThread", "Ljava/lang/Thread;", "Ljava/nio/file/WatchService;", "watchService", "Ljava/nio/file/WatchService;", "<init>", "(Lgg/essential/network/connectionmanager/cosmetics/CosmeticsManager;Ljava/nio/file/Path;)V", "Companion", "Essential 1.19-fabric"})
public final class DevCosmeticsImpl
implements DevCosmetics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CosmeticsManager manager;
    @NotNull
    private final Path rootPath;
    @NotNull
    private final Thread updateThread;
    private final WatchService watchService;
    @NotNull
    private final Map<WatchKey, Path> keys;
    @NotNull
    private final Map<String, Cosmetic> originalCosmetics;
    @NotNull
    private final Map<String, Function1<Cosmetic, Cosmetic>> substitutions;
    @NotNull
    private final Map<String, CosmeticType> _types;
    @NotNull
    private final Map<String, CosmeticType> types;
    private static final Logger LOGGER = LogManager.getLogger(DevCosmeticsImpl.class);

    public DevCosmeticsImpl(@NotNull CosmeticsManager manager, @NotNull Path rootPath) throws IOException {
        Intrinsics.checkNotNullParameter(manager, "manager");
        Intrinsics.checkNotNullParameter(rootPath, "rootPath");
        this.manager = manager;
        this.rootPath = rootPath;
        this.updateThread = new Thread(() -> DevCosmeticsImpl.updateThread$lambda-0(this), "essential-dev-cosmetics-watcher");
        this.watchService = this.rootPath.getFileSystem().newWatchService();
        this.keys = new LinkedHashMap();
        this.originalCosmetics = new LinkedHashMap();
        this.substitutions = new LinkedHashMap();
        this._types = new LinkedHashMap();
        this.types = this._types;
        WatchEvent.Kind<Path> kind = StandardWatchEventKinds.ENTRY_CREATE;
        Intrinsics.checkNotNullExpressionValue(kind, "ENTRY_CREATE");
        this.processEvent(this.rootPath, kind);
        this.updateThread.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Cosmetic> getAll() {
        void $this$mapValuesTo$iv$iv;
        Map<String, Function1<Cosmetic, Cosmetic>> $this$mapValues$iv = this.substitutions;
        boolean $i$f$mapValues = false;
        Map<String, Function1<Cosmetic, Cosmetic>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $dstr$id$func;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String id2 = (String)$dstr$id$func.getKey();
            Function1 func = (Function1)$dstr$id$func.getValue();
            Cosmetic cosmetic = (Cosmetic)func.invoke(this.manager.getCosmetics().get(id2));
            map4.put(k, cosmetic);
        }
        return destination$iv$iv;
    }

    @Override
    @NotNull
    public Map<String, CosmeticType> getTypes() {
        return this.types;
    }

    private final void processEvents() {
        while (true) {
            WatchKey key;
            if (this.keys.get(key = this.watchService.take()) == null) {
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                Path dir;
                WatchEvent.Kind<?> kind = event.kind();
                Object obj = event.context();
                if (obj == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.nio.file.Path");
                }
                Path name = (Path)obj;
                Path path = dir.resolve(name);
                Intrinsics.checkNotNullExpressionValue(path, "path");
                Intrinsics.checkNotNullExpressionValue(kind, "kind");
                this.processEvent(path, kind);
            }
            key.reset();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processEvent(Path path, WatchEvent.Kind<?> kind) {
        Object it;
        Path relPath = PathsKt.relativeTo(path, this.rootPath);
        int depth = relPath.getNameCount();
        WatchEvent.Kind<?> kind2 = kind;
        if (Intrinsics.areEqual(kind2, StandardWatchEventKinds.ENTRY_CREATE)) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                this.registerCMD(path);
                if (depth == 3) {
                    Path path2 = (Path)CollectionsKt.firstOrNull(PathsKt.listDirectoryEntries$default(path, null, 1, null));
                    if (path2 != null) {
                        it = path2;
                        boolean bl = false;
                        WatchEvent.Kind<Path> kind3 = StandardWatchEventKinds.ENTRY_CREATE;
                        Intrinsics.checkNotNullExpressionValue(kind3, "ENTRY_CREATE");
                        this.processEvent((Path)it, kind3);
                    }
                } else {
                    Iterable $this$forEach$iv = PathsKt.listDirectoryEntries$default(path, null, 1, null);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Path it2 = (Path)element$iv;
                        boolean bl = false;
                        WatchEvent.Kind<Path> kind4 = StandardWatchEventKinds.ENTRY_CREATE;
                        Intrinsics.checkNotNullExpressionValue(kind4, "ENTRY_CREATE");
                        this.processEvent(it2, kind4);
                    }
                }
            }
        } else if (Intrinsics.areEqual(kind2, StandardWatchEventKinds.ENTRY_DELETE)) {
            this.keys.entrySet().removeIf(arg_0 -> DevCosmeticsImpl.processEvent$lambda-4(path, arg_0));
        }
        if (depth == 4) {
            Path $this$mapTo$iv$iv;
            Iterable $this$map$iv = relPath;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                Path path3 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it3.toString());
            }
            kind2 = (List)destination$iv$iv;
            String cosmeticType = (String)kind2.get(1);
            String id2 = (String)kind2.get(2);
            try {
                $this$mapTo$iv$iv = path.getParent();
                Intrinsics.checkNotNullExpressionValue($this$mapTo$iv$iv, "path.parent");
                this.loadCosmetic($this$mapTo$iv$iv, id2, cosmeticType);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load " + path.getParent() + ":", (Throwable)e);
            }
        }
    }

    private final void loadCosmetic(Path path, String fileId, String cosmeticType) {
        LOGGER.info("Loading " + path);
        Object object = fileId.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(object, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        String cosmeticId = object;
        object = path.resolve(fileId + ".thumbnail.png");
        Intrinsics.checkNotNullExpressionValue(object, "path.resolve(\"$fileId.thumbnail.png\")");
        EssentialAsset essentialAsset = this.toAsset((Path)object);
        object = path.resolve(fileId + ".texture.png");
        Intrinsics.checkNotNullExpressionValue(object, "path.resolve(\"$fileId.texture.png\")");
        EssentialAsset essentialAsset2 = this.toAsset((Path)object);
        object = path.resolve(fileId + ".geometry.steve.json");
        Intrinsics.checkNotNullExpressionValue(object, "path.resolve(\"$fileId.geometry.steve.json\")");
        EssentialAsset essentialAsset3 = this.toAsset((Path)object);
        object = path.resolve(fileId + ".geometry.alex.json");
        Intrinsics.checkNotNullExpressionValue(object, "path.resolve(\"$fileId.geometry.alex.json\")");
        CosmeticGeometry cosmeticGeometry = new CosmeticGeometry(essentialAsset3, this.toAssetOrNull((Path)object));
        object = path.resolve(fileId + ".animations.json");
        Intrinsics.checkNotNullExpressionValue(object, "path.resolve(\"$fileId.animations.json\")");
        EssentialAsset essentialAsset4 = this.toAssetOrNull((Path)object);
        object = path.resolve(fileId + ".skin_mask.steve.png");
        Intrinsics.checkNotNullExpressionValue(object, "path.resolve(\"$fileId.skin_mask.steve.png\")");
        EssentialAsset essentialAsset5 = this.toAssetOrNull((Path)object);
        object = path.resolve(fileId + ".skin_mask.alex.png");
        Intrinsics.checkNotNullExpressionValue(object, "path.resolve(\"$fileId.skin_mask.alex.png\")");
        CosmeticAssets assets = new CosmeticAssets(essentialAsset, essentialAsset2, cosmeticGeometry, essentialAsset4, new CosmeticSkinMask(essentialAsset5, this.toAssetOrNull((Path)object)));
        Function1 substitution2 = new Function1<Cosmetic, Cosmetic>(this, assets, cosmeticId, cosmeticType, fileId){
            final /* synthetic */ DevCosmeticsImpl this$0;
            final /* synthetic */ CosmeticAssets $assets;
            final /* synthetic */ String $cosmeticId;
            final /* synthetic */ String $cosmeticType;
            final /* synthetic */ String $fileId;
            {
                this.this$0 = $receiver;
                this.$assets = $assets;
                this.$cosmeticId = $cosmeticId;
                this.$cosmeticType = $cosmeticType;
                this.$fileId = $fileId;
                super(1);
            }

            @NotNull
            public final Cosmetic invoke(@Nullable Cosmetic oldCosmetic) {
                int n;
                CosmeticSetting[] cosmeticSettingArray;
                Object object;
                if (oldCosmetic != null && oldCosmetic.getAssets() != null) {
                    object = oldCosmetic.getAssets();
                    if (object == null ? false : DevCosmeticsImpl.access$hashesEqual(this.this$0, (CosmeticAssets)object, this.$assets)) {
                        return oldCosmetic;
                    }
                    object = DevCosmeticsImpl.access$getOriginalCosmetics$p(this.this$0);
                    String string = oldCosmetic.getId();
                    Intrinsics.checkNotNullExpressionValue(string, "oldCosmetic.id");
                    object.put(string, oldCosmetic);
                }
                Cosmetic cosmetic = oldCosmetic;
                String string = cosmetic == null ? null : cosmetic.getType();
                if (string == null) {
                    string = this.$cosmeticType;
                }
                Cosmetic cosmetic2 = oldCosmetic;
                Map<String, String> map2 = cosmetic2 == null ? null : cosmetic2.getDisplayNames();
                if (map2 == null) {
                    map2 = MapsKt.mapOf(TuplesKt.to("en_us", this.$fileId));
                }
                Cosmetic cosmetic3 = oldCosmetic;
                Object object2 = object = cosmetic3 == null ? null : cosmetic3.getSettings();
                if (object == null) {
                    boolean $i$f$emptyArray = false;
                    cosmeticSettingArray = new CosmeticSetting[]{};
                } else {
                    cosmeticSettingArray = object;
                }
                Cosmetic cosmetic4 = oldCosmetic;
                int n2 = cosmetic4 == null ? 0 : (n = cosmetic4.getStorePackageId());
                Cosmetic cosmetic5 = oldCosmetic;
                Map<String, Double> map3 = cosmetic5 == null ? null : cosmetic5.getPrices();
                if (map3 == null) {
                    map3 = MapsKt.emptyMap();
                }
                Cosmetic cosmetic6 = oldCosmetic;
                Set<String> set = cosmetic6 == null ? null : cosmetic6.getTags();
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Set<String> set2 = SetsKt.plus(set, (Iterable)SetsKt.setOf("LOCAL"));
                Cosmetic cosmetic7 = oldCosmetic;
                DateTime dateTime = cosmetic7 == null ? null : cosmetic7.getCreatedAt();
                if (dateTime == null) {
                    dateTime = new DateTime();
                }
                DateTime dateTime2 = new DateTime();
                Cosmetic cosmetic8 = oldCosmetic;
                Map<SkinLayer, Boolean> map4 = cosmetic8 == null ? null : cosmetic8.getSkinLayers();
                if (map4 == null) {
                    map4 = MapsKt.emptyMap();
                }
                return new Cosmetic(this.$cosmeticId, string, map2, this.$assets, cosmeticSettingArray, n2, map3, set2, dateTime, dateTime2, null, map4);
            }
        };
        if (Intrinsics.areEqual(Thread.currentThread(), this.updateThread)) {
            class_310 class_3102 = class_310.method_1551();
            Intrinsics.checkNotNullExpressionValue(class_3102, "getInstance()");
            ExtensionsKt.getExecutor(class_3102).execute(() -> DevCosmeticsImpl.loadCosmetic$lambda-7(this, cosmeticId, substitution2, cosmeticType));
        } else {
            this.substitutions.put(cosmeticId, substitution2);
            this.addCosmeticTypeIfMissing(this.manager, cosmeticType);
            this.manager.addUnlockedCosmetics((Collection<String>)CollectionsKt.listOf(cosmeticId));
        }
    }

    @Override
    @NotNull
    public Cosmetic substitute(@NotNull Cosmetic liveCosmetic) {
        Cosmetic cosmetic;
        Intrinsics.checkNotNullParameter(liveCosmetic, "liveCosmetic");
        Function1<Cosmetic, Cosmetic> function1 = this.substitutions.get(liveCosmetic.getId());
        if (function1 == null) {
            cosmetic = liveCosmetic;
        } else {
            Function1<Cosmetic, Cosmetic> it = function1;
            boolean bl = false;
            Cosmetic cosmetic2 = it.invoke(liveCosmetic);
            cosmetic = cosmetic2;
            if (cosmetic2 == null) {
                cosmetic = liveCosmetic;
            }
        }
        return cosmetic;
    }

    private final EssentialAsset toAsset(Path $this$toAsset) {
        EssentialAsset essentialAsset;
        EssentialAsset essentialAsset2 = this.toAssetOrNull($this$toAsset);
        if (essentialAsset2 == null) {
            EssentialAsset essentialAsset3;
            EssentialAsset it = essentialAsset3 = new EssentialAsset($this$toAsset.toUri().toURL().toString(), "missing");
            boolean bl = false;
            LOGGER.warn("Missing " + $this$toAsset);
            essentialAsset = essentialAsset3;
        } else {
            essentialAsset = essentialAsset2;
        }
        return essentialAsset;
    }

    private final EssentialAsset toAssetOrNull(Path $this$toAssetOrNull) {
        if (Files.notExists($this$toAssetOrNull, new LinkOption[0])) {
            return null;
        }
        byte[] byArray = Files.readAllBytes($this$toAssetOrNull);
        Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(this)");
        byte[] bytes = byArray;
        String checksum = this.manager.supplyAssetBytes(bytes);
        return new EssentialAsset($this$toAssetOrNull.toUri().toURL().toString(), checksum);
    }

    private final void addCosmeticTypeIfMissing(CosmeticsManager $this$addCosmeticTypeIfMissing, String type2) {
        CosmeticType cosmeticType = $this$addCosmeticTypeIfMissing.getCosmeticType(type2);
        if (cosmeticType == null) {
            cosmeticType = new CosmeticType(type2, CosmeticSlot.SUITS, MapsKt.mapOf(TuplesKt.to("en_us", type2)), MapsKt.emptyMap());
        }
        CosmeticType cosmeticType2 = cosmeticType;
        $this$addCosmeticTypeIfMissing.addCosmeticType(cosmeticType2);
        this._types.put(type2, cosmeticType2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hashesEqual(CosmeticAssets $this$hashesEqual, CosmeticAssets other) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        EssentialAsset essentialAsset2 = $this$hashesEqual.getThumbnail();
        essentialAsset2 = other.getThumbnail();
        if (!Intrinsics.areEqual(essentialAsset == null ? null : essentialAsset.getChecksum(), essentialAsset2 == null ? null : essentialAsset2.getChecksum())) return false;
        EssentialAsset essentialAsset4 = $this$hashesEqual.getTexture();
        essentialAsset4 = other.getTexture();
        if (!Intrinsics.areEqual(essentialAsset3 == null ? null : essentialAsset3.getChecksum(), essentialAsset4 == null ? null : essentialAsset4.getChecksum())) return false;
        CosmeticGeometry cosmeticGeometry = $this$hashesEqual.getGeometry();
        if (cosmeticGeometry == null) {
            string8 = null;
        } else {
            EssentialAsset essentialAsset5 = cosmeticGeometry.getSteve();
            string8 = essentialAsset5 == null ? null : essentialAsset5.getChecksum();
        }
        CosmeticGeometry cosmeticGeometry2 = other.getGeometry();
        if (cosmeticGeometry2 == null) {
            string7 = null;
        } else {
            EssentialAsset essentialAsset6 = cosmeticGeometry2.getSteve();
            string7 = essentialAsset6 == null ? null : essentialAsset6.getChecksum();
        }
        if (!Intrinsics.areEqual(string8, string7)) return false;
        CosmeticGeometry cosmeticGeometry3 = $this$hashesEqual.getGeometry();
        if (cosmeticGeometry3 == null) {
            string6 = null;
        } else {
            EssentialAsset essentialAsset7 = cosmeticGeometry3.getAlex();
            string6 = essentialAsset7 == null ? null : essentialAsset7.getChecksum();
        }
        CosmeticGeometry cosmeticGeometry4 = other.getGeometry();
        if (cosmeticGeometry4 == null) {
            string5 = null;
        } else {
            EssentialAsset essentialAsset8 = cosmeticGeometry4.getAlex();
            string5 = essentialAsset8 == null ? null : essentialAsset8.getChecksum();
        }
        if (!Intrinsics.areEqual(string6, string5)) return false;
        EssentialAsset essentialAsset10 = $this$hashesEqual.getAnimations();
        essentialAsset10 = other.getAnimations();
        if (!Intrinsics.areEqual(essentialAsset9 == null ? null : essentialAsset9.getChecksum(), essentialAsset10 == null ? null : essentialAsset10.getChecksum())) return false;
        CosmeticSkinMask cosmeticSkinMask = $this$hashesEqual.getSkinMask();
        if (cosmeticSkinMask == null) {
            string4 = null;
        } else {
            EssentialAsset essentialAsset11 = cosmeticSkinMask.getSteve();
            string4 = essentialAsset11 == null ? null : essentialAsset11.getChecksum();
        }
        CosmeticSkinMask cosmeticSkinMask2 = other.getSkinMask();
        if (cosmeticSkinMask2 == null) {
            string3 = null;
        } else {
            EssentialAsset essentialAsset12 = cosmeticSkinMask2.getSteve();
            string3 = essentialAsset12 == null ? null : essentialAsset12.getChecksum();
        }
        if (!Intrinsics.areEqual(string4, string3)) return false;
        CosmeticSkinMask cosmeticSkinMask3 = $this$hashesEqual.getSkinMask();
        if (cosmeticSkinMask3 == null) {
            string2 = null;
        } else {
            EssentialAsset essentialAsset13 = cosmeticSkinMask3.getAlex();
            string2 = essentialAsset13 == null ? null : essentialAsset13.getChecksum();
        }
        CosmeticSkinMask cosmeticSkinMask4 = other.getSkinMask();
        if (cosmeticSkinMask4 == null) {
            string = null;
        } else {
            EssentialAsset essentialAsset14 = cosmeticSkinMask4.getAlex();
            string = essentialAsset14 == null ? null : essentialAsset14.getChecksum();
        }
        if (!Intrinsics.areEqual(string2, string)) return false;
        return true;
    }

    private final WatchKey registerCMD(Path $this$registerCMD) {
        Object object = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};
        Object it = object = $this$registerCMD.register(this.watchService, (WatchEvent.Kind<?>)object);
        boolean bl = false;
        Map<WatchKey, Path> map2 = this.keys;
        Intrinsics.checkNotNullExpressionValue(it, "it");
        Object object2 = it;
        map2.put((WatchKey)object2, $this$registerCMD);
        return object;
    }

    private static final void updateThread$lambda-0(DevCosmeticsImpl this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.processEvents();
    }

    private static final boolean processEvent$lambda-4(Path $path, Map.Entry $dstr$key$child) {
        boolean bl;
        Intrinsics.checkNotNullParameter($path, "$path");
        Intrinsics.checkNotNullParameter($dstr$key$child, "$dstr$key$child");
        WatchKey key = (WatchKey)$dstr$key$child.getKey();
        Path child = (Path)$dstr$key$child.getValue();
        if (child.startsWith($path)) {
            key.cancel();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final void loadCosmetic$lambda-7$resetCosmetics(class_1657 $this$loadCosmetic_u24lambda_u2d7_u24resetCosmetics) {
        if ($this$loadCosmetic_u24lambda_u2d7_u24resetCosmetics instanceof AbstractClientPlayerExt) {
            ((AbstractClientPlayerExt)$this$loadCosmetic_u24lambda_u2d7_u24resetCosmetics).setEssentialCosmetics((ImmutableMap<CosmeticSlot, String>)ImmutableMap.of());
            ((AbstractClientPlayerExt)$this$loadCosmetic_u24lambda_u2d7_u24resetCosmetics).getEssentialCosmeticModels().clear();
        }
    }

    private static final void loadCosmetic$lambda-7(DevCosmeticsImpl this$0, String $cosmeticId, Function1 $substitution, String $cosmeticType) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($cosmeticId, "$cosmeticId");
        Intrinsics.checkNotNullParameter($substitution, "$substitution");
        Intrinsics.checkNotNullParameter($cosmeticType, "$cosmeticType");
        this$0.substitutions.put($cosmeticId, $substitution);
        CosmeticsManager cosmeticsManager = this$0.manager;
        Cosmetic cosmetic = this$0.originalCosmetics.get($cosmeticId);
        if (cosmetic == null) {
            cosmetic = (Cosmetic)$substitution.invoke(this$0.manager.getCosmetics().get($cosmeticId));
        }
        cosmeticsManager.addCosmetic(cosmetic);
        this$0.addCosmeticTypeIfMissing(this$0.manager, $cosmeticType);
        this$0.manager.addUnlockedCosmetics((Collection<String>)CollectionsKt.listOf($cosmeticId));
        ModelInstance.removeCache($cosmeticId);
        CosmeticStudio cosmeticStudio = CosmeticStudio.Companion.getInstance();
        if (cosmeticStudio != null) {
            EmulatedUI3DPlayer emulatedUI3DPlayer = cosmeticStudio.getPlayerDisplay();
            if (emulatedUI3DPlayer != null) {
                class_1657 class_16572 = emulatedUI3DPlayer.getPlayer();
                if (class_16572 != null) {
                    DevCosmeticsImpl.loadCosmetic$lambda-7$resetCosmetics(class_16572);
                }
            }
        }
        class_638 class_6382 = class_310.method_1551().field_1687;
        if (class_6382 != null) {
            List list = class_6382.method_18456();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    class_742 it = (class_742)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    DevCosmeticsImpl.loadCosmetic$lambda-7$resetCosmetics((class_1657)it);
                }
            }
        }
    }

    public static final /* synthetic */ boolean access$hashesEqual(DevCosmeticsImpl $this, CosmeticAssets $receiver, CosmeticAssets other) {
        return $this.hashesEqual($receiver, other);
    }

    public static final /* synthetic */ Map access$getOriginalCosmetics$p(DevCosmeticsImpl $this) {
        return $this.originalCosmetics;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001c\u0010\u0004\u001a\n \u0003*\u0004\u0018\u00010\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"Lgg/essential/network/cosmetics/dev/DevCosmeticsImpl$Companion;", "", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "<init>", "()V", "Essential 1.19-fabric"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

