/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.sps;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.Essential;
import gg.essential.connectionmanager.common.packet.upnp.ClientUPnPSessionClosePacket;
import gg.essential.connectionmanager.common.packet.upnp.ClientUPnPSessionCreatePacket;
import gg.essential.connectionmanager.common.packet.upnp.ClientUPnPSessionInvitesAddPacket;
import gg.essential.connectionmanager.common.packet.upnp.ClientUPnPSessionInvitesRemovePacket;
import gg.essential.connectionmanager.common.packet.upnp.ClientUPnPSessionPingProxyUpdatePacket;
import gg.essential.connectionmanager.common.packet.upnp.ClientUPnPSessionUpdatePacket;
import gg.essential.connectionmanager.common.packet.upnp.ServerUPnPSessionInviteAddPacket;
import gg.essential.connectionmanager.common.packet.upnp.ServerUPnPSessionPopulatePacket;
import gg.essential.connectionmanager.common.packet.upnp.ServerUPnPSessionRemovePacket;
import gg.essential.event.network.server.ServerJoinEvent;
import gg.essential.event.network.server.ServerLeaveEvent;
import gg.essential.gui.multiplayer.EssentialMultiplayerGui;
import gg.essential.handlers.UPnPWrapper;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.mixins.transformers.server.integrated.LanConnectionsAccessor;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.handler.upnp.ServerUPnPSessionInviteAddPacketHandler;
import gg.essential.network.connectionmanager.handler.upnp.ServerUPnPSessionPopulatePacketHandler;
import gg.essential.network.connectionmanager.handler.upnp.ServerUPnPSessionRemovePacketHandler;
import gg.essential.network.connectionmanager.queue.PacketQueue;
import gg.essential.network.connectionmanager.queue.SequentialPacketQueue;
import gg.essential.network.connectionmanager.sps.SPSState;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.wrappers.message.UTextComponent;
import gg.essential.upnp.UPnPPrivacy;
import gg.essential.upnp.model.UPnPSession;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.MinecraftUtils;
import gg.essential.util.Multithreading;
import gg.essential.util.UUIDUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import net.minecraft.class_1074;
import net.minecraft.class_1132;
import net.minecraft.class_1267;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3330;
import net.minecraft.class_3337;
import net.minecraft.class_3340;
import net.minecraft.class_3521;
import net.minecraft.class_642;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPSManager
implements NetworkedManager {
    public static final String SPS_SERVER_TLD = ".essential-sps";
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final PacketQueue updateQueue;
    @NotNull
    private final Object whitelistSemaphore = new Object();
    @NotNull
    private final Map<UUID, UPnPSession> remoteSessions = Maps.newConcurrentMap();
    @Nullable
    private CompletableFuture<Boolean> startFuture;
    @NotNull
    private SPSState localState = SPSState.INACTIVE;
    @Nullable
    private UPnPSession localSession;
    private class_1934 currentGameMode;
    private boolean allowCheats;
    private class_1267 difficulty;
    @Nullable
    private String serverStatusResponse;
    private String error;

    public SPSManager(@NotNull ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.updateQueue = new SequentialPacketQueue.Builder(connectionManager).onTimeoutRetransmit().create();
        connectionManager.registerPacketHandler(ServerUPnPSessionInviteAddPacket.class, new ServerUPnPSessionInviteAddPacketHandler());
        connectionManager.registerPacketHandler(ServerUPnPSessionPopulatePacket.class, new ServerUPnPSessionPopulatePacketHandler());
        connectionManager.registerPacketHandler(ServerUPnPSessionRemovePacket.class, new ServerUPnPSessionRemovePacketHandler());
        Runtime.getRuntime().addShutdownHook(new Thread(this::closeLocalSession));
    }

    @NotNull
    public String getSpsAddress(@NotNull UUID hostUUID) {
        return hostUUID.toString() + SPS_SERVER_TLD;
    }

    public class_1934 getCurrentGameMode() {
        return this.currentGameMode;
    }

    public boolean isAllowCheats() {
        return this.allowCheats;
    }

    public boolean isSpsAddress(String address) {
        return address.endsWith(SPS_SERVER_TLD);
    }

    @Nullable
    public UUID getHostFromSpsAddress(@NotNull String address) {
        if (!address.endsWith(SPS_SERVER_TLD)) {
            return null;
        }
        address = address.substring(0, address.length() - SPS_SERVER_TLD.length());
        try {
            return UUID.fromString(address);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    @Nullable
    public UPnPSession getSessionFromSpsAddress(@NotNull String address) {
        UUID hostUUID = this.getHostFromSpsAddress(address);
        if (hostUUID == null) {
            return null;
        }
        return this.getRemoteSession(hostUUID);
    }

    @Nullable
    public UPnPSession getRemoteSession(UUID hostUUID) {
        return this.remoteSessions.get(hostUUID);
    }

    @NotNull
    public Collection<UPnPSession> getRemoteSessions() {
        return Collections.unmodifiableCollection(this.remoteSessions.values());
    }

    public void addRemoteSession(@NotNull UPnPSession session) {
        this.remoteSessions.put(session.getHostUUID(), session);
        EssentialMultiplayerGui gui = EssentialMultiplayerGui.getInstance();
        if (gui != null) {
            gui.updateSpsSessions();
        }
    }

    public void removeRemoteSession(@NotNull UUID hostUUID) {
        this.remoteSessions.remove(hostUUID);
    }

    @NotNull
    public Set<UUID> getInvitedUsers() {
        UPnPSession session = this.localSession;
        return session != null ? session.getInvites() : Collections.emptySet();
    }

    public synchronized void updateInvitedUsers(Set<UUID> invited) {
        if (this.localSession == null) {
            throw new IllegalStateException("Cannot update invites while no session is active.");
        }
        invited = Collections.unmodifiableSet(new HashSet<UUID>(invited));
        Set<UUID> removed = SetsKt.minus(this.localSession.getInvites(), invited);
        Set<UUID> added = SetsKt.minus(invited, this.localSession.getInvites());
        if (!removed.isEmpty()) {
            this.updateQueue.enqueue(new ClientUPnPSessionInvitesRemovePacket(removed));
        }
        if (!added.isEmpty()) {
            this.updateQueue.enqueue(new ClientUPnPSessionInvitesAddPacket(added));
        }
        this.localSession = new UPnPSession(this.localSession.getHostUUID(), this.localSession.getIp(), this.localSession.getPort(), this.localSession.getPrivacy(), invited, this.localSession.getCreatedAt());
        Multithreading.runAsync(this::refreshWhitelist);
    }

    @NotNull
    public SPSState getLocalState() {
        return this.localState;
    }

    @Nullable
    public UPnPSession getLocalSession() {
        return this.localSession;
    }

    public class_1267 getDifficulty() {
        return this.difficulty;
    }

    public synchronized CompletableFuture<Boolean> startLocalSession(@NotNull class_1934 gameMode, class_1267 difficulty, boolean allowCheats, UPnPPrivacy privacy) {
        CompletableFuture<Boolean> inProgressFuture = this.startFuture;
        if (inProgressFuture != null) {
            return inProgressFuture;
        }
        this.currentGameMode = gameMode;
        this.allowCheats = allowCheats;
        this.difficulty = difficulty;
        this.localState = SPSState.OPENING;
        this.startFuture = CompletableFuture.supplyAsync(() -> {
            class_1132 server = UMinecraft.getMinecraft().method_1576();
            if (server == null) {
                return false;
            }
            server.method_3760().method_14557(true);
            server.method_3776(difficulty, true);
            int port = class_3521.method_15302();
            if (!server.method_3763(gameMode, allowCheats, port)) {
                this.error = "Unable to start LAN server.";
                return false;
            }
            Essential.logger.info("UPnP Init on port: {}", (Object)port);
            UPnPWrapper.UPnPStatus status = UPnPWrapper.openOnPort(port);
            if (status == UPnPWrapper.UPnPStatus.UNAVAILABLE) {
                this.error = "Failed to open UPnP. Your current router does not yet support it.";
                return false;
            }
            if (status == UPnPWrapper.UPnPStatus.FAILED) {
                this.error = "Failed to open UPnP. If issues persist contact support.";
                return false;
            }
            this.updateLocalSession(UPnPWrapper.ip, UPnPWrapper.port, privacy);
            String address = this.getSpsAddress(UUIDUtil.getClientUUID());
            class_642 serverData = new class_642("", address, false);
            serverData.method_2995(class_642.class_643.field_3767);
            Essential.EVENT_BUS.post(new ServerJoinEvent(serverData));
            return true;
        }, Multithreading.POOL).thenApply(success -> {
            this.localState = success != false ? SPSState.ACTIVE : SPSState.FAILED;
            this.startFuture = null;
            return success;
        });
        return this.startFuture;
    }

    public synchronized void updateLocalPrivacy(@NotNull UPnPPrivacy privacy) {
        UPnPSession session = this.localSession;
        if (session != null) {
            this.updateLocalSession(session.getIp(), session.getPort(), privacy);
        }
    }

    public synchronized void updateLocalSession(@NotNull String ip, int port, @NotNull UPnPPrivacy privacy) {
        UPnPSession oldSession = this.localSession;
        UPnPSession session = new UPnPSession(UUIDUtil.getClientUUID(), ip, port, privacy, oldSession != null ? oldSession.getInvites() : Collections.emptySet(), oldSession != null ? oldSession.getCreatedAt() : new DateTime());
        if (this.localSession == null) {
            this.updateQueue.enqueue(new ClientUPnPSessionCreatePacket(ip, port, privacy));
        } else {
            this.updateQueue.enqueue(new ClientUPnPSessionUpdatePacket(ip, port, privacy));
        }
        this.localSession = session;
        Multithreading.runAsync(this::refreshWhitelist);
    }

    public synchronized void closeLocalSession() {
        UPnPSession oldSession = this.localSession;
        if (oldSession != null) {
            Multithreading.runAsync(() -> {
                if (!UPnPWrapper.close(oldSession.getPort())) {
                    MinecraftUtils.INSTANCE.sendMessage("An error occurred closing the UPnP port");
                }
            });
        }
        this.currentGameMode = null;
        this.allowCheats = false;
        this.localState = SPSState.INACTIVE;
        this.localSession = null;
        this.updateQueue.enqueue(new ClientUPnPSessionClosePacket());
    }

    public void updateServerStatusResponse(@NotNull String updatedResponse) {
        if (this.localSession == null) {
            return;
        }
        if (updatedResponse.equals(this.serverStatusResponse)) {
            return;
        }
        this.serverStatusResponse = updatedResponse;
        ExtensionsKt.getExecutor(class_310.method_1551()).execute(() -> this.updateQueue.enqueue(new ClientUPnPSessionPingProxyUpdatePacket(updatedResponse)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshWhitelist() {
        Object object = this.whitelistSemaphore;
        synchronized (object) {
            this.doRefreshWhitelist();
        }
    }

    private void doRefreshWhitelist() {
        UPnPSession session = this.localSession;
        if (session == null) {
            return;
        }
        Set<UUID> invited = session.getPrivacy() == UPnPPrivacy.INVITE_ONLY ? session.getInvites() : new HashSet<UUID>(this.connectionManager.getRelationshipManager().getFriends().keySet());
        CollectionsKt.map(invited, UUIDUtil::getName).forEach(CompletableFuture::join);
        class_1132 server = UMinecraft.getMinecraft().method_1576();
        if (server == null) {
            return;
        }
        ExtensionsKt.getExecutor((MinecraftServer)server).execute(() -> {
            class_3337 whitelist = server.method_3760().method_14590();
            for (String userName : whitelist.method_14636()) {
                GameProfile profile = server.method_3793().method_14515(userName).orElse(null);
                if (profile == null || invited.contains(profile.getId())) continue;
                whitelist.method_14635((Object)profile);
            }
            for (UUID uuid : invited) {
                String userName;
                GameProfile profile = new GameProfile(uuid, userName = UUIDUtil.getName(uuid).join());
                if (whitelist.method_14640((Object)profile) != null) continue;
                whitelist.method_14633((class_3330)new class_3340(profile));
            }
            for (class_3222 entity : ((LanConnectionsAccessor)server.method_3760()).getPlayerEntityList()) {
                if (invited.contains(entity.method_5667()) || UUIDUtil.getClientUUID().equals(entity.method_5667())) continue;
                entity.field_13987.method_14367((class_2561)new UTextComponent(class_1074.method_4662((String)"multiplayer.disconnect.server_shutdown", (Object[])new Object[0])).getComponent());
            }
        });
    }

    @Subscribe
    private void onDisconnect(ServerLeaveEvent event) {
        this.closeLocalSession();
    }

    @Override
    public synchronized void onConnected() {
        this.updateQueue.reset();
        if (this.localSession != null) {
            Multithreading.runAsync(() -> {
                String ip = UPnPWrapper.refreshIp();
                SPSManager sPSManager = this;
                synchronized (sPSManager) {
                    UPnPSession session = this.localSession;
                    if (session != null) {
                        this.localSession = null;
                        this.updateLocalSession(ip, session.getPort(), session.getPrivacy());
                        this.updateInvitedUsers(session.getInvites());
                        String serverStatusResponse = this.serverStatusResponse;
                        if (serverStatusResponse != null) {
                            this.updateQueue.enqueue(new ClientUPnPSessionPingProxyUpdatePacket(serverStatusResponse));
                        }
                    }
                }
            });
        }
        this.resetState();
    }

    @Override
    public void resetState() {
        this.remoteSessions.clear();
    }

    public String getError() {
        return this.error;
    }

    public void updateWorldSettings(boolean cheats, @NotNull class_1934 gameType, @NotNull class_1267 difficulty) {
        class_1132 integratedServer = UMinecraft.getMinecraft().method_1576();
        if (integratedServer != null) {
            integratedServer.method_3838(gameType);
            integratedServer.method_3760().method_14607(cheats);
            integratedServer.method_3776(difficulty, true);
        }
        if (UMinecraft.getWorld() != null && !UMinecraft.getWorld().method_28104().method_197()) {
            UMinecraft.getWorld().method_28104().method_27875(difficulty);
        }
        this.allowCheats = cheats;
        this.currentGameMode = gameType;
        this.difficulty = difficulty;
    }
}

