/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.social.handler;

import gg.essential.api.utils.Multithreading;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.packet.social.SocialInviteToServerPacket;
import gg.essential.gui.notification.Notifications;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import gg.essential.network.connectionmanager.social.SocialManager;
import gg.essential.universal.UMinecraft;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.UUIDUtil;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_639;
import net.minecraft.class_642;
import org.jetbrains.annotations.NotNull;

public class SocialInviteToServerPacketHandler
extends PacketHandler<SocialInviteToServerPacket> {
    private final Set<UUID> cooldowns = Collections.newSetFromMap(new ConcurrentHashMap());
    @NotNull
    private final SocialManager socialManager;

    public SocialInviteToServerPacketHandler(@NotNull SocialManager socialManager) {
        this.socialManager = socialManager;
    }

    @Override
    protected void onHandle(@NotNull ConnectionManager connectionManager, @NotNull SocialInviteToServerPacket packet) {
        if (!EssentialConfig.INSTANCE.getEssentialFull()) {
            return;
        }
        this.socialManager.addIncomingServerInvite(packet.getUUID(), packet.getAddress());
        class_310 mc = UMinecraft.getMinecraft();
        if (this.cooldowns.contains(packet.getUUID())) {
            return;
        }
        this.cooldowns.add(packet.getUUID());
        Multithreading.schedule(() -> this.cooldowns.remove(packet.getUUID()), 7L, TimeUnit.SECONDS);
        UUIDUtil.getName(packet.getUUID()).thenAcceptAsync(hostName -> Notifications.INSTANCE.push("Server Invite", hostName + " has invited you to play with them on " + packet.getAddress(), () -> {
            class_437 currentScreen = mc.field_1755;
            if (currentScreen == null) {
                currentScreen = new class_442();
            }
            class_642 serverData = new class_642(hostName, packet.getAddress(), false);
            serverData.method_2995(class_642.class_643.field_3767);
            class_412.method_36877((class_437)currentScreen, (class_310)mc, (class_639)class_639.method_2950((String)serverData.field_3761), (class_642)serverData);
            this.socialManager.removeIncomingServerInvite(packet.getUUID());
            return Unit.INSTANCE;
        }), ExtensionsKt.getExecutor(mc));
    }
}

