/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.social;

import com.google.common.collect.Maps;
import gg.essential.connectionmanager.common.packet.social.SocialDiscordRequestJoinServerPacket;
import gg.essential.connectionmanager.common.packet.social.SocialInviteToServerCancelPacket;
import gg.essential.connectionmanager.common.packet.social.SocialInviteToServerPacket;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.social.handler.SocialDiscordRequestJoinServerPacketHandler;
import gg.essential.network.connectionmanager.social.handler.SocialInviteToServerCancelPacketHandler;
import gg.essential.network.connectionmanager.social.handler.SocialInviteToServerPacketHandler;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class SocialManager
implements NetworkedManager {
    @NotNull
    private final Map<UUID, String> incomingServerInvites = Maps.newConcurrentMap();
    @NotNull
    private final Map<String, Set<UUID>> invitedFriends = Maps.newConcurrentMap();

    public SocialManager(@NotNull ConnectionManager connectionManager) {
        connectionManager.registerPacketHandler(SocialInviteToServerPacket.class, new SocialInviteToServerPacketHandler(this));
        connectionManager.registerPacketHandler(SocialInviteToServerCancelPacket.class, new SocialInviteToServerCancelPacketHandler(this));
        connectionManager.registerPacketHandler(SocialDiscordRequestJoinServerPacket.class, new SocialDiscordRequestJoinServerPacketHandler());
    }

    @NotNull
    public Map<UUID, String> getIncomingServerInvites() {
        return this.incomingServerInvites;
    }

    @NotNull
    public Optional<String> getIncomingServerInvite(@NotNull UUID uuid) {
        return Optional.ofNullable(this.incomingServerInvites.get(uuid));
    }

    public void addIncomingServerInvite(@NotNull UUID uuid, @NotNull String address) {
        this.incomingServerInvites.put(uuid, address);
    }

    public void removeIncomingServerInvite(@NotNull UUID uuid) {
        this.incomingServerInvites.remove(uuid);
    }

    public Optional<Set<UUID>> getInvitesOnServer(String server) {
        return Optional.ofNullable(this.invitedFriends.get(server));
    }

    public void setInvitedFriendsOnServer(String server, Set<UUID> friends) {
        this.invitedFriends.put(server, friends);
    }

    @Override
    public void resetState() {
        this.invitedFriends.clear();
        this.incomingServerInvites.clear();
    }
}

