/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.serverdiscovery;

import com.google.common.collect.Maps;
import gg.essential.connectionmanager.common.packet.serverdiscovery.ClientServerDiscoveryRequestPopulatePacket;
import gg.essential.connectionmanager.common.packet.serverdiscovery.ServerServerDiscoveryPopulatePacket;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.serverdiscovery.handler.ServerServerDiscoveryPopulatePacketHandler;
import gg.essential.serverdiscovery.model.ServerDiscovery;
import gg.essential.util.MinecraftUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerDiscoveryManager
implements NetworkedManager,
Iterable<ServerDiscovery> {
    @NotNull
    private final Map<String, ServerDiscovery> servers = Maps.newConcurrentMap();
    private Map<String, ServerDiscovery> serversByAddress;
    private final ConnectionManager connectionManager;

    public ServerDiscoveryManager(@NotNull ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        connectionManager.registerPacketHandler(ServerServerDiscoveryPopulatePacket.class, new ServerServerDiscoveryPopulatePacketHandler(this));
    }

    @NotNull
    public Map<String, ServerDiscovery> getServers() {
        return this.servers;
    }

    @Nullable
    public ServerDiscovery getServer(@Nullable String id2) {
        return this.servers.get(id2);
    }

    @NotNull
    public Optional<ServerDiscovery> getServerOptional(@NotNull String id2) {
        return Optional.ofNullable(this.getServer(id2));
    }

    public void addServers(@NotNull Collection<ServerDiscovery> servers) {
        for (ServerDiscovery serverDiscovery : servers) {
            this.addServer(serverDiscovery);
        }
    }

    public void addServer(@NotNull ServerDiscovery serverDiscovery) {
        this.servers.put(serverDiscovery.getId(), serverDiscovery);
        this.serversByAddress = null;
    }

    public void removeServer(@NotNull ServerDiscovery serverDiscovery) {
        this.removeServer(serverDiscovery.getId());
    }

    public void removeServer(@NotNull String id2) {
        this.servers.remove(id2);
        this.serversByAddress = null;
    }

    @Override
    @NotNull
    public Iterator<ServerDiscovery> iterator() {
        return this.servers.values().iterator();
    }

    @Nullable
    public ServerDiscovery findServerByAddress(String address) {
        int subdomainLength;
        ServerDiscovery exactMatch;
        if (this.serversByAddress == null) {
            this.serversByAddress = Maps.newHashMap();
            for (ServerDiscovery server : this.servers.values()) {
                for (String serverAddress : server.getAddresses()) {
                    this.serversByAddress.put(serverAddress, server);
                }
            }
        }
        if ((exactMatch = this.serversByAddress.get(address)) != null) {
            return exactMatch;
        }
        String trimmedAddress = address;
        while ((subdomainLength = trimmedAddress.indexOf(46)) != -1) {
            ServerDiscovery wildcardMatch = this.serversByAddress.get("*." + (trimmedAddress = trimmedAddress.substring(subdomainLength + 1)));
            if (wildcardMatch == null) continue;
            this.serversByAddress.put(address, wildcardMatch);
            return wildcardMatch;
        }
        return null;
    }

    @NotNull
    public String normalizeAddress(@NotNull String address) {
        ServerDiscovery serverDiscovery = this.findServerByAddress(address);
        return serverDiscovery != null ? serverDiscovery.getAddresses().get(0) : address;
    }

    @Override
    public void onConnected() {
        this.resetState();
        this.connectionManager.send(new ClientServerDiscoveryRequestPopulatePacket(MinecraftUtils.getCurrentProtocolVersion()));
    }

    @Override
    public void resetState() {
        this.servers.clear();
        this.serversByAddress = null;
    }
}

