/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.relationship;

import com.google.common.collect.Maps;
import com.sparkuniverse.toolbox.relationships.enums.FriendRequestPrivacySetting;
import com.sparkuniverse.toolbox.relationships.enums.RelationshipState;
import com.sparkuniverse.toolbox.relationships.enums.RelationshipType;
import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.connectionmanager.common.model.relationships.Relationship;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.relationships.ClientRelationshipCreatePacket;
import gg.essential.connectionmanager.common.packet.relationships.RelationshipDeletePacket;
import gg.essential.connectionmanager.common.packet.relationships.ServerRelationshipCreateFailedResponsePacket;
import gg.essential.connectionmanager.common.packet.relationships.ServerRelationshipDeletePacket;
import gg.essential.connectionmanager.common.packet.relationships.ServerRelationshipPopulatePacket;
import gg.essential.connectionmanager.common.packet.relationships.privacy.FriendRequestPrivacySettingPacket;
import gg.essential.connectionmanager.common.packet.response.ResponseActionPacket;
import gg.essential.gui.friends.FriendsGui;
import gg.essential.gui.notification.Notifications;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.handler.relationships.FriendRequestPrivacySettingPacketHandler;
import gg.essential.network.connectionmanager.handler.relationships.ServerRelationshipDeletePacketHandler;
import gg.essential.network.connectionmanager.handler.relationships.ServerRelationshipPopulatePacketHandler;
import gg.essential.network.connectionmanager.relationship.FriendRequestState;
import gg.essential.network.connectionmanager.relationship.RelationshipResponse;
import gg.essential.util.Multithreading;
import gg.essential.util.UUIDUtil;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1074;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelationshipManager
implements NetworkedManager {
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final Map<UUID, Relationship> friends = Maps.newConcurrentMap();
    @NotNull
    private final Map<UUID, Relationship> outgoingFriendRequests = Maps.newConcurrentMap();
    @NotNull
    private final Map<UUID, Relationship> incomingFriendRequests = Maps.newConcurrentMap();
    @NotNull
    private final Map<UUID, Relationship> blockedByMe = Maps.newConcurrentMap();
    @NotNull
    private final Map<UUID, Relationship> blockedMe = Maps.newConcurrentMap();
    @NotNull
    private FriendRequestPrivacySetting friendRequestPrivacySetting = FriendRequestPrivacySetting.ANY_ONE;

    public RelationshipManager(@NotNull ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        connectionManager.registerPacketHandler(FriendRequestPrivacySettingPacket.class, new FriendRequestPrivacySettingPacketHandler());
        connectionManager.registerPacketHandler(ServerRelationshipDeletePacket.class, new ServerRelationshipDeletePacketHandler());
        connectionManager.registerPacketHandler(ServerRelationshipPopulatePacket.class, new ServerRelationshipPopulatePacketHandler());
    }

    @NotNull
    public Map<UUID, Relationship> getFriends() {
        return this.friends;
    }

    @NotNull
    public Map<UUID, Relationship> getOutgoingFriendRequests() {
        return this.outgoingFriendRequests;
    }

    @NotNull
    public Map<UUID, Relationship> getIncomingFriendRequests() {
        return this.incomingFriendRequests;
    }

    @NotNull
    public Map<UUID, Relationship> getBlockedMe() {
        return this.blockedMe;
    }

    @NotNull
    public Map<UUID, Relationship> getBlockedByMe() {
        return this.blockedByMe;
    }

    @NotNull
    public FriendRequestPrivacySetting getFriendRequestPrivacySetting() {
        return this.friendRequestPrivacySetting;
    }

    public void setFriendRequestPrivacySetting(@NotNull FriendRequestPrivacySetting friendRequestPrivacySetting) {
        this.friendRequestPrivacySetting = friendRequestPrivacySetting;
    }

    @NotNull
    public Optional<Relationship> getFriendOptional(@NotNull UUID uuid) {
        return Optional.ofNullable(this.getFriend(uuid));
    }

    @Nullable
    public Relationship getFriend(@NotNull UUID uuid) {
        return this.friends.get(uuid);
    }

    @NotNull
    public Optional<Relationship> getOutgoingFriendRequestOptional(@NotNull UUID uuid) {
        return Optional.ofNullable(this.getOutgoingFriendRequest(uuid));
    }

    @Nullable
    public Relationship getOutgoingFriendRequest(@NotNull UUID uuid) {
        return this.outgoingFriendRequests.get(uuid);
    }

    @NotNull
    public Optional<Relationship> getIncomingFriendRequestOptional(@NotNull UUID uuid) {
        return Optional.ofNullable(this.getIncomingFriendRequest(uuid));
    }

    @Nullable
    public Relationship getIncomingFriendRequest(@NotNull UUID uuid) {
        return this.incomingFriendRequests.get(uuid);
    }

    @NotNull
    public Optional<Relationship> getBlockedByMeOptional(@NotNull UUID uuid) {
        return Optional.ofNullable(this.getBlockedByMe(uuid));
    }

    @Nullable
    public Relationship getBlockedByMe(@NotNull UUID uuid) {
        return this.blockedByMe.get(uuid);
    }

    @NotNull
    public Optional<Relationship> getBlockedMeOptional(@NotNull UUID uuid) {
        return Optional.ofNullable(this.getBlockedMe(uuid));
    }

    @Nullable
    public Relationship getBlockedMe(@NotNull UUID uuid) {
        return this.blockedMe.get(uuid);
    }

    public boolean isFriend(@NotNull UUID uuid) {
        return this.friends.containsKey(uuid);
    }

    public boolean hasFriendRequest(@NotNull UUID uuid) {
        return this.hasOutgoingFriendRequest(uuid) || this.hasIncomingFriendRequest(uuid);
    }

    public boolean hasOutgoingFriendRequest(@NotNull UUID uuid) {
        return this.outgoingFriendRequests.containsKey(uuid);
    }

    public boolean hasIncomingFriendRequest(@NotNull UUID uuid) {
        return this.incomingFriendRequests.containsKey(uuid);
    }

    public boolean isBlockedByMe(@NotNull UUID uuid) {
        return this.blockedByMe.containsKey(uuid);
    }

    public boolean hasBlockedMe(@NotNull UUID uuid) {
        return this.blockedMe.containsKey(uuid);
    }

    public CompletableFuture<RelationshipResponse> createFriendRelationship(@NotNull UUID targetUUID, boolean acceptingRequest) {
        if (this.isFriend(targetUUID)) {
            Notifications.INSTANCE.push("Unable to send request", "This player is already your friend.");
            return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_HANDLED));
        }
        if (!acceptingRequest && this.hasFriendRequest(targetUUID)) {
            Notifications.INSTANCE.push("Unable to send request", "There is already a pending friend request to this player.");
            return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_HANDLED));
        }
        if (this.isBlockedByMe(targetUUID)) {
            Notifications.INSTANCE.push("Unable to send request", "This player is blocked. Unblock them before adding as a friend.");
            return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_HANDLED));
        }
        if (this.hasBlockedMe(targetUUID)) {
            Notifications.INSTANCE.push("Unable to send request", "This player has blocked you.");
            return CompletableFuture.completedFuture(new RelationshipResponse(FriendRequestState.ERROR_HANDLED));
        }
        return this.createRelationship(targetUUID, RelationshipType.FRIENDS);
    }

    public void createBlockedRelationship(@NotNull UUID uuid) {
        if (this.isBlockedByMe(uuid)) {
            Notifications.INSTANCE.push("Unable to block", "You already have this player blocked");
            return;
        }
        if (this.hasBlockedMe(uuid)) {
            Notifications.INSTANCE.push("Unable to block", "This player has already blocked you");
            return;
        }
        Notifications.INSTANCE.push("Blocked", "This player has been blocked");
        this.createRelationship(uuid, RelationshipType.BLOCKED);
    }

    public void createRelationship(@NotNull Relationship relationship) {
        UUID ourUUID = this.connectionManager.getMinecraftHook().getPlayerUUID();
        boolean areWeTheSender = relationship.getSenderUUID().equals(ourUUID);
        UUID targetUUID = areWeTheSender ? relationship.getTargetUUID() : relationship.getSenderUUID();
        switch (relationship.getType()) {
            case NEUTRAL: {
                this.friends.remove(targetUUID);
                this.outgoingFriendRequests.remove(targetUUID);
                this.incomingFriendRequests.remove(targetUUID);
                this.blockedMe.remove(targetUUID);
                this.blockedByMe.remove(targetUUID);
                break;
            }
            case FRIENDS: {
                switch (relationship.getState()) {
                    case PENDING: {
                        this.friends.remove(targetUUID);
                        this.blockedMe.remove(targetUUID);
                        this.blockedByMe.remove(targetUUID);
                        if (areWeTheSender) {
                            this.outgoingFriendRequests.put(targetUUID, relationship);
                            break;
                        }
                        this.incomingFriendRequests.put(targetUUID, relationship);
                        break;
                    }
                    case VERIFIED: {
                        this.outgoingFriendRequests.remove(targetUUID);
                        this.incomingFriendRequests.remove(targetUUID);
                        this.blockedMe.remove(targetUUID);
                        this.blockedByMe.remove(targetUUID);
                        this.friends.put(targetUUID, relationship);
                        break;
                    }
                    case DECLINED: {
                        this.friends.remove(targetUUID);
                        this.outgoingFriendRequests.remove(targetUUID);
                        this.incomingFriendRequests.remove(targetUUID);
                        this.blockedMe.remove(targetUUID);
                        this.blockedByMe.remove(targetUUID);
                    }
                }
                break;
            }
            case BLOCKED: {
                this.friends.remove(targetUUID);
                this.outgoingFriendRequests.remove(targetUUID);
                this.incomingFriendRequests.remove(targetUUID);
                if (areWeTheSender) {
                    this.blockedByMe.put(targetUUID, relationship);
                    break;
                }
                this.blockedMe.put(targetUUID, relationship);
            }
        }
        FriendsGui fg = FriendsGui.getInstance();
        if (fg != null) {
            fg.updateRelationship(targetUUID, relationship);
        }
        Multithreading.runAsync(this.connectionManager.getSpsManager()::refreshWhitelist);
    }

    public CompletableFuture<RelationshipResponse> createRelationship(@NotNull UUID targetUUID, @NotNull RelationshipType type2) {
        CompletableFuture<RelationshipResponse> future2 = new CompletableFuture<RelationshipResponse>();
        this.connectionManager.send(new ClientRelationshipCreatePacket(targetUUID, type2), responseOptional -> {
            if (!responseOptional.isPresent()) {
                Notifications.INSTANCE.push("Error", "A timeout occurred please try again");
            }
            future2.complete(responseOptional.map(packet -> {
                if (packet instanceof ServerRelationshipCreateFailedResponsePacket) {
                    return new RelationshipResponse(FriendRequestState.ERROR_UNHANDLED, class_1074.method_4662((String)("connectionmanager.friends." + ((ServerRelationshipCreateFailedResponsePacket)packet).getReason()), (Object[])new Object[0]));
                }
                if (!(packet instanceof ServerRelationshipPopulatePacket)) {
                    return new RelationshipResponse(FriendRequestState.ERROR_UNHANDLED, "An unknown error occurred");
                }
                return new RelationshipResponse(((ServerRelationshipPopulatePacket)packet).getRelationships()[0].getState() != RelationshipState.DECLINED ? FriendRequestState.SENT : FriendRequestState.ERROR_UNHANDLED);
            }).orElse(new RelationshipResponse(FriendRequestState.ERROR_HANDLED, "An unknown error occurred")));
        });
        return future2;
    }

    public void removeRelationship(@NotNull Relationship relationship) {
        UUID ourUUID = this.connectionManager.getMinecraftHook().getPlayerUUID();
        boolean areWeTheSender = relationship.getSenderUUID().equals(ourUUID);
        UUID targetUUID = areWeTheSender ? relationship.getTargetUUID() : relationship.getSenderUUID();
        switch (relationship.getType()) {
            case FRIENDS: {
                if (relationship.isPending()) {
                    if (areWeTheSender) {
                        this.outgoingFriendRequests.remove(targetUUID);
                        break;
                    }
                    this.incomingFriendRequests.remove(targetUUID);
                    break;
                }
                this.friends.remove(targetUUID);
                break;
            }
            case BLOCKED: {
                if (areWeTheSender) {
                    this.blockedByMe.remove(targetUUID);
                    break;
                }
                this.blockedMe.remove(targetUUID);
            }
        }
        FriendsGui fg = FriendsGui.getInstance();
        if (fg != null) {
            fg.updateRelationship(targetUUID, new Relationship(UUIDUtil.getClientUUID(), targetUUID, RelationshipType.NEUTRAL, RelationshipState.VERIFIED, new DateTime()));
        }
        Multithreading.runAsync(this.connectionManager.getSpsManager()::refreshWhitelist);
    }

    public void deleteRelationship(@NotNull UUID targetUUID, @NotNull RelationshipType type2) {
        this.connectionManager.send(new RelationshipDeletePacket(targetUUID, type2), responseOptional -> {
            if (!responseOptional.isPresent()) {
                Notifications.INSTANCE.push("Error", "A timeout occurred please try again");
                return;
            }
            Packet responsePacket = (Packet)responseOptional.get();
            if (!(responsePacket instanceof ResponseActionPacket)) {
                if (responsePacket instanceof ServerRelationshipCreateFailedResponsePacket) {
                    Notifications.INSTANCE.push("Error", class_1074.method_4662((String)("connectionmanager.friends." + ((ServerRelationshipCreateFailedResponsePacket)responsePacket).getReason()), (Object[])new Object[0]));
                }
                return;
            }
            ResponseActionPacket response2 = (ResponseActionPacket)responsePacket;
            if (!response2.isSuccessful()) {
                return;
            }
            this.outgoingFriendRequests.remove(targetUUID);
            this.incomingFriendRequests.remove(targetUUID);
            this.friends.remove(targetUUID);
            this.blockedByMe.remove(targetUUID);
            this.blockedMe.remove(targetUUID);
            FriendsGui fg = FriendsGui.getInstance();
            if (fg != null) {
                fg.updateRelationship(targetUUID, new Relationship(UUIDUtil.getClientUUID(), targetUUID, RelationshipType.NEUTRAL, RelationshipState.VERIFIED, new DateTime()));
            }
            Multithreading.runAsync(this.connectionManager.getSpsManager()::refreshWhitelist);
        });
    }

    public void unblock(@NotNull UUID user) {
        Relationship block = this.blockedByMe.get(user);
        if (block != null) {
            this.deleteRelationship(user, RelationshipType.BLOCKED);
        }
    }

    public void block(@NotNull UUID otherParticipant) {
        this.createBlockedRelationship(otherParticipant);
    }

    public void removeFriend(@NotNull UUID otherUser) {
        Relationship friendRelationship = this.friends.get(otherUser);
        if (friendRelationship != null) {
            this.deleteRelationship(otherUser, friendRelationship.getType());
        }
    }

    public CompletableFuture<RelationshipResponse> acceptFriend(@NotNull UUID user) {
        return this.createFriendRelationship(user, true);
    }

    public void denyFriend(@NotNull UUID user) {
        Relationship request = this.incomingFriendRequests.get(user);
        if (request != null) {
            this.removeRelationship(request);
            this.deleteRelationship(user, RelationshipType.FRIENDS);
        }
    }

    public void cancelFriendRequest(@NotNull UUID user) {
        Relationship request = this.outgoingFriendRequests.get(user);
        if (request != null) {
            this.removeRelationship(request);
            this.deleteRelationship(user, RelationshipType.FRIENDS);
        }
    }

    public CompletableFuture<RelationshipResponse> addFriend(@NotNull UUID uuid) {
        return this.createFriendRelationship(uuid, false);
    }

    @Override
    public void onConnected() {
        this.friendRequestPrivacySetting = FriendRequestPrivacySetting.ANY_ONE;
        this.resetState();
    }

    @Override
    public void resetState() {
        this.blockedMe.clear();
        this.blockedByMe.clear();
        this.incomingFriendRequests.clear();
        this.outgoingFriendRequests.clear();
        this.friends.clear();
    }
}

