/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.queue;

import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.queue.PacketQueue;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SequentialPacketQueue
implements PacketQueue {
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final TimeoutPolicy timeoutPolicy;
    @NotNull
    private final Queue<Pair<Packet, Consumer<Optional<Packet>>>> queue = new ArrayDeque<Pair<Packet, Consumer<Optional<Packet>>>>();
    @Nullable
    private Pair<Packet, Consumer<Optional<Packet>>> waitingFor;

    public SequentialPacketQueue(@NotNull ConnectionManager connectionManager, @NotNull TimeoutPolicy timeoutPolicy) {
        this.connectionManager = connectionManager;
        this.timeoutPolicy = timeoutPolicy;
    }

    @Override
    public synchronized void enqueue(Packet packet, Consumer<Optional<Packet>> responseCallback) {
        this.queue.add(new Pair<Packet, Consumer<Optional<Packet>>>(packet, responseCallback));
        this.process();
    }

    private void process() {
        if (this.waitingFor != null) {
            return;
        }
        Pair<Packet, Consumer<Optional<Packet>>> next = this.queue.poll();
        if (next == null) {
            return;
        }
        this.waitingFor = next;
        if (this.connectionManager.isOpen() && this.connectionManager.isAuthenticated()) {
            this.connectionManager.send(next.getFirst(), resp -> this.handleResponse(next, (Optional<Packet>)resp));
        }
    }

    private synchronized void handleResponse(@NotNull Pair<Packet, Consumer<Optional<Packet>>> request, Optional<Packet> response2) {
        if (this.waitingFor != request) {
            return;
        }
        if (response2.isPresent() || this.timeoutPolicy == TimeoutPolicy.SKIP) {
            this.waitingFor = null;
            Consumer<Optional<Packet>> responseCallback = request.getSecond();
            if (responseCallback != null) {
                responseCallback.accept(response2);
            }
        } else if (this.connectionManager.isOpen() && this.connectionManager.isAuthenticated()) {
            this.connectionManager.send(request.getFirst(), resp -> this.handleResponse(request, (Optional<Packet>)resp));
        }
        this.process();
    }

    @Override
    public synchronized void reset() {
        this.queue.clear();
        this.waitingFor = null;
    }

    public static enum TimeoutPolicy {
        RETRANSMIT,
        SKIP;

    }

    public static class Builder {
        @NotNull
        private final ConnectionManager connectionManager;
        @NotNull
        private TimeoutPolicy timeoutPolicy = TimeoutPolicy.RETRANSMIT;

        public Builder(@NotNull ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
        }

        public Builder onTimeoutRetransmit() {
            return this.setTimeoutPolicy(TimeoutPolicy.SKIP);
        }

        public Builder onTimeoutSkip() {
            return this.setTimeoutPolicy(TimeoutPolicy.SKIP);
        }

        public Builder setTimeoutPolicy(@NotNull TimeoutPolicy timeoutPolicy) {
            this.timeoutPolicy = timeoutPolicy;
            return this;
        }

        public SequentialPacketQueue create() {
            return new SequentialPacketQueue(this.connectionManager, this.timeoutPolicy);
        }
    }
}

