/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.profile;

import com.google.common.collect.Maps;
import com.sparkuniverse.toolbox.chat.enums.ChannelType;
import com.sparkuniverse.toolbox.chat.model.Channel;
import gg.essential.api.gui.Slot;
import gg.essential.api.utils.Multithreading;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.enums.ActivityType;
import gg.essential.connectionmanager.common.enums.ProfileStatus;
import gg.essential.connectionmanager.common.packet.profile.ClientProfileActivityPacket;
import gg.essential.connectionmanager.common.packet.profile.ServerProfileActivityPacket;
import gg.essential.connectionmanager.common.packet.profile.ServerProfileStatusPacket;
import gg.essential.connectionmanager.common.packet.profile.trustedhosts.ServerProfileTrustedHostsClearPacket;
import gg.essential.connectionmanager.common.packet.profile.trustedhosts.ServerProfileTrustedHostsPopulatePacket;
import gg.essential.connectionmanager.common.packet.profile.trustedhosts.ServerProfileTrustedHostsRemovePacket;
import gg.essential.elementa.ElementaVersion;
import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.constraints.PixelConstraint;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.gui.friends.FriendsGui;
import gg.essential.gui.friends.previews.ChatBasedPreview;
import gg.essential.gui.multiplayer.EssentialMultiplayerGui;
import gg.essential.gui.notification.Notifications;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.handler.profile.ServerProfileActivityPacketHandler;
import gg.essential.network.connectionmanager.handler.profile.ServerProfileStatusPacketHandler;
import gg.essential.network.connectionmanager.handler.profile.trustedhosts.ServerProfileTrustedHostsClearPacketHandler;
import gg.essential.network.connectionmanager.handler.profile.trustedhosts.ServerProfileTrustedHostsPopulatePacketHandler;
import gg.essential.network.connectionmanager.handler.profile.trustedhosts.ServerProfileTrustedHostsRemovePacketHandler;
import gg.essential.network.connectionmanager.queue.PacketQueue;
import gg.essential.network.connectionmanager.queue.SequentialPacketQueue;
import gg.essential.network.connectionmanager.subscription.SubscriptionManager;
import gg.essential.profiles.model.TrustedHost;
import gg.essential.util.CachedAvatarImage;
import gg.essential.util.GuiUtil;
import gg.essential.util.UUIDUtil;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import kotlin.Unit;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfileManager
implements NetworkedManager,
SubscriptionManager.Listener {
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final Map<UUID, ProfileStatus> statuses = Maps.newConcurrentMap();
    @NotNull
    private final Map<UUID, Pair<ActivityType, String>> activities = Maps.newConcurrentMap();
    @NotNull
    private final Map<String, TrustedHost> trustedHosts = Maps.newConcurrentMap();
    @NotNull
    private final PacketQueue updateQueue;

    public ProfileManager(@NotNull ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.updateQueue = new SequentialPacketQueue.Builder(connectionManager).onTimeoutSkip().create();
        connectionManager.registerPacketHandler(ServerProfileActivityPacket.class, new ServerProfileActivityPacketHandler());
        connectionManager.registerPacketHandler(ServerProfileStatusPacket.class, new ServerProfileStatusPacketHandler());
        connectionManager.registerPacketHandler(ServerProfileTrustedHostsClearPacket.class, new ServerProfileTrustedHostsClearPacketHandler());
        connectionManager.registerPacketHandler(ServerProfileTrustedHostsPopulatePacket.class, new ServerProfileTrustedHostsPopulatePacketHandler());
        connectionManager.registerPacketHandler(ServerProfileTrustedHostsRemovePacket.class, new ServerProfileTrustedHostsRemovePacketHandler());
    }

    @NotNull
    public Map<UUID, ProfileStatus> getStatuses() {
        return this.statuses;
    }

    @NotNull
    public Map<UUID, Pair<ActivityType, String>> getActivities() {
        return this.activities;
    }

    @NotNull
    public Map<String, TrustedHost> getTrustedHosts() {
        return this.trustedHosts;
    }

    @Nullable
    public ProfileStatus getStatus() {
        return this.getStatus(UUIDUtil.getClientUUID());
    }

    @Nullable
    public ActivityType getActivityType() {
        return this.getActivity(UUIDUtil.getClientUUID()).map(Pair::getLeft).orElse(null);
    }

    @Nullable
    public String getActivityMetadata() {
        return this.getActivity(UUIDUtil.getClientUUID()).map(Pair::getRight).orElse(null);
    }

    @NotNull
    public ProfileStatus getStatus(@NotNull UUID uuid) {
        return this.getStatusIfLoaded(uuid).orElse(ProfileStatus.OFFLINE);
    }

    @NotNull
    public Optional<ProfileStatus> getStatusIfLoaded(@NotNull UUID uuid) {
        return Optional.ofNullable(this.statuses.get(uuid));
    }

    @NotNull
    public Optional<Pair<ActivityType, String>> getActivity(@NotNull UUID uuid) {
        return Optional.ofNullable(this.activities.get(uuid));
    }

    @NotNull
    public Optional<TrustedHost> getTrustedHost(@NotNull String id2) {
        return Optional.ofNullable(this.trustedHosts.get(id2));
    }

    public void setPlayerStatus(@NotNull UUID uuid, @Nullable ProfileStatus status) {
        FriendsGui gui;
        if (status == null) {
            this.removePlayerStatus(uuid);
            return;
        }
        ProfileStatus put = this.statuses.put(uuid, status);
        if (put == ProfileStatus.OFFLINE && status == ProfileStatus.ONLINE && this.connectionManager.getRelationshipManager().isFriend(uuid) && EssentialConfig.INSTANCE.getFriendConnectionStatus()) {
            UUIDUtil.getName(uuid).thenAcceptAsync(s -> Notifications.INSTANCE.push("Friends", s + " is now online!", 4.0f, () -> {
                ChatBasedPreview cbp;
                FriendsGui gui = FriendsGui.getInstance();
                Channel channel = null;
                for (Channel value2 : this.connectionManager.getChatManager().getChannels().values()) {
                    if (value2.getType() != ChannelType.DIRECT_MESSAGE || !value2.getMembers().contains(uuid)) continue;
                    channel = value2;
                    break;
                }
                if (gui == null) {
                    GuiUtil.INSTANCE.openScreen(new FriendsGui(channel == null ? null : Long.valueOf(channel.getId())));
                } else if (channel != null && (cbp = gui.getTabs().getAllTab().get(channel.getId())) != null) {
                    gui.openMessageScreen(cbp);
                }
                return Unit.INSTANCE;
            }, () -> Unit.INSTANCE, notificationBuilder -> {
                notificationBuilder.setElementaVersion(ElementaVersion.V1);
                UIImage playerHead = ComponentsKt.constrain(CachedAvatarImage.ofUUID(uuid), constraints -> {
                    constraints.setWidth(new PixelConstraint(25.0f));
                    constraints.setHeight(new PixelConstraint(25.0f));
                    return Unit.INSTANCE;
                });
                notificationBuilder.withCustomComponent(Slot.PREVIEW, playerHead);
                return Unit.INSTANCE;
            }), (Executor)Multithreading.getPool());
        }
        if ((gui = FriendsGui.getInstance()) != null) {
            gui.updatePlayerStatus(uuid, status);
        }
    }

    public void setPlayerActivity(@NotNull UUID uuid, @Nullable ActivityType activityType, @Nullable String metadata2) {
        if (activityType == null || metadata2 == null) {
            if (this.connectionManager.getSocialManager().getIncomingServerInvite(uuid).isPresent()) {
                this.connectionManager.getSocialManager().removeIncomingServerInvite(uuid);
            }
            this.removePlayerActivity(uuid);
            return;
        }
        this.activities.put(uuid, (Pair<ActivityType, String>)Pair.of((Object)((Object)activityType), (Object)metadata2));
        EssentialMultiplayerGui gui = EssentialMultiplayerGui.getInstance();
        if (gui != null) {
            gui.updatePlayerActivity(uuid);
        }
    }

    public void updatePlayerActivity(@Nullable ActivityType activityType, @Nullable String metadata2) {
        this.setPlayerActivity(UUIDUtil.getClientUUID(), activityType, metadata2);
        this.updateQueue.enqueue(new ClientProfileActivityPacket(activityType, metadata2));
    }

    public void addTrustedHost(@NotNull TrustedHost trustedHost) {
        this.trustedHosts.put(trustedHost.getId(), trustedHost);
    }

    public void removePlayerStatus(@NotNull UUID uuid) {
        this.statuses.remove(uuid);
        FriendsGui gui = FriendsGui.getInstance();
        if (gui != null) {
            gui.updatePlayerStatus(uuid, ProfileStatus.OFFLINE);
        }
    }

    public void removePlayerActivity(@NotNull UUID uuid) {
        this.activities.remove(uuid);
        EssentialMultiplayerGui gui = EssentialMultiplayerGui.getInstance();
        if (gui != null) {
            gui.updatePlayerActivity(uuid);
        }
    }

    public void removeTrustedHost(@NotNull String id2) {
        this.trustedHosts.remove(id2);
    }

    public void clearTrustedHosts() {
        this.trustedHosts.clear();
    }

    @Override
    public void onConnected() {
        Optional<Pair<ActivityType, String>> clientActivity = this.getActivity(UUIDUtil.getClientUUID());
        this.resetState();
        clientActivity.ifPresent(activity -> this.updatePlayerActivity((ActivityType)((Object)((Object)activity.getLeft())), (String)activity.getRight()));
    }

    @Override
    public void resetState() {
        this.updateQueue.reset();
        this.trustedHosts.clear();
        this.activities.clear();
        this.statuses.clear();
    }

    @Override
    public void onSubscriptionRemoved(@NotNull Set<UUID> uuids) {
        for (UUID uuid : uuids) {
            if (this.connectionManager.getRelationshipManager().isFriend(uuid)) continue;
            this.removePlayerActivity(uuid);
        }
    }
}

