/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.ice.util;

import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.CandidateType;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.ice.RemoteCandidate;
import java.util.ArrayList;
import kotlin.collections.CollectionsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CandidateUtil {
    private static final Logger LOGGER = LogManager.getLogger(CandidateUtil.class);

    public static String candidateToString(LocalCandidate candidate) {
        ArrayList<Object> components = new ArrayList<Object>(12);
        components.add(candidate.getFoundation());
        components.add(candidate.getParentComponent().getComponentID());
        components.add((Object)candidate.getTransport());
        components.add(candidate.getPriority());
        components.add(candidate.getTransportAddress().getHostAddress());
        components.add(candidate.getTransportAddress().getPort());
        components.add("typ");
        components.add((Object)candidate.getType());
        TransportAddress relatedAddress = candidate.getRelatedAddress();
        if (relatedAddress != null) {
            components.add("raddr");
            components.add(relatedAddress.getHostAddress());
            components.add("rport");
            components.add(relatedAddress.getPort());
        }
        return CollectionsKt.joinToString(components, " ", "", "", -1, "", Object::toString);
    }

    public static RemoteCandidate candidateFromString(String string, Component component2) {
        try {
            String[] parts = string.split(" ");
            String foundation = parts[0];
            int componentID = Integer.parseInt(parts[1]);
            if (componentID != component2.getComponentID()) {
                throw new IllegalArgumentException("Expected candidate for component id " + component2.getComponentID());
            }
            Transport transport = Transport.parse(parts[2]);
            long priority = Long.parseLong(parts[3]);
            String address = parts[4];
            int port = Integer.parseInt(parts[5]);
            CandidateType type2 = CandidateType.parse(parts[7]);
            RemoteCandidate relatedCandidate = null;
            if (parts.length >= 12) {
                String relatedAddress = parts[9];
                int relatedPort = Integer.parseInt(parts[11]);
                TransportAddress relatedTransportAddress = new TransportAddress(relatedAddress, relatedPort, Transport.UDP);
                relatedCandidate = component2.findRemoteCandidate(relatedTransportAddress);
            }
            TransportAddress transportAddress = new TransportAddress(address, port, transport);
            return new RemoteCandidate(transportAddress, component2, type2, foundation, priority, relatedCandidate);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to parse candidate \"" + string + "\":", (Throwable)e);
            return null;
        }
    }
}

